/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor;

import com.vcobol.plugins.editor.VcobolDoubleClickSelector;
import com.vcobol.plugins.editor.VcobolEditor;
import com.vcobol.plugins.editor.VcobolEditorPlugin;
import com.vcobol.plugins.editor.debug.DisplayVariableTextHover;
import com.veryant.commons.editor.util.IsFragment;
import com.veryant.commons.editor.util.VarDecl;
import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

public class DisplayCobolElementTextHover
implements ITextHover {
    private VcobolDoubleClickSelector dblClickSelector = new VcobolDoubleClickSelector();
    private VcobolEditor editor;
    private DisplayVariableTextHover displayVarHover = new DisplayVariableTextHover();

    public DisplayCobolElementTextHover(VcobolEditor editor) {
        this.editor = editor;
    }

    private SimpleMarkerAnnotation findMarkerAnnotation(ISourceViewer textViewer, int line) {
        try {
            IRegion info = textViewer.getDocument().getLineInformation(line);
            IAnnotationModel model = textViewer.getAnnotationModel();
            if (model != null) {
                Iterator it = model.getAnnotationIterator();
                while (it.hasNext()) {
                    Position p;
                    Annotation a = (Annotation)it.next();
                    if (!(a instanceof SimpleMarkerAnnotation) || (p = model.getPosition(a)) == null || !p.overlapsWith(info.getOffset(), info.getLength())) continue;
                    return (SimpleMarkerAnnotation)a;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        AnnotationModel am;
        String Return = this.displayVarHover.getHoverInfo(textViewer, hoverRegion);
        if (Return == null) {
            try {
                SimpleMarkerAnnotation markerAnn = this.findMarkerAnnotation((ISourceViewer)textViewer, textViewer.getDocument().getLineOfOffset(hoverRegion.getOffset()));
                if (markerAnn != null) {
                    Return = "______STANDARD_CONTENT_TYPE" + markerAnn.getText();
                }
            }
            catch (BadLocationException markerAnn) {
                // empty catch block
            }
        }
        if (Return == null) {
            boolean showTooltip = VcobolEditorPlugin.getDefault().getPreferenceStore().getBoolean("vcobol.showtooltipmousehover.enabled");
            if (hoverRegion != null && showTooltip) {
                try {
                    this.dblClickSelector.init(textViewer, hoverRegion.getOffset());
                    if (this.dblClickSelector.matchWord()) {
                        int start = this.dblClickSelector.getStartPosition();
                        int length = this.dblClickSelector.getEndPosition() - start;
                        if (length > 0) {
                            String selectionText = textViewer.getDocument().get(start, length).trim();
                            IsFragment fr = this.editor.findSelectedFragment(selectionText);
                            Return = this.getDescription(fr);
                        }
                    }
                }
                catch (BadLocationException start) {
                    // empty catch block
                }
            }
        }
        if (Return == null && (am = (AnnotationModel)this.editor.getViewer().getAnnotationModel()) != null) {
            Iterator it = am.getAnnotationIterator();
            while (it.hasNext()) {
                IMarker marker;
                int severity;
                Position p;
                Annotation a = (Annotation)it.next();
                if (!(a instanceof SimpleMarkerAnnotation) || (p = am.getPosition(a)) == null || !p.overlapsWith(hoverRegion.getOffset(), hoverRegion.getLength()) || (severity = (marker = ((SimpleMarkerAnnotation)a).getMarker()).getAttribute("severity", 0)) != 2 && severity != 1 || (Return = marker.getAttribute("message", null)) == null) continue;
                Return = "______STANDARD_CONTENT_TYPE" + Return;
            }
        }
        return Return;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        Point selection = textViewer.getSelectedRange();
        if (selection.x <= offset && offset < selection.x + selection.y) {
            return new Region(selection.x, selection.y);
        }
        return new Region(offset, 0);
    }

    private String getDescription(IsFragment fr) {
        if (fr == null) {
            return null;
        }
        if (fr instanceof VarDecl) {
            StringBuffer buf = new StringBuffer("______STANDARD_CONTENT_TYPE");
            VarDecl vd = (VarDecl)fr;
            int level = vd.getLevel();
            if (level < 10) {
                buf.append("0");
            }
            buf.append(String.valueOf(level) + " ");
            buf.append(vd.getName());
            if (vd.hasChildren()) {
                buf.append(" group-item");
            } else if (vd.isObjectReference()) {
                buf.append(" object reference " + vd.getTypename());
            } else if (vd.getGraphicControlType() >= 0) {
                buf.append(" ");
                switch (vd.getGraphicControlType()) {
                    case 1: {
                        buf.append("Label");
                        break;
                    }
                    case 2: {
                        buf.append("Entry-Field");
                        break;
                    }
                    case 3: {
                        buf.append("Push-Button");
                        break;
                    }
                    case 4: {
                        buf.append("Check-Box");
                        break;
                    }
                    case 5: {
                        buf.append("Radio-Button");
                        break;
                    }
                    case 6: {
                        buf.append("Scroll-Bar");
                        break;
                    }
                    case 7: {
                        buf.append("List-Box");
                        break;
                    }
                    case 8: {
                        buf.append("Combo-Box");
                        break;
                    }
                    case 9: {
                        buf.append("Frame");
                        break;
                    }
                    case 10: {
                        buf.append("Tab-Control");
                        break;
                    }
                    case 11: {
                        buf.append("Bar");
                        break;
                    }
                    case 12: {
                        buf.append("Grid");
                        break;
                    }
                    case 13: {
                        buf.append("Bitmap");
                        break;
                    }
                    case 14: {
                        buf.append("Tree-View");
                        break;
                    }
                    case 15: {
                        buf.append("Web-Browser");
                        break;
                    }
                    case 16: {
                        buf.append("Ole");
                        break;
                    }
                    case 17: {
                        buf.append("Status-Bar");
                        break;
                    }
                    case 18: {
                        buf.append("Slider");
                        break;
                    }
                    case 19: {
                        buf.append("Java-Bean");
                        break;
                    }
                    case 20: {
                        buf.append("Date-Entry");
                        break;
                    }
                    default: {
                        buf.append("Unknown type");
                        break;
                    }
                }
            } else {
                if (vd.getPicture() != null) {
                    buf.append(" pic " + vd.getPicture());
                }
                if (vd.getUsage() != null) {
                    buf.append(" " + vd.getUsage());
                }
                if (vd.getValue() != null) {
                    buf.append(" value " + vd.getValue());
                }
            }
            return buf.toString();
        }
        return null;
    }
}

