/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor;

import com.vcobol.plugins.editor.VcobolEditor;
import com.vcobol.plugins.editor.VcobolEditorPlugin;
import com.vcobol.plugins.editor.VresourceBundle;
import com.vcobol.plugins.editor.actions.ToggleCommentAction;
import org.eclipse.core.commands.operations.UndoContext;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.editors.text.TextEditorActionContributor;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;

public class VcobolActionContributor
extends TextEditorActionContributor {
    public static final String rcsid = "$Id: IscobolActionContributor.java,v 1.8 2008/02/27 14:36:41 gianni Exp $";
    private VcobolEditor editor;
    private RetargetAction undo;
    private RetargetAction redo;
    private ToggleCommentAction toggleComment;

    public VcobolActionContributor() {
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        this.undo = new RetargetAction(ActionFactory.UNDO.getId(), VresourceBundle.getString((String)"undoactioncontr.name"), 1);
        this.undo.setToolTipText(VresourceBundle.getString((String)"undotypingactioncontr.name"));
        this.undo.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_UNDO"));
        this.undo.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_UNDO_DISABLED"));
        this.redo = new RetargetAction(ActionFactory.REDO.getId(), VresourceBundle.getString((String)"redoactioncontr.name"), 1);
        this.redo.setToolTipText(VresourceBundle.getString((String)"redotypingactioncontr.name"));
        this.redo.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_REDO"));
        this.redo.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_REDO_DISABLED"));
        this.toggleComment = new ToggleCommentAction(VresourceBundle.getString((String)"toggleCommentAction.label"), VresourceBundle.getString((String)"toggleCommentAction.tooltip"), VcobolEditorPlugin.getDefault().getImageProvider().getDescriptor("/togglecomment.gif"));
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        super.contributeToToolBar(toolBarManager);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.undo);
        toolBarManager.add((IAction)this.redo);
        toolBarManager.add((IAction)this.toggleComment);
    }

    private void doSetActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        if (part != null) {
            this.editor = (VcobolEditor)part;
            this.editor.setContributor(this);
            this.toggleComment.setActiveEditor(null, (IEditorPart)this.editor);
            IUndoManager manager = this.editor.getViewer().getUndoManager();
            Object context = null;
            context = manager instanceof TextViewerUndoManager ? ((TextViewerUndoManager)manager).getUndoContext() : new UndoContext();
            this.getActionBars().setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)new UndoActionHandler(part.getSite(), context));
            this.getActionBars().setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)new RedoActionHandler(part.getSite(), context));
            this.getPage().addPartListener((IPartListener)this.undo);
            this.getPage().addPartListener((IPartListener)this.redo);
            IWorkbenchPart activePart = this.getPage().getActivePart();
            if (activePart != null) {
                this.undo.partActivated(activePart);
                this.redo.partActivated(activePart);
            }
        }
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        this.doSetActiveEditor(part);
    }

    public void dispose() {
        this.doSetActiveEditor(null);
        this.getPage().removePartListener((IPartListener)this.undo);
        this.getPage().removePartListener((IPartListener)this.redo);
        super.dispose();
    }
}

