/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor;

import com.iscobol.compiler.PreProcessor;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.vcobol.plugins.editor.VcobolSourceViewerConfiguration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;

public class VcobolAutoEditStrategy
implements IAutoEditStrategy {
    private DefaultIndentLineAutoEditStrategy defaultStrategy = new DefaultIndentLineAutoEditStrategy();
    private VcobolSourceViewerConfiguration configuration;
    private static final String eol = System.getProperty("line.separator", "\n");
    private static final Map endTokens = new HashMap();

    static {
        endTokens.put("END-ACCEPT", "ACCEPT");
        endTokens.put("END-ADD", "ADD");
        endTokens.put("END-CALL", "CALL");
        endTokens.put("END-CHAIN", "CHAIN");
        endTokens.put("END-COMPUTE", "COMPUTE");
        endTokens.put("END-DELETE", "DELETE");
        endTokens.put("END-DISPLAY", "DISPLAY");
        endTokens.put("END-DIVIDE", "DIVIDE");
        endTokens.put("END-EVALUATE", "EVALUATE");
        endTokens.put("END-EXEC", "EXEC");
        endTokens.put("END-IF", "IF");
        endTokens.put("END-INVOKE", "INVOKE");
        endTokens.put("END-MODIFY", "MODIFY");
        endTokens.put("END-MOVE", "MOVE");
        endTokens.put("END-MULTIPLY", "MULTIPLY");
        endTokens.put("END-PERFORM", "PERFORM");
        endTokens.put("END-READ", "READ");
        endTokens.put("END-RECEIVE", "RECEIVE");
        endTokens.put("END-RETURN", "RETURN");
        endTokens.put("END-REWRITE", "REWRITE");
        endTokens.put("END-SEARCH", "SEARCH");
        endTokens.put("END-START", "START");
        endTokens.put("END-STRING", "STRING");
        endTokens.put("END-SUBTRACT", "SUBTRACT");
        endTokens.put("END-SYNCHRONIZED", "SYNCHRONIZED");
        endTokens.put("END-TRY", "TRY");
        endTokens.put("END-UNSTRING", "UNSTRING");
        endTokens.put("END-WAIT", "WAIT");
        endTokens.put("END-WRITE", "WRITE");
        endTokens.put("END-XML", "XML");
    }

    public VcobolAutoEditStrategy(VcobolSourceViewerConfiguration conf) {
        this.configuration = conf;
    }

    public void customizeDocumentCommand(IDocument doc, DocumentCommand cmd) {
        if (cmd.text.equals("\t") && this.configuration.getEditor().getInsertSpacesForTab()) {
            int tabWidth;
            boolean insertMode = this.configuration.getEditor().isInInsertMode();
            IRegion r = null;
            try {
                r = doc.getLineInformationOfOffset(cmd.offset);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (r == null) {
                return;
            }
            int lineOffset = cmd.offset - r.getOffset();
            int[] tabStops = this.configuration.getEditor().getTabStops();
            boolean ok = false;
            int i = 0;
            while (i < tabStops.length && !ok) {
                tabWidth = tabStops[i] - 1 - lineOffset;
                if (tabWidth > 0) {
                    cmd.text = this.getSpaces(tabWidth);
                    ok = true;
                }
                ++i;
            }
            if (!ok) {
                int tabStop = tabStops.length > 0 ? tabStops[tabStops.length - 1] : 0;
                int defTabWidth = this.configuration.getEditor().getTabWidth();
                tabStop += defTabWidth;
                while (!ok) {
                    tabWidth = tabStop - 1 - lineOffset;
                    if (tabWidth > 0) {
                        cmd.text = this.getSpaces(tabWidth);
                        ok = true;
                    }
                    tabStop += defTabWidth;
                }
                if (!ok) {
                    cmd.text = this.getSpaces(tabStop - lineOffset);
                }
            }
            if (!insertMode) {
                cmd.length = Math.min(cmd.text.length(), r.getLength() - lineOffset);
            }
        } else if (cmd.text != null && TextUtilities.endsWith((String[])doc.getLegalLineDelimiters(), (String)cmd.text) == -1) {
            Hashtable nrw = new Hashtable();
            String line = null;
            int lineOffs = 0;
            try {
                IRegion r = doc.getLineInformationOfOffset(cmd.offset);
                line = doc.get(r.getOffset(), r.getLength());
                lineOffs = cmd.offset - r.getOffset();
            }
            catch (BadLocationException r) {
                // empty catch block
            }
            if (line == null) {
                return;
            }
            int newLineDelim = cmd.text.indexOf(eol);
            String text = newLineDelim >= 0 && newLineDelim < cmd.text.length() ? cmd.text.substring(0, newLineDelim) : cmd.text;
            line = new StringBuffer(line).replace(lineOffs, Math.min(lineOffs + cmd.length, line.length()), text).toString();
            int format = this.configuration.getEditor().getFormat();
            TokenList tl = PreProcessor.tokenizer((StringBuffer)new StringBuffer(line), (char)'.', (boolean)false, nrw);
            String newToken = null;
            int newTokenOffset = -1;
            Token tk = tl.getFirstWithSep();
            while (tk != null && newToken == null) {
                if (this.isComment(tk.getWord(), tk.getOffset(), format)) {
                    return;
                }
                if (tk.getOffset() + tk.getWord().length() > lineOffs) {
                    newToken = tk.getWord();
                    newTokenOffset = tk.getOffset();
                }
                tk = tl.getNextWithSep();
            }
            if (newToken == null || newTokenOffset == lineOffs && cmd.length > 0) {
                return;
            }
            String newTokenUp = newToken.toUpperCase();
            String keyword = (String)endTokens.get(newTokenUp);
            if (keyword != null) {
                int lineIndex = 0;
                try {
                    lineIndex = doc.getLineOfOffset(cmd.offset) - 1;
                }
                catch (BadLocationException e) {
                    return;
                }
                int keywordOffset = -1;
                int openStmt = 0;
                while (lineIndex >= 0 && keywordOffset < 0) {
                    try {
                        IRegion r = doc.getLineInformation(lineIndex);
                        line = doc.get(r.getOffset(), r.getLength());
                    }
                    catch (BadLocationException e) {
                        return;
                    }
                    tl = PreProcessor.tokenizer((StringBuffer)new StringBuffer(line), (char)'.', (boolean)false, nrw);
                    Token tk2 = tl.getFirstWithSep();
                    while (tk2 != null && keywordOffset < 0) {
                        if (this.isComment(tk2.getWord(), tk2.getOffset(), format)) break;
                        String word = tk2.getWord().toUpperCase();
                        if (word.equals(newTokenUp)) {
                            ++openStmt;
                        } else if (word.equals(keyword)) {
                            if (openStmt == 0) {
                                keywordOffset = tk2.getOffset();
                            } else {
                                --openStmt;
                            }
                        }
                        tk2 = tl.getNextWithSep();
                    }
                    --lineIndex;
                }
                if (keywordOffset >= 0) {
                    int diff = keywordOffset - newTokenOffset;
                    if (diff > 0) {
                        cmd.offset -= lineOffs - newTokenOffset;
                        cmd.length += lineOffs - newTokenOffset;
                        int idx = newTokenOffset + newToken.length() - lineOffs;
                        if (idx >= 0) {
                            if (idx <= cmd.text.length()) {
                                cmd.text = String.valueOf(this.getSpaces(diff)) + newToken + cmd.text.substring(idx);
                            } else {
                                cmd.length += idx - cmd.text.length();
                                cmd.text = String.valueOf(this.getSpaces(diff)) + newToken;
                            }
                        } else {
                            cmd.text = String.valueOf(this.getSpaces(diff)) + newToken + cmd.text;
                        }
                    } else if (diff < 0) {
                        cmd.offset -= lineOffs - newTokenOffset - diff;
                        cmd.length += lineOffs - newTokenOffset - diff;
                        int idx = newTokenOffset + newToken.length() - lineOffs;
                        if (idx >= 0) {
                            if (idx <= cmd.text.length()) {
                                cmd.text = String.valueOf(newToken) + cmd.text.substring(idx);
                            } else {
                                cmd.length += idx - cmd.text.length();
                                cmd.text = newToken;
                            }
                        } else {
                            cmd.text = String.valueOf(newToken) + cmd.text;
                        }
                    }
                }
            }
        } else {
            this.defaultCustomizeDocumentCommand(doc, cmd);
        }
    }

    private void defaultCustomizeDocumentCommand(IDocument d, DocumentCommand c) {
        this.defaultStrategy.customizeDocumentCommand(d, c);
    }

    private boolean isComment(String word, int offs, int format) {
        return word.startsWith("*>") || word.startsWith("|") || word.equals("*") && offs == 0 && format == 2 || word.equals("*") && offs == 6 && format == 1;
    }

    private String getSpaces(int n) {
        StringBuffer Return = new StringBuffer();
        int i = 0;
        while (i < n) {
            Return.append(' ');
            ++i;
        }
        return Return.toString();
    }
}

