/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor;

import com.vcobol.plugins.editor.VcobolWordDetector;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;

public class VcobolDoubleClickSelector
implements ITextDoubleClickStrategy {
    public static final String rcsid = "$Id: IscobolDoubleClickSelector.java,v 1.1.1.1 2006/10/16 08:30:36 gianni Exp $";
    protected ITextViewer textViewer;
    protected int position;
    protected int startPosition;
    protected int endPosition;
    protected static char[] fgBrackets = new char[]{'\"', '\"', '\'', '\''};

    public void init(ITextViewer text, int pos) {
        this.position = pos;
        if (this.position < 0) {
            return;
        }
        this.textViewer = text;
    }

    public void doubleClicked(ITextViewer text) {
        this.init(text, text.getSelectedRange().x);
        if (!this.selectBracketBlock()) {
            this.selectWord();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean matchBracketsAt() {
        int bracketIndex1 = fgBrackets.length;
        int bracketIndex2 = fgBrackets.length;
        this.startPosition = -1;
        this.endPosition = -1;
        try {
            IDocument doc = this.textViewer.getDocument();
            char prevChar = doc.getChar(this.position - 1);
            char nextChar = doc.getChar(this.position);
            int i = 0;
            while (i < fgBrackets.length) {
                if (prevChar == fgBrackets[i]) {
                    this.startPosition = this.position - 1;
                    bracketIndex1 = i;
                }
                i += 2;
            }
            i = 1;
            while (i < fgBrackets.length) {
                if (nextChar == fgBrackets[i]) {
                    this.endPosition = this.position;
                    bracketIndex2 = i;
                }
                i += 2;
            }
            if (this.startPosition > -1 && bracketIndex1 < bracketIndex2) {
                this.endPosition = this.searchForClosingBracket(this.startPosition, prevChar, fgBrackets[bracketIndex1 + 1], doc);
                if (this.endPosition > -1) {
                    return true;
                }
                this.startPosition = -1;
                return false;
            }
            if (this.endPosition <= -1) return false;
            this.startPosition = this.searchForOpenBracket(this.endPosition, fgBrackets[bracketIndex2 - 1], nextChar, doc);
            if (this.startPosition > -1) {
                return true;
            }
            this.endPosition = -1;
            return false;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return false;
    }

    protected boolean matchWord() {
        IDocument doc = this.textViewer.getDocument();
        try {
            char c;
            int pos = this.position;
            while (pos >= 0) {
                c = doc.getChar(pos);
                if (!VcobolWordDetector.IsWordPart((char)c)) break;
                --pos;
            }
            this.startPosition = pos;
            pos = this.position;
            int length = doc.getLength();
            while (pos < length) {
                c = doc.getChar(pos);
                if (!VcobolWordDetector.IsWordPart((char)c)) break;
                ++pos;
            }
            this.endPosition = pos;
            return true;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    protected int searchForClosingBracket(int startPosition, char openBracket, char closeBracket, IDocument document) throws BadLocationException {
        int stack = 1;
        int closePosition = startPosition + 1;
        int length = document.getLength();
        while (closePosition < length && stack > 0) {
            char nextChar = document.getChar(closePosition);
            if (nextChar == openBracket && nextChar != closeBracket) {
                ++stack;
            } else if (nextChar == closeBracket) {
                --stack;
            }
            ++closePosition;
        }
        if (stack == 0) {
            return closePosition - 1;
        }
        return -1;
    }

    protected int searchForOpenBracket(int startPosition, char openBracket, char closeBracket, IDocument document) throws BadLocationException {
        int stack = 1;
        int openPos = startPosition - 1;
        while (openPos >= 0 && stack > 0) {
            char nextChar = document.getChar(openPos);
            if (nextChar == closeBracket && nextChar != openBracket) {
                ++stack;
            } else if (nextChar == openBracket) {
                --stack;
            }
            --openPos;
        }
        if (stack == 0) {
            return openPos + 1;
        }
        return -1;
    }

    protected boolean selectBracketBlock() {
        if (this.matchBracketsAt()) {
            if (this.startPosition == this.endPosition) {
                this.textViewer.setSelectedRange(this.startPosition, 0);
            } else {
                this.textViewer.setSelectedRange(this.startPosition + 1, this.endPosition - this.startPosition - 1);
            }
            return true;
        }
        return false;
    }

    protected void selectWord() {
        if (this.matchWord()) {
            if (this.startPosition == this.endPosition) {
                this.textViewer.setSelectedRange(this.startPosition, 0);
            } else {
                this.textViewer.setSelectedRange(this.startPosition + 1, this.endPosition - this.startPosition - 1);
            }
        }
    }

    public ITextViewer getTextViewer() {
        return this.textViewer;
    }

    public int getPosition() {
        return this.position;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public int getEndPosition() {
        return this.endPosition;
    }
}

