/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor;

import com.vcobol.plugins.editor.VcobolEditorPlugin;
import com.vcobol.plugins.editor.VcobolPartitionScanner;
import com.vcobol.plugins.editor.VresourceBundle;
import com.vcobol.plugins.editor.launch.externaltools.RemoteCompilerManager;
import com.vcobol.plugins.editor.preferences.VcobolPreferenceInitializer;
import com.vcobol.plugins.editor.util.ColorProvider;
import com.vcobol.plugins.editor.util.FontProvider;
import com.vcobol.plugins.editor.util.ImageProvider;
import com.vcobol.plugins.editor.util.InternalErrorException;
import com.vcobol.plugins.editor.util.PluginUtilities;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/*
 * Exception performing whole class analysis ignored.
 */
public class VcobolEditorPlugin
extends AbstractUIPlugin {
    public static final String rcsid = "$Id: IscobolEditorPlugin.java,v 1.28 2009/03/09 11:13:50 gianni Exp $";
    public static final String CONTEXT_TYPE_ID = "com.vcobol.plugins.editor.procDivision";
    public static final String ID = "com.vcobol.plugins.editor.VcobolEditor";
    public static final String VCOBOL_PARTITIONING = "__vcobol_partitioning";
    public static final String OPTION_CHECKED = "___vcobol.option.true";
    public static final String OPTION_NOT_CHECKED = "___vcobol.option.false";
    public static final String LOGS_KEY = "logsdir";
    public static final String ERR_KEY = "errdir";
    public static final String LIST_KEY = "listdir";
    public static final String DATA_KEY = "datadir";
    public static final String SOURCE_KEY = "sourcedir";
    public static final String RESOURCES_KEY = "resourcesdir";
    public static final String SCREEN_KEY = "screendir";
    public static final String FD_KEY = "fddir";
    public static final String CLASSPATH_KEY = "vcobol.classpath";
    public static final String USE_FILE_OPTIONS_KEY = "vcobol.checkfileopt";
    public static final String DEFAULT_SOURCE_DIR = "source";
    public static final String DEFAULT_SCREEN_DIR = "screen";
    public static final String DEFAULT_FD_DIR = "fd";
    public static final String DEFAULT_DATA_DIR = "data";
    public static final String DEFAULT_LOGS_DIR = "logs";
    public static final String DEFAULT_ERR_DIR = "errs";
    public static final String DEFAULT_LIST_DIR = "list";
    public static final String DEFAULT_RESOURCES_DIR = "resources";
    public static final String DEFAULT_OUTPUT_DIR = "output";
    public static final String DEFAULT_TRASLAT_DIR = "translated";
    public static final String DEFAULT_COPY_DIR = "cpy";
    public static final String PREPROC_PRG_KEY = "vcobol.preproc.prg";
    public static final String PREPROC_ENVIR_KEY = "vcobol.preproc.env";
    public static final String PREPROC_ENABLED_KEY = "vcobol.preproc.en";
    public static final String REMOTECOMP_ENABLED_KEY = "vcobol.rc.en";
    public static final String REMOTECOMP_HOST_KEY = "vcobol.rc.host";
    public static final String REMOTECOMP_PORT_KEY = "vcobol.rc.port";
    public static final String REMOTECOMP_GENCLASS_KEY = "vcobol.rc.genclass";
    public static final String REMOTECOMP_GENERR_KEY = "vcobol.rc.generr";
    public static final String REMOTECOMP_GENLIST_KEY = "vcobol.rc.genlist";
    public static final String REMOTECOMP_PPLIST_KEY = "vcobol.rc.pplist";
    public static final String PROGRAM_ARGUMENTS_KEY = "vcobol.prog.args";
    public static final String PROGRAM_SYSTEM_PROPERTIES_KEY = "vcobol.prog.sysprops";
    public static final String PROGRAM_IS_JAR_KEY = "vcobol.prog.isjar";
    public static final String PROGRAM_CLASSPATH_KEY = "vcobol.prog.cp";
    public static final String PROGRAM_ENV_VARIABLES_KEY = "vcobol.prog.envvars";
    public static final String PROGRAM_ENV_VARIABLE_COUNT_KEY = "vcobol.prog.envvarcount";
    public static final String PROGRAM_APPEND_ENV_KEY = "vcobol.prog.appenv";
    public static final String PROGRAM_WORKDIR_KEY = "vcobol.prog.workdir";
    public static final String CLASS_ATTR = "classFile";
    public static final String FILELIST_ATTR = "fileList";
    private static VcobolEditorPlugin fgInstance;
    private VcobolPartitionScanner fPartitionScanner;
    private RuleBasedScanner codeScanner;
    private ColorProvider colorProvider;
    private ImageProvider imageProvider;
    private FontProvider fontProvider;
    private static final String CUSTOM_TEMPLATES_KEY = "com.vcobol.plugins.editor.customtemplates";
    private TemplateStore tStore;
    private PropertyChangeListener propchangelist;
    private IResourceChangeListener reschangelist;
    private ContributionContextTypeRegistry ctRegistry;
    private IOConsole ioconsole;
    private String[] commandLineArgs;

    public VcobolEditorPlugin() {
        fgInstance = this;
    }

    public ColorProvider getColorProvider() {
        if (this.colorProvider == null) {
            this.colorProvider = new ColorProvider();
        }
        return this.colorProvider;
    }

    public ImageProvider getImageProvider() {
        if (this.imageProvider == null) {
            this.imageProvider = new ImageProvider();
        }
        return this.imageProvider;
    }

    public FontProvider getFontProvider() {
        if (this.fontProvider == null) {
            this.fontProvider = new FontProvider();
        }
        return this.fontProvider;
    }

    public static VcobolEditorPlugin getDefault() {
        if (fgInstance == null) {
            fgInstance = new VcobolEditorPlugin();
        }
        return fgInstance;
    }

    public RuleBasedScanner getIscobolCodeScanner() {
        if (this.codeScanner == null) {
            this.codeScanner = new RuleBasedScanner();
        }
        return this.codeScanner;
    }

    public String getJavacCompiler() {
        IPreferenceStore store = this.getPreferenceStore();
        if (store.contains("vcobol.compiler.javac")) {
            return store.getString("vcobol.compiler.javac");
        }
        return store.getDefaultString("vcobol.compiler.javac");
    }

    public boolean isSyntaxHighlightingEnabled() {
        IPreferenceStore store = this.getPreferenceStore();
        if (store.contains("vcobol.syntaxhighlighting.enabled")) {
            return store.getBoolean("vcobol.syntaxhighlighting.enabled");
        }
        return store.getDefaultBoolean("vcobol.syntaxhighlighting.enabled");
    }

    public boolean isSourceFormatColoringEnabled() {
        IPreferenceStore store = this.getPreferenceStore();
        if (store.contains("vcobol.sourceformat.enabled")) {
            return store.getBoolean("vcobol.sourceformat.enabled");
        }
        return store.getDefaultBoolean("vcobol.sourceformat.enabled");
    }

    public String getDefaultIscobolBuild() {
        IPreferenceStore store = this.getPreferenceStore();
        if (store.contains("vcobol.build")) {
            return store.getString("vcobol.build");
        }
        return store.getDefaultString("vcobol.build");
    }

    public int getTabWidth() {
        IPreferenceStore store = this.getPreferenceStore();
        if (store.contains("vcobol.tabwidth")) {
            return store.getInt("vcobol.tabwidth");
        }
        return store.getDefaultInt("vcobol.tabwidth");
    }

    public VcobolPartitionScanner getVcobolPartitionScanner() {
        if (this.fPartitionScanner == null) {
            this.fPartitionScanner = new VcobolPartitionScanner();
        }
        return this.fPartitionScanner;
    }

    public void addProject(IProject p) {
        PluginUtilities.addPropertyChangeListener((IResource)p, (PropertyChangeListener)this.getPCList());
    }

    private PropertyChangeListener getPCList() {
        if (this.propchangelist == null) {
            this.propchangelist = new /* Unavailable Anonymous Inner Class!! */;
        }
        return this.propchangelist;
    }

    public IOConsole getConsole() {
        return this.ioconsole;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.manageInitialSettings();
        this.commandLineArgs = Platform.getCommandLineArgs();
        this.reschangelist = new MyResourceChangeListener(this, null);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.reschangelist, 12);
        try {
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                if (projects[i].getNature("com.vcobol.plugins.editor.VcobolEditor.VcobolNature") != null) {
                    PluginUtilities.addPropertyChangeListener((IResource)projects[i], (PropertyChangeListener)this.getPCList());
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.ioconsole = new IOConsole("vCOBOL", null);
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.ioconsole});
    }

    public void stop(BundleContext context) throws Exception {
        if (this.colorProvider != null) {
            this.colorProvider.dispose();
        }
        if (this.imageProvider != null) {
            this.imageProvider.dispose();
        }
        if (this.reschangelist != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.reschangelist);
        }
        try {
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                if (projects[i].getNature("com.vcobol.plugins.editor.VcobolEditor.VcobolNature") != null) {
                    PluginUtilities.removePropertyChangeListener((IResource)projects[i]);
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        RemoteCompilerManager.stopRemoteCompiler((boolean)false);
        super.stop(context);
    }

    public TemplateStore getTemplateStore() {
        if (this.tStore == null) {
            this.tStore = new ContributionTemplateStore(this.getContextTypeRegistry(), VcobolEditorPlugin.getDefault().getPreferenceStore(), "com.vcobol.plugins.editor.customtemplates");
            try {
                this.tStore.load();
            }
            catch (IOException e) {
                VcobolEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.vcobol.plugins.editor", 0, "", (Throwable)e));
            }
        }
        return this.tStore;
    }

    public String[] getCommandLineArgs() {
        return this.commandLineArgs;
    }

    public ContextTypeRegistry getContextTypeRegistry() {
        if (this.ctRegistry == null) {
            this.ctRegistry = new ContributionContextTypeRegistry();
            this.ctRegistry.addContextType("com.vcobol.plugins.editor.procDivision");
        }
        return this.ctRegistry;
    }

    public static int getIntFromStore(String key) {
        IPreferenceStore store = VcobolEditorPlugin.getDefault().getPreferenceStore();
        if (store.contains(key)) {
            return store.getInt(key);
        }
        return store.getDefaultInt(key);
    }

    public static boolean getBooleanFromStore(String key) {
        IPreferenceStore store = VcobolEditorPlugin.getDefault().getPreferenceStore();
        if (store.contains(key)) {
            return store.getBoolean(key);
        }
        return store.getDefaultBoolean(key);
    }

    public static String getStringFromStore(String key) {
        IPreferenceStore store = VcobolEditorPlugin.getDefault().getPreferenceStore();
        if (store.contains(key)) {
            return store.getString(key);
        }
        return store.getDefaultString(key);
    }

    private void manageInitialSettings() {
        if (Platform.getBundle((String)"com.vcobol.plugins.vcobolIDE") != null) {
            try {
                this.askImportSettings();
            }
            catch (Exception e) {
                PluginUtilities.log((Throwable)e);
            }
            PlatformUI.getWorkbench().addWorkbenchListener((IWorkbenchListener)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void askImportSettings() throws Exception {
        String workspaceLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        File vIDE = new File(String.valueOf(workspaceLocation) + File.separator + ".vIDE");
        if (!vIDE.exists()) {
            int val = VcobolPreferenceInitializer.getPreferences().getInt("iscobol.preferences.importsettings", 2);
            if (val == 2) {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                MessageDialogWithToggle md = new MessageDialogWithToggle(shell, "vCOBOL", null, VresourceBundle.getString((String)"ask_import_settings_msg"), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1, VresourceBundle.getString((String)"dont_ask_me_again_msg"), false);
                int ret = md.open();
                if (ret >= 0) {
                    if (md.getToggleState()) {
                        VcobolPreferenceInitializer.getPreferences().putInt("iscobol.preferences.importsettings", 1);
                    }
                    if (ret == 2) {
                        FileDialog fd = new FileDialog(shell, 4096);
                        fd.setFilterExtensions(new String[]{"*.prefs"});
                        String prefFile = fd.open();
                        if (prefFile != null) {
                            this.importSettings(workspaceLocation, prefFile);
                        }
                    }
                }
            }
            FileOutputStream out = new FileOutputStream(vIDE);
            out.close();
        }
    }

    private void importSettings(String workspaceLocation, String prefFile) throws Exception {
        String prefRootDir = String.valueOf(workspaceLocation) + File.separator + ".metadata" + File.separator + ".plugins" + File.separator + "org.eclipse.core.runtime" + File.separator + ".settings";
        File prefRootDirFile = new File(prefRootDir);
        prefRootDirFile.mkdirs();
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(prefFile)));
        PrintStream out = null;
        String prefFileName = null;
        String line = in.readLine();
        while (line != null) {
            if (line.startsWith("com.veryant.preference.node=")) {
                if (out != null) {
                    out.close();
                }
                prefFileName = line.substring("com.veryant.preference.node=".length());
                File outFile = new File(String.valueOf(prefRootDir) + File.separator + prefFileName);
                out = new PrintStream(new FileOutputStream(outFile));
            } else if (out != null) {
                if (prefFileName.equals("org.eclipse.core.resources.prefs") && line.startsWith("description.autobuilding=")) {
                    IWorkspaceDescription desc = ResourcesPlugin.getWorkspace().getDescription();
                    desc.setAutoBuilding(Boolean.valueOf(line.substring("description.autobuilding=".length())).booleanValue());
                    ResourcesPlugin.getWorkspace().setDescription(desc);
                }
                out.println(line);
            } else {
                throw new InternalErrorException("Invalid format of preference file: " + prefFile);
            }
            line = in.readLine();
        }
    }

    private void askExportSettings(IWorkbench workbench) throws Exception {
        String workspaceLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        int val = VcobolPreferenceInitializer.getPreferences().getInt("iscobol.preferences.exportsettings", 2);
        if (val == 2) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            MessageDialogWithToggle md = new MessageDialogWithToggle(shell, "isCOBOL", null, VresourceBundle.getString((String)"ask_export_settings_msg"), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1, VresourceBundle.getString((String)"dont_ask_me_again_msg"), false);
            int ret = md.open();
            if (ret >= 0) {
                if (md.getToggleState()) {
                    VcobolPreferenceInitializer.getPreferences().putInt("iscobol.preferences.exportsettings", 1);
                }
                if (ret == 2) {
                    FileDialog fd = new FileDialog(shell, 8192);
                    fd.setOverwrite(true);
                    fd.setFilterExtensions(new String[]{"*.prefs"});
                    String prefFile = fd.open();
                    if (prefFile != null) {
                        this.exportSettings(workspaceLocation, prefFile);
                    }
                }
            }
        }
    }

    private void exportSettings(String workspaceLocation, String prefFile) throws Exception {
        File prefRootDir = new File(String.valueOf(workspaceLocation) + File.separator + ".metadata" + File.separator + ".plugins" + File.separator + "org.eclipse.core.runtime" + File.separator + ".settings");
        PrintStream out = new PrintStream(new FileOutputStream(prefFile));
        File[] prefFiles = prefRootDir.listFiles((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */);
        int i = 0;
        while (i < prefFiles.length) {
            out.println("com.veryant.preference.node=" + prefFiles[i].getName());
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(prefFiles[i])));
            String line = in.readLine();
            while (line != null) {
                out.println(line);
                line = in.readLine();
            }
            in.close();
            ++i;
        }
        out.close();
    }

    static /* synthetic */ void access$0(VcobolEditorPlugin vcobolEditorPlugin, IWorkbench iWorkbench) throws Exception {
        vcobolEditorPlugin.askExportSettings(iWorkbench);
    }
}

