/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor;

import com.vcobol.plugins.editor.VcobolEditor;
import com.vcobol.plugins.editor.VcobolEditorPlugin;
import com.vcobol.plugins.editor.VcobolOutlinePage;
import com.vcobol.plugins.editor.actions.SortAction;
import com.vcobol.plugins.editor.util.PluginUtilities;
import com.veryant.commons.editor.util.IOFileStorage;
import com.veryant.commons.editor.util.IOFileStorageEditorInput;
import com.veryant.commons.editor.util.IsFragment;
import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class VcobolOutlinePage
extends ContentOutlinePage {
    protected VcobolEditor editor;
    private IsFragment input;
    private MyContentProvider contentProvider;
    private IPropertyChangeListener propchangelist;
    private SortAction sortAction;

    public VcobolOutlinePage(VcobolEditor editor) {
        this.editor = editor;
    }

    public void dispose() {
        if (this.propchangelist != null) {
            VcobolEditorPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.propchangelist);
        }
        super.dispose();
    }

    public TreeViewer getTreeViewer() {
        return super.getTreeViewer();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        ISelection selection = event.getSelection();
        IsFragment fragment = null;
        if (!selection.isEmpty()) {
            fragment = (IsFragment)((IStructuredSelection)selection).getFirstElement();
        }
        this.selectionChanged(fragment, selection);
    }

    public void selectionChanged(IsFragment fragment, ISelection selection) {
        if (fragment != null) {
            VcobolEditor ed = this.editor;
            String baseFileName = fragment.getFilename();
            if (baseFileName != null) {
                baseFileName = new File(baseFileName).getName();
            }
            if (baseFileName != null && !baseFileName.equals(this.editor.getEditorInput().getName()) && this.editor.getProject() != null) {
                try {
                    IResource inputFile;
                    String path = PluginUtilities.makeRelative((String)fragment.getFilename(), (IProject)this.editor.getProject());
                    File file = new File(path);
                    Object input = file.isAbsolute() ? new IOFileStorageEditorInput(new IOFileStorage(file, false)) : ((inputFile = PluginUtilities.findMember((IContainer)this.editor.getProject(), (IPath)new Path(path))) instanceof IFile ? new FileEditorInput((IFile)inputFile) : new FileEditorInput(this.editor.getProject().getFile(path)));
                    ed = (VcobolEditor)this.editor.getEditorSite().getPage().openEditor((IEditorInput)input, VcobolEditor.ID, true, 3);
                    if (this.editor.getProject() != null && ed.getProject() == null) {
                        ed.setProject(this.editor.getProject());
                    }
                    VcobolOutlinePage outPage = (VcobolOutlinePage)ed.getOutlinePage();
                    outPage.setInput(this.getInput());
                    outPage.getTreeViewer().setExpandedElements(this.getTreeViewer().getExpandedElements());
                }
                catch (PartInitException path) {
                    // empty catch block
                }
            }
            Position pos = fragment.getPosition();
            try {
                if (pos != null) {
                    ed.setHighlightRange(pos.getOffset(), pos.getLength(), true);
                } else {
                    try {
                        IDocument doc = ed.getViewer().getDocument();
                        IRegion startInfo = doc.getLineInformation(fragment.getStartLine());
                        int endLine = fragment.getEndLine() >= 0 ? fragment.getEndLine() : doc.getNumberOfLines();
                        IRegion endInfo = doc.getLineInformation(endLine);
                        ed.setHighlightRange(startInfo.getOffset(), endInfo.getOffset() + endInfo.getLength() - startInfo.getOffset(), true);
                    }
                    catch (Exception doc) {}
                }
            }
            catch (IllegalArgumentException x) {
                ed.resetHighlightRange();
            }
            if (ed.getOutlinePage().getControl() != null) {
                ed.getOutlinePage().setFocus();
            }
            if (ed != this.editor) {
                VcobolEditor fEd = ed;
                new /* Unavailable Anonymous Inner Class!! */.start();
            }
        } else {
            this.editor.resetHighlightRange();
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        this.contentProvider = new MyContentProvider(null);
        viewer.setContentProvider((IContentProvider)this.contentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)new MyDecoratingLabelProvider((ILabelProvider)new MyLabelProvider(null), (ILabelDecorator)new MyLabelDecorator(null)));
        this.propchangelist = new /* Unavailable Anonymous Inner Class!! */;
        VcobolEditorPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.propchangelist);
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.setInput(this.input);
    }

    public IsFragment getInput() {
        return this.input;
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
        this.addSortAction(toolBarManager);
    }

    public void addSortAction(IToolBarManager toolBarManager) {
        if (this.sortAction == null) {
            this.sortAction = new SortAction();
            this.sortAction.setId("com.vcobol.plugins.editor.actions.SortAction");
            this.sortAction.setChecked(VcobolEditorPlugin.getDefault().getPreferenceStore().getBoolean("vcobol.outlinesort.enabled"));
            toolBarManager.add((IAction)this.sortAction);
        }
    }

    public void removeSortAction(IToolBarManager toolBarManager) {
        if (this.sortAction != null) {
            toolBarManager.remove(this.sortAction.getId());
            this.sortAction = null;
        }
    }

    public void setInput(IsFragment program) {
        this.input = program;
        this.update();
    }

    protected IsFragment[] getRootNodes(IsFragment input) {
        if (input != null) {
            return new IsFragment[]{input};
        }
        return null;
    }

    public void update() {
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null) {
            if (this.input != null) {
                Control control = viewer.getControl();
                if (control != null && !control.isDisposed()) {
                    control.setRedraw(false);
                    if (this.input.getType() == 1) {
                        viewer.setAutoExpandLevel(3);
                    } else if (this.input.getType() == 6) {
                        viewer.setAutoExpandLevel(5);
                    }
                    viewer.setInput((Object)new RootObject(this.getRootNodes(this.input)));
                    control.setRedraw(true);
                }
            } else {
                Control control = viewer.getControl();
                if (control != null && !control.isDisposed()) {
                    control.setRedraw(false);
                    viewer.setInput((Object)new RootObject(null));
                    control.setRedraw(true);
                }
            }
        }
    }

    static /* synthetic */ MyContentProvider access$0(VcobolOutlinePage vcobolOutlinePage) {
        return vcobolOutlinePage.contentProvider;
    }
}

