/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor;

import com.vcobol.plugins.editor.VcobolEditor;
import com.vcobol.plugins.editor.VcobolProjectionViewer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;

public class VcobolProjectionViewer
extends ProjectionViewer {
    public static final String rcsid = "$Id: IscobolProjectionViewer.java,v 1.2 2008/10/02 10:14:17 gianni Exp $";
    private VcobolEditor editor;
    private boolean redraw = true;

    public VcobolProjectionViewer(VcobolEditor editor, Composite parent, IVerticalRuler ruler, IOverviewRuler overviewRuler, boolean showsAnnotationOverview, int styles) {
        super(parent, ruler, overviewRuler, showsAnnotationOverview, styles);
        this.editor = editor;
    }

    VcobolEditor getEditor() {
        return this.editor;
    }

    public void setTabsToSpacesConverter(IAutoEditStrategy converter) {
    }

    protected void updateTextListeners(TextViewer.WidgetCommand cmd) {
        if (this.redraw) {
            super.updateTextListeners(cmd);
        }
    }

    protected void shift(boolean useDefaultPrefixes, boolean right, boolean ignoreWhitespace) {
        if (right || this.getTextWidget().getSelectionCount() > 0) {
            super.shift(useDefaultPrefixes, right, ignoreWhitespace);
        } else {
            int curOffs = this.getTextWidget().getSelection().x;
            int lineOffs = 1;
            IRegion lineRegion = null;
            String line = null;
            try {
                lineRegion = this.getDocument().getLineInformationOfOffset(curOffs);
                lineOffs = curOffs - lineRegion.getOffset();
                line = this.getDocument().get(lineRegion.getOffset(), lineRegion.getLength());
            }
            catch (BadLocationException e) {
                return;
            }
            int[] tabStops = this.editor.getTabStops();
            int previousTabStop = 0;
            int i = tabStops.length - 1;
            while (i >= 0 && previousTabStop == 0) {
                if (tabStops[i] - 1 < lineOffs) {
                    previousTabStop = tabStops[i] - 1;
                }
                --i;
            }
            if (tabStops.length > 0 && previousTabStop == tabStops[tabStops.length - 1] - 1) {
                int defaultTabWidth = this.editor.getTabWidth();
                while (lineOffs > previousTabStop + defaultTabWidth) {
                    previousTabStop += defaultTabWidth;
                }
            }
            int previousNoSpaceCharIdx = lineOffs - 1;
            while (previousNoSpaceCharIdx >= 0 && line.charAt(previousNoSpaceCharIdx) == ' ') {
                --previousNoSpaceCharIdx;
            }
            int start = Math.max(previousTabStop, previousNoSpaceCharIdx + 1);
            int length = lineOffs - start;
            if (length > 0) {
                IUndoManager manager = this.getUndoManager();
                manager.beginCompoundChange();
                this.getTextWidget().replaceTextRange(lineRegion.getOffset() + start, length, "");
                manager.endCompoundChange();
            }
        }
    }

    protected StyledText createTextWidget(Composite parent, int styles) {
        return new MyStyledText(this, parent, styles);
    }

    public void setDocument(IDocument document, IAnnotationModel annotationModel, int modelRangeOffset, int modelRangeLength) {
        if (annotationModel == null) {
            annotationModel = new AnnotationModel();
        }
        super.setDocument(document, annotationModel, modelRangeOffset, modelRangeLength);
    }

    protected void addMyLineBackgroundListener(LineBackgroundListener listener) {
        ((MyStyledText)this.getTextWidget()).addMyLineBackgroundListener(listener);
    }

    public int findAndSelect(int startPosition, String findString, boolean forwardSearch, boolean caseSensitive, boolean wholeWord, boolean regExSearch) {
        return super.findAndSelect(startPosition, findString, forwardSearch, caseSensitive, wholeWord, regExSearch);
    }

    public void SetRedraw(boolean r) {
        if (this.redraw != r) {
            this.redraw = r;
            if (this.redraw) {
                this.getTextWidget().redraw();
            }
        }
    }

    static /* synthetic */ VcobolEditor access$0(VcobolProjectionViewer vcobolProjectionViewer) {
        return vcobolProjectionViewer.editor;
    }

    static /* synthetic */ boolean access$1(VcobolProjectionViewer vcobolProjectionViewer) {
        return vcobolProjectionViewer.redraw;
    }
}

