/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor;

import com.iscobol.compiler.CobolMethod;
import com.iscobol.compiler.DataDivision;
import com.iscobol.compiler.Entry;
import com.iscobol.compiler.FileDescriptor;
import com.iscobol.compiler.FileDescriptorList;
import com.iscobol.compiler.FileFinder;
import com.iscobol.compiler.FileSection;
import com.iscobol.compiler.LinkageSection;
import com.iscobol.compiler.OptionList;
import com.iscobol.compiler.Paragraph;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.PreProcessor;
import com.iscobol.compiler.ProcedureDivision;
import com.iscobol.compiler.Repository;
import com.iscobol.compiler.ScreenSection;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationList;
import com.iscobol.compiler.WorkingStorageSection;
import com.vcobol.plugins.editor.util.ErrorsExt;
import com.vcobol.plugins.editor.util.PluginUtilities;
import com.vcobol.plugins.editor.util.ProjectFileFinder;
import com.veryant.commons.editor.util.IsFragment;
import com.veryant.commons.editor.util.VarDecl;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;

/*
 * Exception performing whole class analysis ignored.
 */
public class VcobolReconcilingEngine {
    public static final String rcsid = "$Id: IscobolReconcilingEngine.java,v 1.12 2009/03/09 11:14:40 gianni Exp $";
    private static final Vector FIXED_COMP_OPTS = new /* Unavailable Anonymous Inner Class!! */;
    private static final OutputStream dummyOutputStream = new /* Unavailable Anonymous Inner Class!! */;
    private Reader reader;
    private String filename;
    private String[] compOpts;
    private Pcc pccReturn;
    private ClassLoader cLoader;
    private IDocument document;
    private ArrayList positions;
    private int positionShift;
    private IFile file;
    private int format = 0;
    private Vector unusedVars = new Vector();
    private ProjectFileFinder fileFinder;
    private boolean wu;

    public VcobolReconcilingEngine(Reader reader, String filename, String[] compOpts, ClassLoader cLoader, IDocument document, ArrayList positions, int positionShift) {
        this.reader = reader;
        this.filename = filename;
        this.compOpts = compOpts;
        this.cLoader = cLoader;
        this.document = document;
        this.positions = positions;
        this.positionShift = positionShift;
        int i = 0;
        while (i < compOpts.length && !this.wu) {
            this.wu |= compOpts[i].startsWith("-wu");
            ++i;
        }
    }

    public ProjectFileFinder getFileFinder() {
        return this.fileFinder;
    }

    public static IsFragment getProgramTree(IFile file) throws Exception {
        InputStream is = null;
        try {
            IsFragment Return;
            is = file.getContents();
            String currMode = PluginUtilities.getCurrentSettingMode((IResource)file.getProject());
            IsFragment isFragment = Return = VcobolReconcilingEngine.getProgramTree((Reader)new InputStreamReader(is), (String)file.getName(), (String[])VcobolReconcilingEngine.retrieveCompOpts((IFile)file), (ClassLoader)PluginUtilities.getClassLoader((IProject)file.getProject(), (String)currMode), (IFile)file);
            return isFragment;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static IsFragment getProgramTree(Reader reader, String filename, String[] compOpts, ClassLoader cLoader, IFile file) throws Exception {
        VcobolReconcilingEngine engine = new VcobolReconcilingEngine(reader, filename, compOpts, cLoader, null, null, 0);
        engine.setFile(file);
        return engine.reconcile();
    }

    public void setFile(IFile file) {
        this.file = file;
    }

    public IFile getFile() {
        return this.file;
    }

    public int getFormat() {
        return this.format;
    }

    public IsFragment reconcile() throws Exception {
        Pcc pcc = null;
        int len = 2;
        if (this.compOpts != null) {
            len += this.compOpts.length;
        }
        String[] olArgs = new String[len];
        int i = 0;
        olArgs[i++] = "-jj";
        int j = 0;
        while (j < this.compOpts.length) {
            olArgs[i++] = this.compOpts[j];
            ++j;
        }
        olArgs[i++] = this.filename;
        OptionList ol = new OptionList(olArgs);
        PrintStream err = System.err;
        PrintStream ps = new PrintStream(dummyOutputStream);
        System.setErr(ps);
        String spOpt = null;
        if (this.file != null) {
            String fileCurrMode = PluginUtilities.getCurrentSettingMode((IResource)this.file);
            if (fileCurrMode != null) {
                spOpt = PluginUtilities.getPersistentProperty((IResource)this.file, (String)fileCurrMode, (String)"-sp=");
                if (spOpt == null) {
                    spOpt = PluginUtilities.getPersistentProperty((IResource)this.file.getProject(), (String)fileCurrMode, (String)"-sp=");
                }
            } else {
                spOpt = PluginUtilities.getPersistentProperty((IResource)this.file.getProject(), (String)PluginUtilities.getCurrentSettingMode((IResource)this.file.getProject()), (String)"-sp=");
            }
            this.fileFinder = new ProjectFileFinder((IResource)this.file, spOpt, ol.getOption("-ce="));
        }
        if (this.cLoader != null) {
            ClassLoader clSave = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.cLoader);
            pcc = PluginUtilities.pccAnalyze((String)this.filename, (OptionList)ol, (String)spOpt, ErrorsExt.class, (Reader)this.reader, (IResource)this.file, (FileFinder)this.fileFinder);
            Thread.currentThread().setContextClassLoader(clSave);
        } else {
            pcc = PluginUtilities.pccAnalyze((String)this.filename, (OptionList)ol, (String)spOpt, ErrorsExt.class, (Reader)this.reader, (IResource)this.file, (FileFinder)this.fileFinder);
        }
        System.setErr(err);
        if (pcc == null) {
            return null;
        }
        int f = ((PreProcessor)pcc.getTokenManager().getAllPreProcessors().get(0)).getFormat();
        switch (f) {
            case 1: {
                this.format = 1;
                break;
            }
            case 2: {
                this.format = 2;
                break;
            }
            case 3: {
                this.format = 3;
                break;
            }
            default: {
                this.format = 0;
            }
        }
        String progname = pcc.getClassName();
        if (progname == null || progname.length() == 0) {
            progname = PluginUtilities.getVcobolClassName((String)this.filename);
        }
        IsFragment program = new IsFragment(null, 1, progname, new Position(0, 0));
        if (pcc.getCobolProgram() != null) {
            this.addProgramPartInternalAnnotations((Pcc)pcc.getCobolProgram(), program);
        } else {
            program.setType(6);
            IsFragment factory = null;
            IsFragment object = null;
            if (pcc.getFactoryPart() != null) {
                factory = this.addProgramPartAnnotations((Pcc)pcc.getFactoryPart(), pcc.getFactoryPart().getAllMethods(), program, 2);
            }
            if (pcc.getObjectPart() != null) {
                object = this.addProgramPartAnnotations((Pcc)pcc.getObjectPart(), pcc.getObjectPart().getAllMethods(), program, 3);
            }
            if (factory == null && object == null) {
                return program;
            }
        }
        Repository rep = null;
        if (pcc.getEnvironmentDivision() != null && pcc.getEnvironmentDivision().getConfigurationSection() != null) {
            rep = pcc.getRepository();
        }
        if (rep != null) {
            VariableDeclarationList allClasses = rep.getAllClasses();
            VariableDeclaration vd = allClasses.getFirst();
            while (vd != null) {
                VarDecl.getClassVarDecl((IsFragment)program, (String)vd.getName().toLowerCase(), (String)vd.getTypeName());
                vd = allClasses.getNext();
            }
        }
        this.pccReturn = pcc;
        return program;
    }

    private void loadVariables(IsFragment par, FileDescriptorList fdList) {
        FileDescriptor fd = fdList.getFirst();
        while (fd != null) {
            int startLine = fd.getNameToken().getFLN() - 1;
            IsFragment par2 = this.addAnnotation(par, fd.getNameToken().getWord(), 14, startLine, startLine, fd.getNameToken().getFileName());
            this.loadVariables(par2, fd.getRecordDescription());
            fd = fdList.getNext();
        }
    }

    private void loadVariables(IsFragment par, VariableDeclarationList vdList) {
        VariableDeclaration v = vdList.getFirst();
        while (v != null) {
            int startLine = v.getNameToken().getFLN() - 1;
            IsFragment par2 = this.addVarAnnotation(par, startLine, v);
            par2.setFilename(v.getNameToken().getFileName());
            VariableDeclarationList children = v.getChildren();
            if (children.getFirst() != null) {
                this.loadVariables(par2, children);
            }
            v = vdList.getNext();
        }
    }

    private IsFragment addProgramPartAnnotations(Pcc pcc, CobolMethod[] methods, IsFragment parent, int type) {
        String name = type == 2 ? "Factory" : "Object";
        IsFragment part = null;
        Token tk = pcc.getLastToken();
        if (tk != null) {
            part = this.addAnnotation(parent, name, type, pcc.getFirstToken().getFLN() - 1, tk.getFLN() - 1, pcc.getFirstToken().getFileName());
        }
        this.loadDataDivision(pcc, part);
        IsFragment[] ismethods = new IsFragment[methods.length];
        int i = 0;
        while (i < methods.length) {
            Token firstToken = methods[i].getFirstToken();
            ismethods[i] = null;
            tk = methods[i].getLastToken();
            if (tk != null) {
                ismethods[i] = this.addAnnotation(part, methods[i].getMethodName(), 4, firstToken.getFLN() - 1, tk.getFLN() - 1, firstToken.getFileName());
            }
            this.addProgramPartInternalAnnotations((Pcc)methods[i], ismethods[i]);
            ++i;
        }
        return part;
    }

    private void addProgramPartInternalAnnotations(Pcc pcc, IsFragment parent) {
        this.loadDataDivision(pcc, parent);
        Token tk = null;
        ProcedureDivision proc = pcc.getProcedureDivision();
        if (proc != null) {
            Entry[] entryPoints = pcc.getEntryPoints();
            int endLine = this.document != null ? this.document.getNumberOfLines() - 1 : -1;
            IsFragment procFr = this.addAnnotation(parent, "PROCEDURE DIVISION", 7, proc.getFirstToken().getFLN() - 1, endLine, proc.getFirstToken().getFileName());
            if (entryPoints.length > 0) {
                Token epName = entryPoints[0].getNameToken();
                IsFragment epListFr = new IsFragment(procFr, 15, "Entry points", epName.getFLN() - 1, epName.getFLN() - 1);
                epListFr.setFilename(epName.getFileName());
                int i = 0;
                while (i < entryPoints.length) {
                    epName = entryPoints[i].getNameToken();
                    IsFragment epFr = new IsFragment(epListFr, 16, epName.getWord().substring(1, epName.getWord().length() - 1), epName.getFLN() - 1, epName.getFLN() - 1);
                    epFr.setFilename(epName.getFileName());
                    ++i;
                }
            }
            Paragraph[] pList = proc.getParagraphs();
            IsFragment[] pp = new IsFragment[pList.length];
            int i = 0;
            while (i < pList.length) {
                Token firstToken = pList[i].getNameToken();
                int startLine = firstToken.getFLN() - 1;
                String fn = firstToken.getFileName();
                if (fn == proc.getFirstToken().getFileName()) {
                    Paragraph next = VcobolReconcilingEngine.getNextParSameFile((Paragraph[])pList, (int)(i + 1), (String)fn);
                    endLine = next != null ? next.getNameToken().getFLN() - 1 : ((tk = pcc.getLastToken()) != null ? tk.getFLN() - 1 : (this.document != null ? this.document.getNumberOfLines() - 1 : startLine));
                    pp[i] = this.addAnnotation(procFr, firstToken.getWord(), 5, startLine, endLine, firstToken.getFileName());
                } else {
                    pp[i] = this.addAnnotation(procFr, firstToken.getWord(), 5, startLine, startLine, firstToken.getFileName());
                }
                ++i;
            }
        }
    }

    private void loadDataDivision(Pcc pcc, IsFragment parent) {
        DataDivision dd = pcc.getDataDivision();
        Token tk = null;
        if (dd != null) {
            FileSection fs;
            ScreenSection scrs;
            LinkageSection lnks;
            IsFragment ddFr = this.addAnnotation(parent, "DATA DIVISION", 8, dd.getFirstToken().getFLN() - 1, (tk = dd.getLastToken()) != null ? tk.getFLN() - 1 : -1, dd.getFirstToken().getFileName());
            WorkingStorageSection wss = dd.getWorkingStorageSection();
            if (wss != null) {
                IsFragment wssFr = this.addAnnotation(ddFr, "WORKING STORAGE SECTION", 9, wss.getFirstToken().getFLN() - 1, (tk = wss.getLastToken()) != null ? tk.getFLN() - 1 : -1, wss.getFirstToken().getFileName());
                this.loadVariables(wssFr, wss.getVariableDeclarationList());
            }
            if ((lnks = dd.getLinkageSection()) != null) {
                IsFragment lnksFr = this.addAnnotation(ddFr, "LINKAGE SECTION", 10, lnks.getFirstToken().getFLN() - 1, (tk = lnks.getLastToken()) != null ? tk.getFLN() - 1 : -1, lnks.getFirstToken().getFileName());
                this.loadVariables(lnksFr, lnks.getVariableDeclarationList());
            }
            if ((scrs = dd.getScreenSection()) != null) {
                IsFragment scrsFr = this.addAnnotation(ddFr, "SCREEN SECTION", 11, scrs.getFirstToken().getFLN() - 1, (tk = scrs.getLastToken()) != null ? tk.getFLN() - 1 : -1, scrs.getFirstToken().getFileName());
                this.loadVariables(scrsFr, scrs.getVariableDeclarationList());
            }
            if ((fs = dd.getFileSection()) != null) {
                IsFragment fsFr = this.addAnnotation(ddFr, "FILE SECTION", 12, fs.getFirstToken().getFLN() - 1, (tk = fs.getLastToken()) != null ? tk.getFLN() - 1 : -1, fs.getFirstToken().getFileName());
                this.loadVariables(fsFr, fs.getFileDescriptorList());
            }
        }
    }

    private static Paragraph getNextParSameFile(Paragraph[] pList, int idx, String filename) {
        int i = idx;
        while (i < pList.length) {
            if (pList[i].getNameToken().getFileName() == filename) {
                return pList[i];
            }
            ++i;
        }
        return null;
    }

    public static String[] retrieveCompOpts(IFile file) {
        return VcobolReconcilingEngine.retrieveCompOpts((IFile)file, null, null);
    }

    public static String[] retrieveCompOpts(IFile file, String formatOpt, String spOpt) {
        Vector<String> optVector = new Vector<String>();
        IProject project = file.getProject();
        String projectCurrMode = PluginUtilities.getCurrentSettingMode((IResource)project);
        String fileCurrMode = PluginUtilities.getCurrentSettingMode((IResource)file);
        int i = 0;
        while (i < FIXED_COMP_OPTS.size()) {
            String key = FIXED_COMP_OPTS.elementAt(i).toString();
            String v = null;
            if (fileCurrMode != null) {
                v = PluginUtilities.getPersistentProperty((IResource)file, (String)fileCurrMode, (String)key);
                if (v == null) {
                    v = PluginUtilities.getPersistentProperty((IResource)project, (String)fileCurrMode, (String)key);
                }
            } else {
                v = PluginUtilities.getPersistentProperty((IResource)project, (String)projectCurrMode, (String)key);
            }
            if (v != null && !v.equals("___vcobol.option.false")) {
                if (OptionList.hasValue((String)key)) {
                    optVector.addElement(String.valueOf(key) + v);
                } else {
                    optVector.addElement(key);
                }
            }
            ++i;
        }
        if (formatOpt == null) {
            formatOpt = fileCurrMode != null ? PluginUtilities.getFormatOption((IResource)file, (String)fileCurrMode) : PluginUtilities.getFormatOption((IResource)file.getProject(), (String)projectCurrMode);
        }
        if (formatOpt != null && formatOpt.length() > 0) {
            optVector.addElement(formatOpt);
        }
        if (spOpt != null) {
            optVector.addElement("-sp=" + spOpt);
        } else {
            optVector.addElement("-sp=" + PluginUtilities.getAbsoluteSourcePath((IFile)file, (String)projectCurrMode));
        }
        optVector.addElement("-jj");
        String[] Return = new String[optVector.size()];
        optVector.toArray(Return);
        return Return;
    }

    private IsFragment addVarAnnotation(IsFragment parent, int startLine, VariableDeclaration v) {
        String qnStr;
        boolean isFiller = v.isFiller();
        if (!isFiller) {
            if (v.getProg() > 0) {
                StringBuffer qn = new StringBuffer();
                VariableDeclaration par = v.getParentNoRedefines();
                if (par != null) {
                    qn.append(par.getName());
                    par = par.getParentNoRedefines();
                    while (par != null) {
                        qn.append(" - ").append(par.getName());
                        par = par.getParentNoRedefines();
                    }
                }
                qnStr = qn.toString();
            } else {
                qnStr = null;
            }
        } else {
            qnStr = null;
        }
        switch (v.getLevel()) {
            case 78: {
                VarDecl varDecl = VarDecl.get78VarDecl((IsFragment)parent, (String)v.getName(), (int)startLine, (String)v.getValue());
            }
            case 88: {
                VarDecl varDecl = VarDecl.get88VarDecl((IsFragment)parent, (String)v.getName(), (int)startLine, (String)qnStr, (int)v.getLevel(), (String)v.getValues(), (boolean)isFiller);
            }
        }
        VarDecl Return = new VarDecl(parent, v.getName().toLowerCase(), startLine, qnStr, v.getLevel(), v.getTypeName(), v.getPicture(), v.getUsage(), v.getValue(), isFiller, v.isObjectReference());
        if (this.wu && !v.isUsed() && !v.isExternal() && !v.isFiller()) {
            this.unusedVars.add(Return);
        }
        int offs = v.getNameToken().getOffset();
        if (this.format == 1) {
            offs += 7;
        }
        Return.setOffset(offs);
        return Return;
    }

    public Vector getUnusedVariables() {
        return this.unusedVars;
    }

    private IsFragment addAnnotation(IsFragment parent, String name, int type, int firstLine, int lastLine, String fn) {
        IsFragment Return = null;
        if (this.document != null) {
            int numOfLines = this.document.getNumberOfLines();
            try {
                firstLine = firstLine >= this.positionShift ? (firstLine -= this.positionShift) : 0;
                if (firstLine > numOfLines - 1) {
                    firstLine = numOfLines - 1;
                }
                IRegion startInfo = this.document.getLineInformation(firstLine);
                IRegion endInfo = lastLine >= this.positionShift ? this.document.getLineInformation(lastLine -= this.positionShift) : this.document.getLineInformation(numOfLines - 1);
                Position pos = new Position(startInfo.getOffset(), endInfo.getOffset() + endInfo.getLength() - startInfo.getOffset());
                this.positions.add(pos);
                Return = new IsFragment(parent, type, name, pos);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (Return == null) {
            Return = new IsFragment(parent, type, name, firstLine, lastLine);
        }
        Return.setFilename(fn);
        return Return;
    }

    public Pcc getReturnPcc() {
        return this.pccReturn;
    }
}

