/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor;

import com.iscobol.compiler.Pcc;
import com.vcobol.plugins.editor.VcobolEditor;
import com.vcobol.plugins.editor.VcobolEditorPlugin;
import com.vcobol.plugins.editor.VcobolReconcilingEngine;
import com.vcobol.plugins.editor.VresourceBundle;
import com.vcobol.plugins.editor.annotations.CopyAnnotation;
import com.vcobol.plugins.editor.util.ErrorObj;
import com.vcobol.plugins.editor.util.PluginUtilities;
import com.veryant.commons.editor.util.CopyFileName;
import com.veryant.commons.editor.util.IsFragment;
import com.veryant.commons.editor.util.VarDecl;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

public class VcobolReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private IDocument document;
    private VcobolEditor editor;
    private ArrayList positions = new ArrayList();

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        if (VcobolEditorPlugin.getDefault().getPreferenceStore().getBoolean("vcobol.reconciling.enabled")) {
            this.reconcile(true);
        }
    }

    public void reconcile(IRegion region) {
        if (VcobolEditorPlugin.getDefault().getPreferenceStore().getBoolean("vcobol.reconciling.enabled")) {
            this.reconcile(true);
        }
    }

    protected Reader getReader(IDocument document) {
        String documentText = document.get();
        StringReader reader = new StringReader(documentText);
        return reader;
    }

    protected int getPositionShift() {
        return 0;
    }

    private void reconcile(boolean createErrorMarkers) {
        VcobolReconcilingEngine engine;
        Pcc pcc;
        IsFragment program;
        String prjCurrMode;
        String filename;
        IFile file;
        block52: {
            if (this.document == null || this.editor.getProject() == null) {
                return;
            }
            Display.getDefault().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            this.positions.clear();
            file = null;
            if (this.editor.getFileEditorInput() != null) {
                file = this.editor.getFileEditorInput().getFile();
            }
            filename = this.editor.getEditorInput().getName();
            String formatOption = PluginUtilities.getFormatOption((int)this.editor.getFormat());
            prjCurrMode = PluginUtilities.getCurrentSettingMode((IResource)this.editor.getProject());
            ClassLoader cLoader = PluginUtilities.getClassLoader((IProject)this.editor.getProject(), (String)prjCurrMode);
            String spOption = "";
            if (this.editor.getProject() != null) {
                spOption = PluginUtilities.getAbsoluteSourcePath((VcobolEditor)this.editor, (String)PluginUtilities.getCurrentSettingMode((IResource)this.editor.getProject()));
            }
            String[] compOpts = file != null ? VcobolReconcilingEngine.retrieveCompOpts((IFile)file, (String)formatOption, (String)spOption) : new String[]{};
            Reader reader = this.getReader(this.document);
            program = null;
            pcc = null;
            engine = null;
            try {
                engine = new VcobolReconcilingEngine(reader, filename, compOpts, cLoader, this.editor.getViewer().getDocument(), this.positions, this.getPositionShift());
                engine.setFile(file);
                program = engine.reconcile();
                pcc = engine.getReturnPcc();
            }
            catch (Exception ex) {
                PluginUtilities.log((Throwable)ex);
            }
            try {
                reader.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            if (program != null && pcc != null) break block52;
            Display.getDefault().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            return;
        }
        try {
            try {
                if (file != null) {
                    IAnnotationModel model;
                    program.setFile(file);
                    Vector v = pcc.getErrors().getAllMessages();
                    CopyFileName[] fileNames = PluginUtilities.getCopyFileNames((Vector)pcc.getCopyFilesNames());
                    if (this.editor != null && this.editor.getFormat() == 0) {
                        this.editor.setFormat(engine.getFormat());
                    }
                    try {
                        file.deleteMarkers("com.vcobol.plugins.editor.VcobolEditor.VcobolProblemMarker", true, 2);
                        int size = v.size();
                        if (createErrorMarkers) {
                            String currMode = PluginUtilities.getCurrentSettingMode((IResource)file);
                            boolean isAnsi = false;
                            isAnsi = currMode != null ? PluginUtilities.isAnsiFormat((IResource)file, (String)currMode) : PluginUtilities.isAnsiFormat((IResource)this.editor.getProject(), (String)prjCurrMode);
                            int i = 0;
                            while (i < size) {
                                ErrorObj error = (ErrorObj)v.elementAt(i);
                                if (error.getErrorType() == 4 && error.getErrorNumber() != 86 || error.getErrorType() == 3 || error.getErrorType() == 2) {
                                    if (error.getFilename().equalsIgnoreCase(file.getName())) {
                                        IMarker marker = null;
                                        switch (error.getErrorType()) {
                                            case 4: {
                                                marker = file.createMarker("com.vcobol.plugins.editor.VcobolEditor.VcobolErrorMarker");
                                                marker.setAttribute("severity", 2);
                                                marker.setAttribute("priority", 2);
                                                break;
                                            }
                                            case 3: {
                                                marker = file.createMarker("com.vcobol.plugins.editor.VcobolEditor.VcobolWarningMarker");
                                                marker.setAttribute("severity", 1);
                                                marker.setAttribute("priority", 1);
                                                break;
                                            }
                                            case 2: {
                                                marker = file.createMarker("com.vcobol.plugins.editor.VcobolEditor.VcobolWarningMarker");
                                                marker.setAttribute("severity", 1);
                                                marker.setAttribute("priority", 0);
                                            }
                                        }
                                        marker.setAttribute("location", (Object)error.getFilename());
                                        marker.setAttribute("message", (Object)error.getMessage());
                                        marker.setAttribute("lineNumber", error.getLineNumber());
                                        int start = this.document.getLineOffset(error.getLineNumber() - 1);
                                        if (isAnsi) {
                                            start += 7;
                                        }
                                        marker.setAttribute("charStart", start += error.getOffset());
                                        if (error.getOther() != null) {
                                            marker.setAttribute("charEnd", start + error.getOther().length());
                                        } else {
                                            marker.setAttribute("charEnd", start + 1);
                                        }
                                    } else {
                                        int lineNumber = 0;
                                        int j = 0;
                                        while (j < fileNames.length && lineNumber == 0) {
                                            if (fileNames[j].getCopy().replace('\\', '/').equals(error.getPathFilename())) {
                                                lineNumber = fileNames[j].getLineNumber();
                                            }
                                            ++j;
                                        }
                                        if (lineNumber > 0) {
                                            IMarker infoMarker = file.createMarker("com.vcobol.plugins.editor.VcobolEditor.VcobolInfoMarker");
                                            infoMarker.setAttribute("priority", 2);
                                            infoMarker.setAttribute("severity", 0);
                                            infoMarker.setAttribute("lineNumber", lineNumber);
                                            infoMarker.setAttribute("message", (Object)VresourceBundle.getString((String)"copy_err_msg"));
                                        }
                                    }
                                }
                                ++i;
                            }
                            Vector unusedVars = engine.getUnusedVariables();
                            int i2 = 0;
                            while (i2 < unusedVars.size()) {
                                VarDecl vd = (VarDecl)unusedVars.elementAt(i2);
                                if (new File(vd.getFilename()).getName().equalsIgnoreCase(file.getName())) {
                                    IMarker marker = file.createMarker("com.vcobol.plugins.editor.VcobolEditor.VcobolWarningMarker");
                                    marker.setAttribute("location", (Object)vd.getFilename());
                                    marker.setAttribute("message", (Object)("Variable '" + vd.getName() + "' is not used"));
                                    marker.setAttribute("priority", 0);
                                    marker.setAttribute("severity", 1);
                                    marker.setAttribute("lineNumber", vd.getStartLine() + 1);
                                }
                                ++i2;
                            }
                        }
                    }
                    catch (Exception size) {
                        // empty catch block
                    }
                    if ((model = this.editor.getViewer().getAnnotationModel()) != null) {
                        Iterator it = model.getAnnotationIterator();
                        while (it.hasNext()) {
                            Annotation ann = (Annotation)it.next();
                            if (!(ann instanceof SimpleMarkerAnnotation)) continue;
                            IMarker marker = ((SimpleMarkerAnnotation)ann).getMarker();
                            try {
                                if (!marker.isSubtypeOf("org.eclipse.core.resources.problemmarker")) continue;
                                model.removeAnnotation(ann);
                            }
                            catch (CoreException i2) {
                                // empty catch block
                            }
                        }
                    }
                    this.editor.setInheritsClass(pcc.getInheritsClass());
                    this.editor.setImplementsClasses(pcc.getImplementsClass());
                    this.editor.setProgName(program.getName());
                    this.editor.clearCopyAnnotations();
                    String projDir = null;
                    try {
                        projDir = PluginUtilities.getProjectRootDir((IProject)this.editor.getProject());
                        if (fileNames.length > 0) {
                            CopyAnnotation lastCa = null;
                            int j = 0;
                            while (j < fileNames.length) {
                                String parentFileName = new File(fileNames[j].getParentFile()).getName();
                                String relPath = PluginUtilities.makeRelative((String)fileNames[j].getCopy(), (String)projDir);
                                IFile ifile = null;
                                if (engine.getFileFinder() != null) {
                                    ifile = (IFile)engine.getFileFinder().getFileMap().get(new File(fileNames[j].getCopy()));
                                }
                                if (ifile == null) {
                                    ifile = (IFile)PluginUtilities.findMember((IContainer)this.editor.getProject(), (IPath)new Path(relPath));
                                }
                                if (ifile != null) {
                                    if (parentFileName.equals(filename)) {
                                        lastCa = new CopyAnnotation(ifile);
                                        this.editor.putCopyAnnotation(fileNames[j].getLineNumber() - 1, lastCa);
                                    } else if (lastCa != null) {
                                        CopyAnnotation copyAnnotation = lastCa;
                                        lastCa = new CopyAnnotation(ifile);
                                        copyAnnotation.putCopyAnnotation(fileNames[j].getLineNumber() - 1, lastCa);
                                    }
                                } else {
                                    String absPath = relPath;
                                    if (parentFileName.equals(filename)) {
                                        lastCa = new CopyAnnotation(absPath);
                                        this.editor.putCopyAnnotation(fileNames[j].getLineNumber() - 1, lastCa);
                                    } else if (lastCa != null) {
                                        CopyAnnotation copyAnnotation = lastCa;
                                        lastCa = new CopyAnnotation(absPath);
                                        copyAnnotation.putCopyAnnotation(fileNames[j].getLineNumber() - 1, lastCa);
                                    }
                                }
                                ++j;
                            }
                        }
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                IsFragment pr = program;
                Display.getDefault().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (Exception e) {
                e.printStackTrace();
                Display.getDefault().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        catch (Throwable throwable) {
            Display.getDefault().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            throw throwable;
        }
        Display.getDefault().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public void initialReconcile() {
        this.reconcile(true);
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    void setEditor(VcobolEditor editor) {
        this.editor = editor;
    }

    static /* synthetic */ VcobolEditor access$0(VcobolReconcilingStrategy vcobolReconcilingStrategy) {
        return vcobolReconcilingStrategy.editor;
    }

    static /* synthetic */ ArrayList access$1(VcobolReconcilingStrategy vcobolReconcilingStrategy) {
        return vcobolReconcilingStrategy.positions;
    }
}

