/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor;

import com.vcobol.plugins.editor.DisplayCobolElementTextHover;
import com.vcobol.plugins.editor.VcobolAutoEditStrategy;
import com.vcobol.plugins.editor.VcobolCompletionProcessor;
import com.vcobol.plugins.editor.VcobolDoubleClickSelector;
import com.vcobol.plugins.editor.VcobolEditor;
import com.vcobol.plugins.editor.VcobolEditorPlugin;
import com.vcobol.plugins.editor.VcobolReconcilingStrategy;
import com.vcobol.plugins.editor.annotations.CopyAnnotation;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.RGB;

public class VcobolSourceViewerConfiguration
extends SourceViewerConfiguration {
    protected VcobolEditor editor;
    private MonoReconciler reconciler;
    private IAnnotationHover annotationHover;
    private VcobolCompletionProcessor vcobolCompletionProcessor;

    public VcobolSourceViewerConfiguration() {
    }

    public VcobolSourceViewerConfiguration(VcobolEditor editor) {
        this.editor = editor;
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        return null;
    }

    public VcobolEditor getEditor() {
        return this.editor;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        return new IAutoEditStrategy[]{new VcobolAutoEditStrategy(this)};
    }

    private Annotation[] findAnnotations(ISourceViewer textViewer, int line) {
        try {
            IRegion info = textViewer.getDocument().getLineInformation(line);
            IAnnotationModel model = textViewer.getAnnotationModel();
            if (model != null) {
                Iterator it = model.getAnnotationIterator();
                Vector<Annotation> result = new Vector<Annotation>(2);
                while (it.hasNext()) {
                    Annotation a = (Annotation)it.next();
                    Position p = model.getPosition(a);
                    if (p == null || !p.overlapsWith(info.getOffset(), info.getLength())) continue;
                    result.addElement(a);
                }
                Annotation[] Return = new Annotation[result.size()];
                result.toArray(Return);
                int lastIdx = 0;
                int i = 1;
                while (i < Return.length) {
                    if (Return[i] instanceof CopyAnnotation && lastIdx < i) {
                        Annotation tmp = Return[i];
                        Return[i] = Return[lastIdx];
                        Return[lastIdx] = tmp;
                        ++lastIdx;
                    }
                    ++i;
                }
                return Return;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return new Annotation[0];
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        if (this.annotationHover == null) {
            this.annotationHover = new /* Unavailable Anonymous Inner Class!! */;
        }
        return this.annotationHover;
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return "__vcobol_partitioning";
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "", ""};
    }

    protected VcobolCompletionProcessor createVcobolCompletionProcessor() {
        return new VcobolCompletionProcessor(this.editor);
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        assistant.setContentAssistProcessor((IContentAssistProcessor)this.createVcobolCompletionProcessor(), "__dftl_partition_content_type");
        assistant.enableAutoActivation(true);
        assistant.setAutoActivationDelay(500);
        assistant.setProposalPopupOrientation(10);
        assistant.setContextInformationPopupOrientation(20);
        assistant.setContextInformationPopupBackground(VcobolEditorPlugin.getDefault().getColorProvider().getColor(new RGB(150, 150, 0)));
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        return assistant;
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public String getDefaultPrefix(ISourceViewer sourceViewer, String contentType) {
        return "__dftl_partition_content_type".equals(contentType) ? "//" : null;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        return new VcobolDoubleClickSelector();
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{this.editor.getTabSpaces()};
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)VcobolEditorPlugin.getDefault().getIscobolCodeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        return reconciler;
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        return this.editor.getTabWidth();
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new DisplayCobolElementTextHover(this.editor);
    }

    protected VcobolReconcilingStrategy getVcobolStrategy() {
        return new VcobolReconcilingStrategy();
    }

    public VcobolCompletionProcessor getVcobolCompletionProcessor() {
        if (this.vcobolCompletionProcessor == null) {
            this.vcobolCompletionProcessor = this.createVcobolCompletionProcessor();
        }
        return this.vcobolCompletionProcessor;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (this.reconciler != null) {
            return this.reconciler;
        }
        VcobolReconcilingStrategy strategy = this.getVcobolStrategy();
        strategy.setEditor(this.editor);
        this.reconciler = new MonoReconciler((IReconcilingStrategy)strategy, false);
        this.reconciler.setDelay(1000);
        return this.reconciler;
    }

    static /* synthetic */ Annotation[] access$0(VcobolSourceViewerConfiguration vcobolSourceViewerConfiguration, ISourceViewer iSourceViewer, int n) {
        return vcobolSourceViewerConfiguration.findAnnotations(iSourceViewer, n);
    }
}

