/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.actions;

import com.vcobol.plugins.editor.dialogs.SetCurrentModeDialog;
import com.vcobol.plugins.editor.util.PluginUtilities;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public abstract class ChangeModeAction
extends Action {
    private IProject selectedProject;
    private Shell shell;

    public void run() {
        if (this.selectedProject == null || this.shell == null) {
            return;
        }
        String[] modes = PluginUtilities.getSettingModes((IResource)this.selectedProject);
        String currMode = PluginUtilities.getCurrentSettingMode((IResource)this.selectedProject);
        SetCurrentModeDialog scd = new SetCurrentModeDialog(this.shell, this.selectedProject.getName(), modes, currMode);
        String newCurrMode = scd.openDialog();
        if (newCurrMode != null && !newCurrMode.equals(currMode)) {
            PluginUtilities.setCurrentSettingMode((String)newCurrMode, (IResource)this.selectedProject);
            PluginUtilities.saveProjectOptions((IProject)this.selectedProject);
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IResource resource;
        IEditorPart activeEditor;
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            this.selectedProject = this.getIscobolProject((IStructuredSelection)selection);
        }
        if (this.selectedProject == null && (activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()) != null && activeEditor.getEditorInput() != null && (resource = (IResource)activeEditor.getEditorInput().getAdapter(IResource.class)) != null) {
            this.selectedProject = resource.getProject();
        }
        if (this.selectedProject != null) {
            action.setEnabled(true);
        } else {
            action.setEnabled(false);
        }
    }

    private IProject getIscobolProject(IStructuredSelection selection) {
        if (selection.getFirstElement() instanceof IProject) {
            IProject prj = (IProject)selection.getFirstElement();
            try {
                if (prj.getNature("com.vcobol.plugins.editor.VcobolEditor.VcobolNature") != null) {
                    return prj;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    protected void setShell(Shell shell) {
        this.shell = shell;
    }
}

