/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.actions;

import com.vcobol.plugins.editor.VcobolEditor;
import com.vcobol.plugins.editor.VcobolEditorPlugin;
import com.vcobol.plugins.editor.VresourceBundle;
import com.vcobol.plugins.editor.builder.VcobolBuilder;
import com.vcobol.plugins.editor.util.InternalErrorException;
import com.vcobol.plugins.editor.util.PluginUtilities;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.ResourceAction;

public abstract class CompileAction
extends ResourceAction {
    public CompileAction() {
        super(VresourceBundle.getBundle(), "compileAction.", 1);
    }

    protected void compile(IFile file, Shell shell) throws CoreException {
        ProgressMonitorDialog d = new ProgressMonitorDialog(shell);
        boolean[] Return = new boolean[]{true};
        VcobolEditor editor = PluginUtilities.findVcobolEditorForInput((IFile)file);
        if (editor != null) {
            editor.getViewer().SetRedraw(false);
        }
        try {
            IPreferenceStore store;
            boolean showMsg;
            try {
                d.run(true, true, (IRunnableWithProgress)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (InvocationTargetException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (InterruptedException e) {
                throw new InternalErrorException((Throwable)e);
            }
            if (editor != null) {
                editor.getViewer().SetRedraw(true);
            }
            if (showMsg = (store = VcobolEditorPlugin.getDefault().getPreferenceStore()).getBoolean("vcobol.promptcompresult")) {
                if (Return[0]) {
                    MessageDialogWithToggle.openInformation((Shell)shell, (String)("Compilation of '" + file.getFullPath() + "'"), (String)VresourceBundle.getString((String)"compiled_correctly_msg"), (String)VresourceBundle.getString((String)"dont_show_msg"), (boolean)false, (IPreferenceStore)store, (String)"vcobol.promptcompresult");
                } else {
                    MessageDialogWithToggle.openWarning((Shell)shell, (String)("Compilation of '" + file.getFullPath() + "'"), (String)VresourceBundle.getString((String)"cannot_compiled_msg"), (String)VresourceBundle.getString((String)"dont_show_msg"), (boolean)false, (IPreferenceStore)store, (String)"vcobol.promptcompresult");
                }
            }
        }
        finally {
            if (editor != null) {
                editor.getViewer().SetRedraw(true);
            }
        }
    }

    private boolean compile0(IFile file, Shell shell, IProgressMonitor monitor) throws CoreException {
        String s = PluginUtilities.getPersistentProperty((IResource)file.getProject(), (String)"Default", (String)"vcobol.checkfileopt");
        boolean useFileOpt = s != null && !s.equals("___vcobol.option.false");
        String projectCurrMode = PluginUtilities.getCurrentSettingMode((IResource)file.getProject());
        return VcobolBuilder.build((IFile[])new IFile[]{file}, (IProject)file.getProject(), (String)projectCurrMode, null, (IProgressMonitor)monitor, (int)1, (boolean)useFileOpt);
    }

    public abstract void run();

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    static /* synthetic */ boolean access$0(CompileAction compileAction, IFile iFile, Shell shell, IProgressMonitor iProgressMonitor) throws CoreException {
        return compileAction.compile0(iFile, shell, iProgressMonitor);
    }
}

