/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.actions;

import com.vcobol.plugins.editor.VcobolEditor;
import com.vcobol.plugins.editor.VresourceBundle;
import com.vcobol.plugins.editor.actions.CompileAction;
import com.vcobol.plugins.editor.util.PluginUtilities;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;

public class CompileEditorActionDelegate
extends CompileAction
implements IEditorActionDelegate {
    private VcobolEditor editor;

    public void run() {
        VcobolEditor editor = this.check();
        if (editor != null) {
            boolean ok;
            boolean bl = ok = !editor.isDirty();
            if (!ok) {
                MessageBox mb = new MessageBox(editor.getEditorSite().getShell(), 288);
                mb.setMessage(editor.getEditorInput().getName() + " " + VresourceBundle.getString((String)"has_been_mod_msg"));
                boolean bl2 = ok = mb.open() == 32;
            }
            if (ok) {
                try {
                    editor.doSave(null);
                    IFile file = editor.getFileEditorInput().getFile();
                    this.compile(file, editor.getEditorSite().getShell());
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
    }

    VcobolEditor check() {
        if (this.editor == null) {
            return null;
        }
        if (this.editor.getProject() == null) {
            this.error(this.editor.getEditorSite().getShell(), VresourceBundle.getString((String)"missing_project_msg"));
            return null;
        }
        if (this.editor.getFileEditorInput() == null || !PluginUtilities.isTextFile((IFile)this.editor.getFileEditorInput().getFile())) {
            this.error(this.editor.getEditorSite().getShell(), VresourceBundle.getString((String)"invalid_sourcefile_msg"));
            return null;
        }
        if (!PluginUtilities.isInSourceFolder((IFile)this.editor.getFileEditorInput().getFile())) {
            this.error(this.editor.getEditorSite().getShell(), VresourceBundle.getString((String)"file_not_in_src_fld_ext_msg"));
            return null;
        }
        return this.editor;
    }

    private void error(Shell shell, String msg) {
        MessageBox mb = new MessageBox(shell, 1);
        mb.setMessage(msg);
        mb.open();
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.editor = targetEditor instanceof VcobolEditor ? (VcobolEditor)targetEditor : null;
    }
}

