/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.actions;

import com.vcobol.plugins.editor.VcobolEditor;
import com.vcobol.plugins.editor.VcobolOutlinePage;
import com.vcobol.plugins.editor.annotations.CopyAnnotation;
import com.veryant.commons.editor.util.IOFileStorage;
import com.veryant.commons.editor.util.IOFileStorageEditorInput;
import java.io.File;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SelectMarkerRulerAction;

public class CopySelectAnnotationAction
extends SelectMarkerRulerAction {
    public static final String rcsid = "$Id: CopySelectAnnotationAction.java,v 1.6 2009/04/06 09:45:22 gianni Exp $";
    private VcobolEditor editor;
    private IVerticalRulerInfo verticalRuler;
    private CopyAnnotation annotation;

    public CopySelectAnnotationAction(ResourceBundle bundle, String prefix, VcobolEditor editor) {
        this(bundle, prefix, (ITextEditor)editor, (IVerticalRulerInfo)editor.getVRuler());
    }

    public CopySelectAnnotationAction(ResourceBundle bundle, String prefix, ITextEditor editor, IVerticalRulerInfo ruler) {
        super(bundle, prefix, editor, ruler);
        if (editor instanceof VcobolEditor) {
            this.editor = (VcobolEditor)editor;
        }
        this.verticalRuler = ruler;
        this.setAccelerator(0x100000C);
    }

    private void intRun() {
        this.findAnnotation();
        if (this.annotation != null) {
            try {
                IFile copyfile = this.annotation.getFile();
                Object input = copyfile != null ? new FileEditorInput(copyfile) : new IOFileStorageEditorInput(new IOFileStorage(new File(this.annotation.getFilename()), false));
                VcobolEditor newEditor = (VcobolEditor)this.editor.getEditorSite().getPage().openEditor((IEditorInput)input, VcobolEditor.ID, true, 3);
                if (newEditor.getProject() == null && this.editor.getProject() != null) {
                    newEditor.setProject(this.editor.getProject());
                }
                this.annotation.putAllCopyAnnotation(newEditor);
                VcobolOutlinePage outPage = (VcobolOutlinePage)this.editor.getOutlinePage();
                VcobolOutlinePage newOutPage = (VcobolOutlinePage)newEditor.getOutlinePage();
                newOutPage.setInput(outPage.getInput());
                if (newOutPage.getTreeViewer() != null && outPage.getTreeViewer() != null) {
                    newOutPage.getTreeViewer().setExpandedElements(outPage.getTreeViewer().getExpandedElements());
                }
            }
            catch (PartInitException partInitException) {
                // empty catch block
            }
        }
    }

    public void run() {
        this.intRun();
        super.run();
    }

    private void findAnnotation() {
        if (this.editor == null) {
            this.annotation = null;
            return;
        }
        int line = this.verticalRuler.getLineOfLastMouseButtonActivity();
        this.annotation = this.editor.getCopyAnnotation(line);
    }

    public void runWithEvent(Event event) {
        this.intRun();
    }

    public void update() {
        this.setEnabled(true);
        super.update();
    }
}

