/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.actions;

import com.iscobol.compiler.PreProcessor;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.vcobol.plugins.editor.Tokens;
import com.vcobol.plugins.editor.VcobolEditor;
import com.vcobol.plugins.editor.VresourceBundle;
import com.veryant.commons.editor.util.IsFragment;
import com.veryant.commons.editor.util.VarDecl;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;

public class CorrectIndentationAction
extends Action
implements IEditorActionDelegate {
    protected IEditorPart editor;
    protected int startLine = -1;
    protected int endLine = -1;
    protected int startOffs = -1;
    protected int endOffs = -1;
    private TextViewer viewer;
    private VcobolEditor vcobolEditor;
    public static final String ID = "com.vcobol.plugins.editor.actions.CorrectIndentationAction";
    public static final String DEFINITION_ID = "com.veryant.commons.editor.commands.textCorrectIndentation";
    private static final String eol = System.getProperty("line.separator", "\n");

    public CorrectIndentationAction() {
        this.setText(VresourceBundle.getString((String)"correctIndentationAction.label"));
        this.setActionDefinitionId(DEFINITION_ID);
        this.setId(ID);
    }

    public CorrectIndentationAction(String text, String toolTipText, ImageDescriptor image) {
        this.setText(text);
        this.setToolTipText(toolTipText);
        this.setImageDescriptor(image);
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.editor = targetEditor;
    }

    public void run(IAction action) {
        this.run();
    }

    public void run() {
        StyledText styledText;
        String newText;
        this.getSelectionRanges();
        TextViewer viewer = this.viewer;
        int sl = this.startLine;
        int el = this.endLine;
        int so = this.startOffs;
        int eo = this.endOffs;
        VcobolEditor isEd = this.vcobolEditor;
        if (isEd != null && viewer != null && sl >= 0 && (newText = this.indentText(isEd, styledText = viewer.getTextWidget(), sl, el)) != null) {
            int cp = styledText.getCaretOffset();
            IUndoManager manager = viewer.getUndoManager();
            manager.beginCompoundChange();
            styledText.replaceTextRange(so, eo - so, newText);
            manager.endCompoundChange();
            styledText.setCaretOffset(cp);
        }
    }

    protected String indentText(VcobolEditor isEd, StyledText styledText, int sl, int el) {
        int[] lineIndent = new int[el - sl + 1];
        TokenList[] tls = new TokenList[el - sl + 1];
        StringBuffer Return = new StringBuffer();
        int lineIdx = sl;
        while (lineIdx <= el) {
            Return.append(this.indentLine(isEd, styledText, lineIdx, sl, lineIndent, tls));
            if (lineIdx < el) {
                Return.append(eol);
            }
            ++lineIdx;
        }
        return Return.toString();
    }

    private boolean isComment(Token tk, int format) {
        return tk.getToknum() == 42 && (tk.getOffset() == 6 && format == 1 || tk.getOffset() == 0 && format == 2) || tk.getWord().startsWith(">*");
    }

    protected String indentLine(VcobolEditor isEd, StyledText styledText, int lineIdx, int sl, int[] lineIndent, TokenList[] tls) {
        TokenList tl;
        Token first;
        IsFragment fr = isEd.getFragmentAtLine(lineIdx);
        StringBuffer line = new StringBuffer(styledText.getLine(lineIdx));
        int tabWidth = isEd.getTabWidth();
        int type = 0;
        if (fr != null) {
            type = fr.getType();
        }
        if ((first = (tl = this.getTokenList(lineIdx - sl, tls, lineIdx, styledText)).getFirst()) == null || this.isComment(first, isEd.getFormat())) {
            return line.toString();
        }
        boolean ok = false;
        switch (type) {
            case 13: {
                Token tk;
                IsFragment sec = fr;
                while (sec.getType() == 13) {
                    sec = sec.getParent();
                }
                int level = ((VarDecl)fr).getLevel();
                if (level == 77) {
                    level = 1;
                }
                int indent = (tk = this.findLevelNumberLess(level, styledText, lineIdx - 1, sl, tls, sec.getName().toUpperCase())) == null || tk.getToknum() != 10002 ? 0 : tabWidth;
                this.indent(isEd, line, tk, first, lineIdx, sl, lineIndent, indent);
                break;
            }
            case 5: {
                int indent;
                Token tk;
                if (first.getWord().toUpperCase().equals(fr.getName())) {
                    Token tk2 = this.findToken(640, styledText, lineIdx - 1, sl, tls);
                    this.indent(isEd, line, tk2, first, lineIdx, sl, lineIndent, 0);
                    break;
                }
                String openToken = (String)Tokens.endTokens.get(first.getWord().toUpperCase());
                if (openToken != null) {
                    tk = this.findOpenToken(styledText, lineIdx - 1, sl, tls, openToken);
                    indent = 0;
                } else {
                    tk = this.findOpenToken(styledText, lineIdx - 1, sl, tls);
                    indent = tk == null || tk.getToknum() == 640 ? 4 : tabWidth;
                }
                this.indent(isEd, line, tk, first, lineIdx, sl, lineIndent, indent);
                break;
            }
            default: {
                int indent;
                String openToken;
                Token tk;
                if (first.getToknum() == 10009) {
                    tk = tl.getNext();
                    if (tk != null && tk.getToknum() == 10006) {
                        tk = this.findToken(640, styledText, lineIdx - 1, sl, tls);
                        if (tk != null) {
                            this.indent(isEd, line, tk, first, lineIdx, sl, lineIndent, 0);
                            ok = true;
                        }
                    } else if (tk != null) {
                        tl.getPrevious();
                    }
                }
                if (!ok && (openToken = (String)Tokens.endTokens.get(first.getWord().toUpperCase())) != null && (tk = this.findOpenToken(styledText, lineIdx - 1, sl, tls, openToken)) != null) {
                    this.indent(isEd, line, tk, first, lineIdx, sl, lineIndent, 0);
                    ok = true;
                }
                if (!ok && (tk = this.findOpenToken(styledText, lineIdx - 1, sl, tls)) != null) {
                    indent = tk.getToknum() == 640 ? 4 : tabWidth;
                    this.indent(isEd, line, tk, first, lineIdx, sl, lineIndent, indent);
                    ok = true;
                }
                if (ok) break;
                int level = Tokens.getLevelNumber((String)first.getWord());
                if (level == 77) {
                    level = 1;
                }
                if ((tk = this.findLevelNumberLess(level, styledText, lineIdx - 1, sl, tls, null)) == null) break;
                indent = tk.getToknum() != 10002 ? 0 : tabWidth;
                this.indent(isEd, line, tk, first, lineIdx, sl, lineIndent, indent);
                ok = true;
            }
        }
        return line.toString();
    }

    private void indent(VcobolEditor isEd, StringBuffer line, Token openToken, Token currToken, int lineIdx, int sl, int[] lineIndent, int currTokenIndent) {
        if (openToken != null) {
            int fln = openToken.getFLN() - 1 - sl;
            int indent = fln >= 0 && fln < lineIndent.length ? lineIndent[fln] : 0;
            int diff = openToken.getOffset() + indent - currToken.getOffset() + currTokenIndent;
            if (diff < 0) {
                line.delete(currToken.getOffset() + diff, currToken.getOffset());
            } else if (diff > 0) {
                line.insert(currToken.getOffset(), this.getSpaces(diff));
                if (isEd.getFormat() == 1 && line.length() > 72 && line.charAt(71 - diff) != ' ') {
                    int idx = line.lastIndexOf(" ", 71 - diff);
                    line.replace(idx, idx, String.valueOf(eol) + "            ");
                }
            }
            lineIndent[lineIdx - sl] = diff;
        }
    }

    private String getSpaces(int n) {
        StringBuffer Return = new StringBuffer();
        int i = 0;
        while (i < n) {
            Return.append(' ');
            ++i;
        }
        return Return.toString();
    }

    private Token cloneToken(Token tk, int fln) {
        return new Token(tk.getToknum(), tk.getWord(), fln, tk.getOffset(), null);
    }

    private TokenList getTokenList(int tlIdx, TokenList[] tls, int lineIdx, StyledText styledText) {
        if (tlIdx >= 0 && tlIdx < tls.length) {
            if (tls[tlIdx] == null) {
                tls[tlIdx] = PreProcessor.tokenizer((StringBuffer)new StringBuffer(styledText.getLine(lineIdx)), (char)'.', (boolean)true, null);
            }
            return tls[tlIdx];
        }
        return PreProcessor.tokenizer((StringBuffer)new StringBuffer(styledText.getLine(lineIdx)), (char)'.', (boolean)true, null);
    }

    private Token findOpenToken(StyledText styledText, int lineIdx, int sl, TokenList[] tls, String openToken) {
        int openBlock = 0;
        int i = lineIdx;
        while (i >= 0) {
            TokenList tl = this.getTokenList(i - sl, tls, i, styledText);
            Token tk = tl.getLast();
            Token tk1 = null;
            while (tk != null) {
                String word = tk.getWord().toUpperCase();
                if (this.isFirst(tl) && word.equals(openToken)) {
                    if (tk1 == null || !word.equals("PERFORM") || tk1.getToknum() != 10009) {
                        if (openBlock == 0) {
                            return this.cloneToken(tk, i + 1);
                        }
                        --openBlock;
                    }
                } else {
                    String s = (String)Tokens.endTokens.get(word);
                    if (s != null && s.equals(openToken)) {
                        if (tk1 == null || !word.equals("PERFORM") || tk1.getToknum() != 10009) {
                            ++openBlock;
                        }
                    } else if (this.isFirst(tl) && tk.getToknum() == 640) {
                        return this.cloneToken(tk, i + 1);
                    }
                }
                tk1 = tk;
                tk = tl.getPrevious();
            }
            --i;
        }
        return null;
    }

    private Token findOpenToken(StyledText styledText, int lineIdx, int sl, TokenList[] tls) {
        int openBlock = 0;
        int i = lineIdx;
        while (i >= 0) {
            TokenList tl = this.getTokenList(i - sl, tls, i, styledText);
            Token tk = tl.getLast();
            Token tk1 = null;
            while (tk != null) {
                String word = tk.getWord().toUpperCase();
                if (this.isFirst(tl) && Tokens.openTokens.containsKey(word)) {
                    if (tk1 == null || !word.equals("PERFORM") || tk1.getToknum() != 10009) {
                        if (openBlock == 0) {
                            return this.cloneToken(tk, i + 1);
                        }
                        --openBlock;
                    }
                } else if (Tokens.endTokens.containsKey(word) || tk.getToknum() == 10006) {
                    ++openBlock;
                } else if (this.isFirst(tl) && tk.getToknum() == 640) {
                    return this.cloneToken(tk, i + 1);
                }
                tk1 = tk;
                tk = tl.getPrevious();
            }
            --i;
        }
        return null;
    }

    private Token findToken(int toknum, StyledText styledText, int lineIdx, int sl, TokenList[] tls) {
        int i = lineIdx;
        while (i >= 0) {
            TokenList tl = this.getTokenList(i - sl, tls, i, styledText);
            Token tk = tl.getLast();
            while (tk != null) {
                if (this.isFirst(tl) && tk.getToknum() == toknum) {
                    return this.cloneToken(tk, i + 1);
                }
                tk = tl.getPrevious();
            }
            --i;
        }
        return null;
    }

    private boolean isFirst(TokenList tl) {
        boolean Return;
        boolean bl = Return = tl.getPrevious() == null;
        if (!Return) {
            tl.getNext();
        }
        return Return;
    }

    private Token findLevelNumberLess(int level, StyledText styledText, int lineIdx, int sl, TokenList[] tls, String secName) {
        int i = lineIdx;
        while (i >= 0) {
            TokenList tl = this.getTokenList(i - sl, tls, i, styledText);
            Token tk = tl.getLast();
            while (tk != null) {
                String word = tk.getWord();
                if (this.isFirst(tl)) {
                    int l = Tokens.getLevelNumber((String)word);
                    if (l > 0 && l < level) {
                        return this.cloneToken(tk, i + 1);
                    }
                    if (secName != null && secName.startsWith(word)) {
                        return this.cloneToken(tk, i + 1);
                    }
                }
                tk = tl.getPrevious();
            }
            --i;
        }
        return null;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private void getSelectionRanges() {
        if (this.editor != null) {
            if (this.editor instanceof VcobolEditor) {
                this.vcobolEditor = (VcobolEditor)this.editor;
                this.viewer = this.vcobolEditor.getViewer();
            } else {
                this.vcobolEditor = (VcobolEditor)this.editor.getAdapter(VcobolEditor.class);
                this.viewer = this.vcobolEditor != null ? this.vcobolEditor.getViewer() : null;
            }
        } else {
            this.viewer = null;
        }
        if (this.viewer == null) {
            this.endOffs = -1;
            this.startOffs = -1;
            this.endLine = -1;
            this.startLine = -1;
            return;
        }
        StyledText styledText = this.viewer.getTextWidget();
        if (styledText.getSelectionCount() > 0) {
            Point sr = styledText.getSelectionRange();
            this.startLine = styledText.getLineAtOffset(sr.x);
            this.endLine = styledText.getLineAtOffset(sr.x + sr.y);
            this.startOffs = styledText.getOffsetAtLine(this.startLine);
            this.endOffs = styledText.getOffsetAtLine(this.endLine) + styledText.getLine(this.endLine).length();
        } else {
            int cp = styledText.getCaretOffset();
            this.startLine = this.endLine = styledText.getLineAtOffset(cp);
            this.startOffs = styledText.getOffsetAtLine(this.startLine);
            this.endOffs = styledText.getOffsetAtLine(this.startLine) + styledText.getLine(this.startLine).length();
        }
    }
}

