/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.actions;

import com.vcobol.plugins.editor.VcobolEditor;
import com.vcobol.plugins.editor.VresourceBundle;
import com.vcobol.plugins.editor.actions.DisplayVarsOnSelLineAction;
import com.vcobol.plugins.editor.actions.VcobolThreadAction;
import com.vcobol.plugins.editor.debug.VcobolDebugTarget;
import com.vcobol.plugins.editor.debug.VcobolThread;
import com.vcobol.plugins.editor.debug.util.TokenManager;
import com.vcobol.plugins.editor.debug.util.VarName;
import com.vcobol.plugins.editor.util.PluginUtilities;
import com.veryant.debugger.protocol.Command;
import com.veryant.debugger.protocol.CommandDisplay;
import com.veryant.debugger.protocol.ResponseDisplay;
import com.veryant.debugger.protocol.VariableIdentifier;
import java.util.Hashtable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

/*
 * Exception performing whole class analysis ignored.
 */
public class DisplayVarsOnSelLineAction
extends VcobolThreadAction
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;
    private Hashtable lastPosTable = new Hashtable();

    public DisplayVarsOnSelLineAction() {
        super("displayVarsOnSelLineAction.", 1);
    }

    public void selectionChanged(IAction action, ISelection sel) {
    }

    public void run() {
        VcobolThread selTh = VcobolDebugTarget.getSelectedThread();
        if (selTh == null) {
            this.outputResult(VresourceBundle.getString((String)"select_thread_msg"), true);
            return;
        }
        IWorkbenchWindow wnd = this.window != null ? this.window : PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IEditorPart activeEditor = wnd.getActivePage().getActiveEditor();
        if (activeEditor instanceof VcobolEditor) {
            VcobolEditor isEd = (VcobolEditor)activeEditor;
            IDocument doc = isEd.getViewer().getDocument();
            int caretPosition = isEd.getViewer().getTextWidget().getCaretOffset();
            String selectedLine = null;
            int selLineNumber = -1;
            try {
                selLineNumber = doc.getLineOfOffset(caretPosition);
                IRegion region = doc.getLineInformation(selLineNumber);
                selectedLine = doc.get(region.getOffset(), region.getLength());
            }
            catch (BadLocationException region) {
                // empty catch block
            }
            if (selectedLine != null) {
                LinePosCouple lpc = (LinePosCouple)this.lastPosTable.get(new Integer(isEd.hashCode()));
                if (lpc != null) {
                    if (lpc.lineNumber != selLineNumber) {
                        lpc.lineNumber = selLineNumber;
                        lpc.lastPosForVarSearch = 0;
                    }
                } else {
                    lpc = new LinePosCouple(null);
                    lpc.lineNumber = selLineNumber;
                    lpc.lastPosForVarSearch = 0;
                    this.lastPosTable.put(new Integer(isEd.hashCode()), lpc);
                }
                this.displayVarsOnSelLine(selectedLine, lpc);
            }
        }
    }

    private void displayVarsOnSelLine(String selectedLine, LinePosCouple lpc) {
        boolean initialPosIsZero;
        boolean bl = initialPosIsZero = lpc.lastPosForVarSearch == 0;
        while (true) {
            if (lpc.lastPosForVarSearch >= selectedLine.length()) {
                lpc.lastPosForVarSearch = 0;
                if (initialPosIsZero) {
                    this.outputResult(VresourceBundle.getString((String)"no_var_found_msg"), true);
                    break;
                }
            }
            if (" =():\".,".indexOf(selectedLine.charAt(lpc.lastPosForVarSearch)) == -1) {
                String word = PluginUtilities.findVariableName((String)selectedLine, (int)lpc.lastPosForVarSearch, (boolean)false);
                if (word == null) break;
                if (DisplayVarsOnSelLineAction.checkWord((String)(word = word.trim()))) {
                    lpc.lastPosForVarSearch += word.length();
                    ResponseDisplay resp = this.displayVar(word);
                    if (resp != null && resp.getReturnCode() == 0) {
                        String msg = String.valueOf(resp.getVariableIdentifier().getFullName()) + " = " + resp.getStringValue();
                        this.outputResult(msg, false);
                        break;
                    }
                }
            }
            ++lpc.lastPosForVarSearch;
        }
    }

    private static boolean checkWord(String word) {
        int len = word.length();
        if (len == 0) {
            return false;
        }
        int i = 0;
        while (i < len) {
            char c = word.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void outputResult(String message, boolean error) {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private ResponseDisplay displayVar(String word) {
        if (word != null && word.length() > 0) {
            VariableIdentifier vId = null;
            TokenManager tm = new TokenManager(word);
            try {
                VarName vn = new VarName(tm);
                vId = VcobolDebugTarget.varNameToVariableIdentifier((VarName)vn);
                VcobolThread th = VcobolDebugTarget.getSelectedThread();
                return (ResponseDisplay)VcobolDebugTarget.getDefault().putSyncCommand((Command)new CommandDisplay(th.getName(), th.getProgName(), vId, false, false));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void runWithEvent(IAction action, Event event) {
        this.run();
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }
}

