/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.actions;

import com.vcobol.plugins.editor.VcobolEditor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;

public abstract class FormatTextAction
extends Action
implements IEditorActionDelegate {
    protected IEditorPart editor;
    protected int[][] selectionRanges;
    private TextViewer viewer;

    public FormatTextAction() {
    }

    public FormatTextAction(String text, String toolTipText, ImageDescriptor image) {
        this.setText(text);
        this.setToolTipText(toolTipText);
        this.setImageDescriptor(image);
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.editor = targetEditor;
    }

    public void run(IAction action) {
        this.run();
    }

    public void run() {
        this.getSelectionRanges();
        TextViewer viewer = this.viewer;
        int[][] selectionRanges = this.selectionRanges;
        if (viewer != null && selectionRanges != null) {
            String[] origText = new String[selectionRanges.length];
            StyledText styledText = viewer.getTextWidget();
            int i = 0;
            while (i < selectionRanges.length) {
                origText[i] = selectionRanges[i][1] > 0 ? styledText.getText(selectionRanges[i][0], selectionRanges[i][0] + selectionRanges[i][1] - 1) : "";
                ++i;
            }
            String[] newText = this.formatText(origText);
            if (newText != null) {
                IUndoManager manager = viewer.getUndoManager();
                manager.beginCompoundChange();
                int i2 = 0;
                while (i2 < selectionRanges.length && i2 < newText.length) {
                    styledText.replaceTextRange(selectionRanges[i2][0], selectionRanges[i2][1], newText[i2]);
                    ++i2;
                }
                manager.endCompoundChange();
            }
        }
    }

    protected abstract String[] formatText(String[] var1);

    public void selectionChanged(IAction action, ISelection selection) {
        this.getSelectionRanges();
        action.setEnabled(this.viewer != null && this.selectionRanges != null);
    }

    private void getSelectionRanges() {
        VcobolEditor ed;
        this.viewer = this.editor != null ? (this.editor instanceof VcobolEditor ? ((VcobolEditor)this.editor).getViewer() : ((ed = (VcobolEditor)this.editor.getAdapter(VcobolEditor.class)) != null ? ed.getViewer() : null)) : null;
        if (this.viewer == null) {
            this.selectionRanges = null;
            return;
        }
        StyledText styledText = this.viewer.getTextWidget();
        if (styledText.getSelectionCount() > 0) {
            try {
                int[] sr = (int[])styledText.getClass().getMethod("getSelectionRanges", new Class[0]).invoke((Object)styledText, new Object[0]);
                this.selectionRanges = new int[sr.length / 2][2];
                int i = 0;
                int j = 0;
                while (i < sr.length) {
                    this.selectionRanges[j][0] = sr[i++];
                    this.selectionRanges[j][1] = sr[i++];
                    ++j;
                }
            }
            catch (Throwable ex) {
                Point sr = styledText.getSelectionRange();
                this.selectionRanges = new int[][]{{sr.x, sr.y}};
            }
        } else {
            this.viewer = null;
            this.selectionRanges = null;
        }
    }
}

