/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.actions;

import com.vcobol.plugins.editor.VcobolEditor;
import com.vcobol.plugins.editor.actions.VcobolThreadAction;
import com.vcobol.plugins.editor.debug.VcobolDebugTarget;
import com.veryant.debugger.protocol.Command;
import com.veryant.debugger.protocol.CommandJump;
import com.veryant.debugger.protocol.ResponseGetInfo;
import java.io.File;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;

public class JumpToSelectedLineAction
extends VcobolThreadAction
implements IEditorActionDelegate {
    public static final String ID = "com.vcobol.plugins.editor.actions.JumpToSelectedLineAction";
    private VcobolEditor editor;

    public JumpToSelectedLineAction(VcobolEditor editor) {
        super("jumpToSelLineAction.", 1);
        this.editor = editor;
    }

    public JumpToSelectedLineAction() {
        super("jumpToSelLineAction.", 1);
    }

    public void run() {
        if (VcobolDebugTarget.getDefault() != null && this.editor != null) {
            try {
                VcobolDebugTarget target = VcobolDebugTarget.getDefault();
                String fileName = this.editor.getEditorInput().getName();
                int fileIndex = 0;
                String progName = target.getName();
                ResponseGetInfo rgetinfo = target.getInfo(this.selectedThread.getName(), progName);
                List filenames = rgetinfo.getFileNames();
                int i = 0;
                ListIterator lit = filenames.listIterator();
                while (lit.hasNext()) {
                    String fn = (String)lit.next();
                    int idx = fn.lastIndexOf(File.separatorChar);
                    if (idx >= 0) {
                        fn = fn.substring(idx + 1);
                    }
                    if (fn.equals(fileName)) {
                        fileIndex = i;
                        break;
                    }
                    ++i;
                }
                ITextSelection tsel = (ITextSelection)this.editor.getViewer().getSelection();
                CommandJump cmd = new CommandJump(this.selectedThread.getName(), progName, tsel.getStartLine() + 1, fileIndex);
                target.putAsyncCommand((Command)cmd);
            }
            catch (DebugException debugException) {
                // empty catch block
            }
        }
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.editor = (VcobolEditor)targetEditor;
    }
}

