/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.actions;

import com.vcobol.plugins.editor.VcobolEditor;
import com.vcobol.plugins.editor.util.PluginUtilities;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;

/*
 * Exception performing whole class analysis ignored.
 */
public class ToggleCommentAction
extends Action
implements IEditorActionDelegate {
    private static final String eol = System.getProperty("line.separator", "\n");
    private VcobolEditor editor;

    public ToggleCommentAction() {
    }

    public ToggleCommentAction(String text, String toolTipText, ImageDescriptor image) {
        this.setText(text);
        this.setToolTipText(toolTipText);
        this.setImageDescriptor(image);
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.editor = (VcobolEditor)targetEditor;
    }

    public void run(IAction action) {
        this.run();
    }

    public void run() {
        if (this.editor == null) {
            return;
        }
        TextSelection ts = (TextSelection)this.editor.getSelectionProvider().getSelection();
        int startLine = -1;
        int endLine = -1;
        IDocument document = this.editor.getViewer().getDocument();
        if (ts != null && !ts.isEmpty()) {
            startLine = ts.getStartLine();
            endLine = ts.getEndLine();
        } else {
            IRegion hRange = this.editor.getHighlightRange();
            if (hRange != null && hRange.getLength() > 0) {
                try {
                    startLine = endLine = document.getLineOfOffset(hRange.getOffset());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
        if (startLine >= 0) {
            StringBuffer replaceText = new StringBuffer();
            String tabStr = ToggleCommentAction.getSpaces((int)this.editor.getConfiguration().getTabWidth(null));
            int i = startLine;
            while (i <= endLine) {
                try {
                    IRegion r = document.getLineInformation(i);
                    String lineText = document.get(r.getOffset(), r.getLength()).replaceAll("\t", tabStr);
                    switch (this.editor.getFormat()) {
                        case 3: {
                            String trimmedLineText = ToggleCommentAction.leftTrim((String)lineText);
                            if (trimmedLineText.startsWith("*>")) {
                                int idx = lineText.indexOf("*>");
                                replaceText.append(lineText.substring(0, idx));
                                replaceText.append(lineText.substring(idx + 2));
                                break;
                            }
                            replaceText.append("*>");
                            replaceText.append(lineText);
                            break;
                        }
                        case 2: {
                            if (lineText.startsWith("*>")) {
                                replaceText.append(lineText.substring(2));
                                break;
                            }
                            replaceText.append("*>");
                            replaceText.append(lineText);
                            break;
                        }
                        case 1: {
                            if (lineText.length() > 6 && lineText.charAt(6) == '*') {
                                replaceText.append(lineText.substring(0, 6));
                                replaceText.append(" ");
                                replaceText.append(lineText.substring(7));
                                break;
                            }
                            String trimmedLineText = ToggleCommentAction.leftTrim((String)lineText);
                            if (trimmedLineText.startsWith("*>") && lineText.length() - trimmedLineText.length() >= 6) {
                                int idx = lineText.indexOf("*>");
                                replaceText.append(lineText.substring(0, idx));
                                replaceText.append(lineText.substring(idx + 2));
                                break;
                            }
                            if (lineText.length() > 6) {
                                replaceText.append(lineText.substring(0, 6));
                                replaceText.append("*");
                                replaceText.append(lineText.substring(7));
                                break;
                            }
                            replaceText.append(lineText);
                            replaceText.append(ToggleCommentAction.getSpaces((int)(6 - lineText.length())));
                            replaceText.append("*");
                            break;
                        }
                        default: {
                            String trimmedLineText = ToggleCommentAction.leftTrim((String)lineText);
                            if (trimmedLineText.startsWith("*>") && lineText.length() - trimmedLineText.length() >= 6) {
                                int idx = lineText.indexOf("*>");
                                replaceText.append(lineText.substring(0, idx));
                                replaceText.append(lineText.substring(idx + 2));
                                break;
                            }
                            int idx = lineText.length() - trimmedLineText.length();
                            replaceText.append(lineText.substring(0, idx));
                            replaceText.append("*>");
                            replaceText.append(lineText.substring(idx));
                        }
                    }
                    replaceText.append(eol);
                }
                catch (BadLocationException ex) {
                    PluginUtilities.log((Throwable)ex);
                }
                ++i;
            }
            try {
                int startOffs = document.getLineOffset(startLine);
                int length = document.getLineOffset(endLine) + document.getLineLength(endLine) - startOffs;
                int caretOffs = this.editor.getViewer().getTextWidget().getCaretOffset();
                document.replace(startOffs, length, replaceText.toString());
                this.editor.redraw();
                this.editor.getViewer().getTextWidget().setCaretOffset(caretOffs);
            }
            catch (BadLocationException ex2) {
                PluginUtilities.log((Throwable)ex2);
            }
        }
    }

    private static String getSpaces(int len) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < len) {
            sb.append(' ');
            ++i;
        }
        return sb.toString();
    }

    private static String leftTrim(String s) {
        char[] chars = s.toCharArray();
        int i = 0;
        while (i < chars.length && (chars[i] == ' ' || chars[i] == '\t')) {
            ++i;
        }
        if (i == chars.length) {
            return s;
        }
        return new String(chars, i, chars.length - i);
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

