/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.debug;

import com.vcobol.plugins.editor.VcobolEditor;
import com.vcobol.plugins.editor.annotations.BreakpointAnnotation;
import com.vcobol.plugins.editor.debug.BreakpointMarker;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;

public class BreakpointMarker
implements IMarker {
    private Map attrs = new HashMap();
    private long creationTime;
    private String type;
    private IBreakpoint breakpoint;
    private VcobolEditor editor;
    private Annotation annotation;
    private static DummyResource dummy;

    public BreakpointMarker(String type) {
        this.type = type;
        this.creationTime = System.currentTimeMillis();
    }

    public void setEditor(VcobolEditor ised) {
        this.editor = ised;
        if (this.editor != null) {
            try {
                IAnnotationModel model = this.editor.getViewer().getAnnotationModel();
                if (model != null) {
                    Position pos = new Position(this.editor.getViewer().getDocument().getLineOffset(this.getAttribute("lineNumber", 1) - 1));
                    if (this.type.equals("com.vcobol.plugins.editor.VcobolEditor.VcobolBreakpointMarker")) {
                        this.annotation = new BreakpointAnnotation();
                    }
                    if (this.annotation != null) {
                        model.addAnnotation(this.annotation, pos);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void delete() throws CoreException {
        if (this.editor != null && this.annotation != null) {
            try {
                IAnnotationModel model = this.editor.getViewer().getAnnotationModel();
                if (model != null) {
                    model.removeAnnotation(this.annotation);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setBreakpoint(IBreakpoint bp) {
        this.breakpoint = bp;
    }

    public boolean exists() {
        return false;
    }

    public Object getAttribute(String attributeName) throws CoreException {
        return this.getAttribute(attributeName, null);
    }

    public int getAttribute(String attributeName, int defaultValue) {
        Integer Return = (Integer)this.attrs.get(attributeName);
        if (Return != null) {
            return Return;
        }
        return defaultValue;
    }

    public String getAttribute(String attributeName, String defaultValue) {
        String Return = (String)this.attrs.get(attributeName);
        if (Return != null) {
            return Return;
        }
        return defaultValue;
    }

    public boolean getAttribute(String attributeName, boolean defaultValue) {
        Boolean Return = (Boolean)this.attrs.get(attributeName);
        if (Return != null) {
            return Return;
        }
        return defaultValue;
    }

    public Map getAttributes() throws CoreException {
        return this.attrs;
    }

    public Object[] getAttributes(String[] attributeNames) throws CoreException {
        Object[] Return = new Object[attributeNames.length];
        int i = 0;
        while (i < Return.length) {
            Return[i] = this.attrs.get(attributeNames[i]);
            ++i;
        }
        return Return;
    }

    public long getCreationTime() throws CoreException {
        return this.creationTime;
    }

    public long getId() {
        try {
            return Long.parseLong(this.attrs.get("org.eclipse.debug.core.id").toString());
        }
        catch (Exception e) {
            return -1L;
        }
    }

    private DummyResource getDummy() {
        if (dummy == null) {
            dummy = new DummyResource(this, null);
        }
        return dummy;
    }

    public IResource getResource() {
        return this.getDummy();
    }

    public String getType() throws CoreException {
        return this.type;
    }

    public boolean isSubtypeOf(String superType) throws CoreException {
        return false;
    }

    private void put(String attributeName, Object value) {
        this.attrs.put(attributeName, value);
        this.fireBreakpointChanged();
    }

    private void fireBreakpointChanged() {
        if (this.breakpoint != null) {
            DebugPlugin.getDefault().getBreakpointManager().fireBreakpointChanged(this.breakpoint);
        }
    }

    public void setAttribute(String attributeName, int value) throws CoreException {
        this.put(attributeName, (Object)new Integer(value));
    }

    public void setAttribute(String attributeName, Object value) throws CoreException {
        this.put(attributeName, value);
    }

    public void setAttribute(String attributeName, boolean value) throws CoreException {
        this.put(attributeName, (Object)new Boolean(value));
    }

    public void setAttributes(Map attributes) throws CoreException {
        if (!attributes.isEmpty()) {
            this.attrs.putAll(attributes);
            this.fireBreakpointChanged();
        }
    }

    public void setAttributes(String[] attributeNames, Object[] values) throws CoreException {
        if (attributeNames.length > 0) {
            int i = 0;
            while (i < attributeNames.length && i < values.length) {
                this.attrs.put(attributeNames[i], values[i]);
                ++i;
            }
            this.fireBreakpointChanged();
        }
    }

    public Object getAdapter(Class adapter) {
        return null;
    }
}

