/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.debug;

import com.vcobol.plugins.editor.debug.VcobolDebugTarget;
import com.vcobol.plugins.editor.debug.VcobolThread;
import com.vcobol.plugins.editor.debug.util.TokenManager;
import com.vcobol.plugins.editor.debug.util.VarName;
import com.vcobol.plugins.editor.util.PluginUtilities;
import com.veryant.debugger.protocol.Command;
import com.veryant.debugger.protocol.CommandDisplay;
import com.veryant.debugger.protocol.ResponseDisplay;
import com.veryant.debugger.protocol.VariableIdentifier;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Point;

public class DisplayVariableTextHover
implements ITextHover {
    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        block6: {
            if (hoverRegion != null) {
                try {
                    VcobolThread th;
                    if (VcobolDebugTarget.getDefault() == null || (th = VcobolDebugTarget.getSelectedThread()) == null || !th.isSuspended()) break block6;
                    IRegion lineInfo = textViewer.getDocument().getLineInformationOfOffset(hoverRegion.getOffset());
                    int lineRelativeOffset = hoverRegion.getOffset() - lineInfo.getOffset();
                    String line = textViewer.getDocument().get(lineInfo.getOffset(), lineInfo.getLength());
                    String word = PluginUtilities.findVariableName((String)line, (int)lineRelativeOffset, (boolean)true);
                    if (word == null || word.length() <= 0) break block6;
                    VariableIdentifier vId = null;
                    TokenManager tm = new TokenManager(word);
                    try {
                        VarName vn = new VarName(tm);
                        vId = VcobolDebugTarget.varNameToVariableIdentifier((VarName)vn);
                        ResponseDisplay rd = (ResponseDisplay)VcobolDebugTarget.getDefault().putSyncCommand((Command)new CommandDisplay(th.getName(), th.getProgName(), vId, false, false));
                        if (rd != null && rd.getReturnCode() == 0) {
                            return "______STANDARD_CONTENT_TYPE" + word + " = " + rd.getStringValue();
                        }
                    }
                    catch (Exception exception) {}
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        Point selection = textViewer.getSelectedRange();
        if (selection.x <= offset && offset < selection.x + selection.y) {
            return new Region(selection.x, selection.y);
        }
        return new Region(offset, 0);
    }
}

