/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.debug;

import com.iscobol.compiler.PreProcessor;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.vcobol.plugins.editor.VcobolEditor;
import com.vcobol.plugins.editor.VcobolEditorPlugin;
import com.vcobol.plugins.editor.VresourceBundle;
import com.vcobol.plugins.editor.debug.VcobolBreakpoint;
import com.vcobol.plugins.editor.debug.VcobolDebugElement;
import com.vcobol.plugins.editor.debug.VcobolDebugTarget;
import com.vcobol.plugins.editor.debug.VcobolStackFrame;
import com.vcobol.plugins.editor.debug.VcobolThread;
import com.vcobol.plugins.editor.debug.VcobolVariable;
import com.vcobol.plugins.editor.debug.VcobolWatchpoint;
import com.vcobol.plugins.editor.debug.util.DebuggerParseException;
import com.vcobol.plugins.editor.debug.util.Expression;
import com.vcobol.plugins.editor.debug.util.TokenManager;
import com.vcobol.plugins.editor.debug.util.TreeElementDisplayEx;
import com.vcobol.plugins.editor.debug.util.VarName;
import com.vcobol.plugins.editor.util.PluginUtilities;
import com.veryant.commons.editor.util.IsFragment;
import com.veryant.debugger.protocol.Command;
import com.veryant.debugger.protocol.CommandClearBreakPoint;
import com.veryant.debugger.protocol.CommandClearMonitor;
import com.veryant.debugger.protocol.CommandConnect;
import com.veryant.debugger.protocol.CommandDisplay;
import com.veryant.debugger.protocol.CommandGetInfo;
import com.veryant.debugger.protocol.CommandGetThreads;
import com.veryant.debugger.protocol.CommandSetBreakPoint;
import com.veryant.debugger.protocol.CommandSetMonitor;
import com.veryant.debugger.protocol.DebuggableThread;
import com.veryant.debugger.protocol.Monitor;
import com.veryant.debugger.protocol.NumericConstant;
import com.veryant.debugger.protocol.NumericOperation;
import com.veryant.debugger.protocol.NumericOperator;
import com.veryant.debugger.protocol.Operand;
import com.veryant.debugger.protocol.Position;
import com.veryant.debugger.protocol.Response;
import com.veryant.debugger.protocol.ResponseDisplay;
import com.veryant.debugger.protocol.ResponseGetInfo;
import com.veryant.debugger.protocol.ResponseListMonitors;
import com.veryant.debugger.protocol.ResponseSetMonitor;
import com.veryant.debugger.protocol.VariableIdentifier;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.NotSerializableException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.sourcelookup.ISourceLookupResult;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleView;

/*
 * Exception performing whole class analysis ignored.
 */
public class VcobolDebugTarget
extends VcobolDebugElement
implements IDebugTarget,
IDebugElement,
IDisconnect {
    private static final int PROGRAM_FINISHED_RESPONSE_ID = 103;
    private static final int QUIT_COMMAND_ID = 21;
    public static final String ATTR_SKIP_EVENT = "SKIP_EVENT";
    public static final String VBREAKPOINT_MARKER_TYPE = "com.vcobol.plugins.editor.VcobolEditor.VcobolBreakpointMarker";
    public static final String VWATCHPOINT_MARKER_TYPE = "com.vcobol.plugins.editor.VcobolEditor.VcobolWatchpointMarker";
    private EventDispatchJob job;
    private static final Command quitCommand = new /* Unavailable Anonymous Inner Class!! */;
    private static final Response programFinishedResponse = new /* Unavailable Anonymous Inner Class!! */;
    private static final int MAX_ATTEMPTS = 10;
    private static final int TIMEOUT = 500;
    private String name;
    private IProcess process;
    private IProject project;
    private int port;
    private String host;
    private Socket socket;
    private DataOutputStream socketOutputStream;
    private OutputThread socketOutputThread;
    private Hashtable<String, VcobolThread> threads = new Hashtable();
    private Hashtable<String, ResponseGetInfo> getInfos = new Hashtable();
    private boolean disconnected = true;
    private static VcobolDebugTarget instance;

    public VcobolDebugTarget(String name, IProject project, IProcess process, String host, int port, ILaunch launch) {
        super(null, launch);
        this.name = name;
        this.project = project;
        this.process = process;
        this.launch = launch;
        this.host = host;
        this.port = port;
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void showVCobolConsole() {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewReference[] viewRefs = activePage.getViewReferences();
        boolean found = false;
        int i = 0;
        while (i < viewRefs.length && !found) {
            IConsoleView consoleView;
            if (viewRefs[i].getId().equals("org.eclipse.ui.console.ConsoleView") && (consoleView = (IConsoleView)viewRefs[i].getView(false)) != null && consoleView.getConsole() == VcobolEditorPlugin.getDefault().getConsole()) {
                found = true;
            }
            ++i;
        }
        if (!found) {
            try {
                activePage.showView("org.eclipse.ui.console.ConsoleView", "vcobolIOConsoleView", 3);
                ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)VcobolEditorPlugin.getDefault().getConsole());
            }
            catch (PartInitException partInitException) {
                // empty catch block
            }
        }
    }

    public static VariableIdentifier varNameToVariableIdentifier(VarName vn) {
        return (VariableIdentifier)VcobolDebugTarget.convertVarName((VarName)vn);
    }

    public static VariableIdentifier varNameToVariableIdentifier(String vn) throws DebuggerParseException {
        return (VariableIdentifier)VcobolDebugTarget.convertVarName((VarName)new VarName(new TokenManager(vn)));
    }

    private static Operand convertVarName(VarName vn) {
        ArrayList<Operand> subscripts = new ArrayList<Operand>();
        Operand subvalue0 = null;
        Operand subvalue1 = null;
        String ofName = vn.getName();
        if (vn.hasAncestor() && vn.getNAncestors() > 0) {
            Enumeration eOf = vn.getAncestors();
            while (eOf.hasMoreElements()) {
                ofName = String.valueOf(ofName) + " OF " + eOf.nextElement().toString();
            }
        }
        if (vn.hasSubscript()) {
            Enumeration en = vn.getSubscripts();
            Object elem = null;
            Operand op = null;
            while (en.hasMoreElements()) {
                elem = en.nextElement();
                op = VcobolDebugTarget.convertExpressionTOOperand((Expression)elem);
                if (op == null) continue;
                subscripts.add(op);
            }
        }
        if (vn.hasSubvalue()) {
            subvalue0 = VcobolDebugTarget.convertExpressionTOOperand((Expression)vn.getLeftPos());
            subvalue1 = VcobolDebugTarget.convertExpressionTOOperand((Expression)vn.getSubLen());
        }
        VariableIdentifier Return = new VariableIdentifier(ofName, vn.getFullName(), subscripts, subvalue0, subvalue1);
        return Return;
    }

    private static Operand convertExpressionTOOperand(Expression exp) {
        NumericConstant Return = null;
        Enumeration e = exp.getElements();
        NumericConstant op1 = null;
        NumericOperator nop = null;
        NumericConstant op2 = null;
        NumericOperation no = null;
        while (e.hasMoreElements()) {
            Object elem = e.nextElement();
            if (elem instanceof BigDecimal) {
                BigDecimal cn = (BigDecimal)elem;
                Return = op1 == null ? (op1 = new NumericConstant(cn.toString())) : (op2 = new NumericConstant(cn.toString()));
                if (nop == null) continue;
                no = new NumericOperation((Operand)op1, nop, (Operand)op2);
                op2 = null;
                nop = null;
                op1 = no;
                Return = no;
                continue;
            }
            if (elem instanceof Expression.Op) {
                Expression.Op isop = (Expression.Op)elem;
                String sop = "";
                switch (isop.getType()) {
                    case 0: {
                        sop = "+";
                        break;
                    }
                    case 1: {
                        sop = "-";
                        break;
                    }
                    case 2: {
                        sop = ":";
                        break;
                    }
                    case 3: {
                        sop = "*";
                    }
                }
                nop = new NumericOperator(sop);
                continue;
            }
            if (elem instanceof VarName) {
                Return = op1 == null ? (op1 = VcobolDebugTarget.convertVarName((VarName)((VarName)elem))) : (op2 = VcobolDebugTarget.convertVarName((VarName)((VarName)elem)));
                if (nop == null) continue;
                no = new NumericOperation((Operand)op1, nop, (Operand)op2);
                op2 = null;
                nop = null;
                op1 = no;
                Return = no;
                continue;
            }
            if (!(elem instanceof Expression)) continue;
            Return = op1 == null ? (op1 = VcobolDebugTarget.convertExpressionTOOperand((Expression)((Expression)elem))) : (op2 = VcobolDebugTarget.convertExpressionTOOperand((Expression)((Expression)elem)));
            if (nop == null) continue;
            no = new NumericOperation((Operand)op1, nop, (Operand)op2);
            op2 = null;
            nop = null;
            op1 = no;
            Return = no;
        }
        return Return;
    }

    private void connect() {
        int i = 0;
        while (i < 10) {
            try {
                this.socket = new Socket(this.host, this.port);
                InputStream in = this.socket.getInputStream();
                OutputStream out = this.socket.getOutputStream();
                this.socketOutputThread = new OutputThread(this, new DataInputStream(in));
                this.socketOutputStream = new DataOutputStream(out);
                break;
            }
            catch (IOException ex) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++i;
            }
        }
        if (this.socket == null) {
            PluginUtilities.logError((String)(String.valueOf(VresourceBundle.getString((String)"conn_refused_msg")) + " " + this.port));
            instance = null;
        } else {
            this.writeCommand((Command)new CommandConnect(), this.socketOutputStream);
        }
    }

    private void start() {
        instance = this;
        this.connect();
    }

    public static final VcobolDebugTarget getDefault() {
        return instance;
    }

    public ResponseGetInfo getInfo(String threadName, String programName) {
        ResponseGetInfo Return = (ResponseGetInfo)this.getInfos.get(programName);
        if (Return == null) {
            Return = (ResponseGetInfo)this.putSyncCommand((Command)new CommandGetInfo(threadName, programName));
            this.getInfos.put(programName, Return);
        }
        return Return;
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public IProcess getProcess() {
        return this.process;
    }

    public void refreshVariableView() {
        this.refreshDebugView("org.eclipse.debug.ui.VariableView");
    }

    public void refreshBreakpointView() {
        this.refreshDebugView("org.eclipse.debug.ui.BreakpointView");
    }

    public void refreshDebugView(String id) {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void removeVariable(VcobolVariable v) {
        v.getThread().removeVariable(v);
        this.refreshVariableView();
    }

    public void removeAllVariables() {
        for (VcobolThread vth : this.threads.values()) {
            vth.removeAllVariables();
        }
        this.refreshVariableView();
    }

    public IThread[] getThreads() throws DebugException {
        IThread[] Return = new IThread[this.threads.size()];
        this.threads.values().toArray(Return);
        return Return;
    }

    public boolean hasThreads() throws DebugException {
        if (this.getProcess() != null) {
            return !this.getProcess().isTerminated() && !this.threads.isEmpty();
        }
        return !this.isDisconnected() && !this.threads.isEmpty();
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return true;
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public boolean canTerminate() {
        if (this.getProcess() != null) {
            return this.getProcess().canTerminate();
        }
        return false;
    }

    public boolean isTerminated() {
        if (this.getProcess() != null) {
            return this.getProcess().isTerminated();
        }
        return false;
    }

    public void terminate() throws DebugException {
        this.terminated();
    }

    private static AbstractDebugView findDebugView() {
        IWorkbenchPage[] pages = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPages();
        int i = 0;
        while (i < pages.length) {
            AbstractDebugView part = (AbstractDebugView)pages[i].findView("org.eclipse.debug.ui.DebugView");
            if (part != null) {
                return part;
            }
            ++i;
        }
        return null;
    }

    public static VcobolThread getSelectedThread() {
        VcobolThread[] Return = new VcobolThread[1];
        new /* Unavailable Anonymous Inner Class!! */.start();
        return Return[0];
    }

    private void terminated() {
        this.disconnected = true;
        this.fireTerminateEvent();
        this.job.mycancel();
        this.job = null;
        instance = null;
        try {
            this.removeTerminatedThreads(new DebuggableThread[0]);
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("VcobolDebugModel");
        int i22 = 0;
        while (i22 < breakpoints.length) {
            if (breakpoints[i22] instanceof VcobolWatchpoint) {
                ((VcobolWatchpoint)breakpoints[i22]).setValue(null);
            }
            ++i22;
        }
        this.resetCurrentLine();
        try {
            if (this.getProcess() != null) {
                this.getProcess().terminate();
            } else if (this.getLaunch() instanceof Launch) {
                ((Launch)this.getLaunch()).disconnect();
            }
        }
        catch (DebugException i22) {
            // empty catch block
        }
        try {
            this.socket.close();
            this.socketOutputThread.stop();
            this.socketOutputStream.close();
        }
        catch (IOException i22) {
            // empty catch block
        }
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
        IPreferenceStore store = VcobolEditorPlugin.getDefault().getPreferenceStore();
        int switchVPerspOpt = store.contains("vcobol.switchback.ispersp") ? store.getInt("vcobol.switchback.ispersp") : store.getDefaultInt("vcobol.switchback.ispersp");
        boolean[] switchVPersp = new boolean[1];
        if (switchVPerspOpt == 2) {
            Display.getDefault().syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        } else if (switchVPerspOpt == 0) {
            switchVPersp[0] = true;
        }
        if (switchVPersp[0]) {
            Display.getDefault().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void reloadClasses(String[] classNames) {
    }

    public boolean canResume() {
        for (VcobolThread th : this.threads.values()) {
            if (!th.canResume()) continue;
            return true;
        }
        return false;
    }

    public boolean canSuspend() {
        for (VcobolThread th : this.threads.values()) {
            if (!th.canSuspend()) continue;
            return true;
        }
        return false;
    }

    public boolean isSuspended() {
        for (VcobolThread th : this.threads.values()) {
            if (th.isSuspended()) continue;
            return false;
        }
        return true;
    }

    public void resume() throws DebugException {
        for (VcobolThread th : this.threads.values()) {
            if (!th.canResume()) continue;
            th.resume();
        }
    }

    public void suspend() throws DebugException {
        for (VcobolThread th : this.threads.values()) {
            if (!th.canSuspend()) continue;
            th.suspend();
        }
    }

    public void putAsyncCommand(Command cmd) {
        if (this.job != null) {
            this.job.setAsyncCommand(cmd);
        }
    }

    public Response putSyncCommand(Command cmd) {
        if (this.job != null) {
            return this.job.setSyncCommand(cmd);
        }
        return null;
    }

    private void installDeferredBreakpoints() {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("VcobolDebugModel");
        int i = 0;
        while (i < breakpoints.length) {
            if (breakpoints[i] instanceof VcobolBreakpoint) {
                this.installDeferredBreakpoint((VcobolBreakpoint)breakpoints[i]);
            }
            ++i;
        }
    }

    private void installDeferredWatchpoints(VcobolThread selectedThread) {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("VcobolDebugModel");
        ResponseSetMonitor resp = null;
        int i = 0;
        while (i < breakpoints.length) {
            ResponseSetMonitor tmp;
            if (breakpoints[i] instanceof VcobolWatchpoint && (tmp = this.installDeferredWatchpoint((VcobolWatchpoint)breakpoints[i], selectedThread)) != null) {
                resp = tmp;
            }
            ++i;
        }
        if (resp != null) {
            this.refreshMonitors(resp);
        }
    }

    private void installDeferredBreakpoint(VcobolBreakpoint breakpoint) {
        try {
            this.putSyncCommand((Command)this.makeBreakpointCommand(breakpoint));
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private ResponseSetMonitor installDeferredWatchpoint(VcobolWatchpoint watchpoint, VcobolThread selectedThread) {
        try {
            return (ResponseSetMonitor)this.putSyncCommand((Command)this.makeWatchpointCommand(watchpoint, selectedThread));
        }
        catch (CoreException e) {
            return null;
        }
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        try {
            if (breakpoint.getMarker().getAttribute("SKIP_EVENT", false)) {
                return;
            }
            if (breakpoint instanceof VcobolBreakpoint) {
                CommandSetBreakPoint cmd = this.makeBreakpointCommand((VcobolBreakpoint)breakpoint);
                if (this.job != null) {
                    this.putSyncCommand((Command)cmd);
                }
            } else if (breakpoint instanceof VcobolWatchpoint) {
                CommandSetMonitor cmd = this.makeWatchpointCommand((VcobolWatchpoint)breakpoint, VcobolDebugTarget.getSelectedThread());
                if (this.job != null) {
                    this.putSyncCommand((Command)cmd);
                }
            }
        }
        catch (CoreException ex) {
            PluginUtilities.log((Throwable)ex);
        }
    }

    private CommandSetBreakPoint makeBreakpointCommand(VcobolBreakpoint lbp) throws CoreException {
        CommandSetBreakPoint Return = new CommandSetBreakPoint(VcobolDebugTarget.buildClassName((String)lbp.getFilename()), 0, lbp.getLineNumber(), lbp.getFilename(), lbp.isEnabled());
        return Return;
    }

    private CommandSetMonitor makeWatchpointCommand(VcobolWatchpoint wp, VcobolThread th) throws CoreException {
        TokenManager tm = new TokenManager(wp.getVariableName());
        CommandSetMonitor Return = null;
        try {
            VarName vn = new VarName(tm);
            VariableIdentifier vId = VcobolDebugTarget.varNameToVariableIdentifier((VarName)vn);
            Return = new CommandSetMonitor(th.getName(), th.getProgName(), null, vId, 0, null, wp.isHexadecimal(), wp.isEnabled());
        }
        catch (DebuggerParseException e) {
            e.printStackTrace();
        }
        return Return;
    }

    private static String buildClassName(String filename) {
        int idx = filename.lastIndexOf(46);
        if (idx >= 0) {
            filename = filename.substring(0, idx);
        }
        return filename.replace('-', '_').toUpperCase();
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.breakpointAdded(breakpoint);
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (breakpoint.getMarker().getAttribute("SKIP_EVENT", false)) {
            return;
        }
        if (breakpoint instanceof VcobolBreakpoint) {
            this.removeBreakpoint((VcobolBreakpoint)breakpoint);
        } else if (breakpoint instanceof VcobolWatchpoint) {
            this.removeWatchpoint((VcobolWatchpoint)breakpoint);
        }
    }

    private void removeBreakpoint(VcobolBreakpoint lbp) {
        if (this.job != null) {
            this.putSyncCommand((Command)new CommandClearBreakPoint(VcobolDebugTarget.buildClassName((String)lbp.getFilename()), 0, lbp.getLineNumber()));
        }
    }

    private void removeWatchpoint(VcobolWatchpoint wp) {
        if (this.job != null) {
            VcobolThread th = VcobolDebugTarget.getSelectedThread();
            TokenManager tm = new TokenManager(wp.getVariableName());
            try {
                VarName vn = new VarName(tm);
                VariableIdentifier vId = VcobolDebugTarget.varNameToVariableIdentifier((VarName)vn);
                this.putSyncCommand((Command)new CommandClearMonitor(th.getName(), th.getProgName(), null, vId));
            }
            catch (DebuggerParseException debuggerParseException) {
            }
            catch (DebugException debugException) {
                // empty catch block
            }
        }
    }

    public boolean canDisconnect() {
        return !this.disconnected;
    }

    public void disconnect() throws DebugException {
        if (!this.isDisconnected()) {
            this.terminate();
        }
    }

    public boolean isDisconnected() {
        return this.disconnected;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        throw new DebugException((IStatus)new Status(4, "com.vcobol.plugins.editor.VcobolEditor", 5011, VresourceBundle.getString((String)"op_not_supported_msg"), null));
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    void refreshMonitors(ResponseListMonitors resp) {
        String progName = PluginUtilities.getVcobolClassName((String)resp.getCurrentPosition().getProgramName());
        String changedMonitor = null;
        for (Object o : resp.getMonitors()) {
            Monitor mon = (Monitor)o;
            if (changedMonitor == null && mon.isChanged()) {
                changedMonitor = mon.getVariableIdentifier().getFullName();
            }
            IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("VcobolDebugModel");
            int i = 0;
            while (i < breakpoints.length) {
                VcobolWatchpoint wp;
                if (breakpoints[i] instanceof VcobolWatchpoint && (wp = (VcobolWatchpoint)breakpoints[i]).getVariableName().equalsIgnoreCase(mon.getVariableIdentifier().getFullName()) && wp.getClassName().equalsIgnoreCase(progName)) {
                    wp.setValue(mon.getStringValue());
                }
                ++i;
            }
        }
        if (changedMonitor != null) {
            PluginUtilities.logMessage((String)(String.valueOf(VresourceBundle.getString((String)"change_var_msg")) + " " + changedMonitor), (int)2);
        }
        this.refreshBreakpointView();
    }

    public void refreshVariables() {
        boolean asHex = VcobolEditorPlugin.getDefault().getPreferenceStore().getBoolean("vcobol.variableview.showhex");
        for (VcobolThread th : this.threads.values()) {
            if (!th.isSuspended()) continue;
            th.refreshVariables(asHex);
        }
        this.refreshVariableView();
    }

    private void handleResponse(Response resp) {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void handleResponse0(Response resp) {
        int rc = resp.getReturnCode();
        int msgId = resp.getId();
        switch (msgId) {
            case 6: {
                if (rc == 0) {
                    DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
                    this.job = new EventDispatchJob(this);
                    this.job.schedule();
                    this.job.setAsyncCommand((Command)new CommandGetThreads(true));
                    break;
                }
                if (this.job == null) break;
                this.terminated();
                break;
            }
            case 8: {
                if (rc == 0) {
                    List list = resp.getServerStatus().getDebuggableThreads();
                    DebuggableThread[] dtds = new DebuggableThread[list.size()];
                    list.toArray(dtds);
                    try {
                        this.addNewThreads(dtds);
                        this.initThreads(dtds);
                    }
                    catch (DebugException debugException) {
                        // empty catch block
                    }
                    if (this.getProcess() == null) {
                        this.disconnected = false;
                        Display.getDefault().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                    }
                    VcobolThread firstPausedThread = null;
                    boolean openEditor = true;
                    int i = 0;
                    while (i < dtds.length) {
                        if (dtds[i].getState() == 1) {
                            ResponseGetInfo respGetInfo = this.getInfo(dtds[i].getName(), dtds[i].getProgramName());
                            list = respGetInfo.getPositionStack();
                            Position[] positionStack = new Position[list.size()];
                            list.toArray(positionStack);
                            VcobolThread th = (VcobolThread)this.threads.get(dtds[i].getName());
                            th.setPositionStacks(positionStack);
                            th.fireSuspendEvent(16);
                            if (firstPausedThread == null) {
                                firstPausedThread = th;
                            }
                            if (openEditor) {
                                Position currPosition = respGetInfo.getCurrentPosition();
                                ISourceLookupResult result = null;
                                VcobolStackFrame sf = new VcobolStackFrame(currPosition, th, (IDebugTarget)this, this.getLaunch());
                                result = DebugUITools.lookupSource((Object)sf, (ISourceLocator)this.getLaunch().getSourceLocator());
                                if (result != null) {
                                    VcobolDebugTarget.openEditor((IEditorInput)result.getEditorInput());
                                    openEditor = false;
                                }
                            }
                        }
                        ++i;
                    }
                    this.installDeferredBreakpoints();
                    this.installDeferredWatchpoints(firstPausedThread);
                    break;
                }
                if (this.job == null) break;
                this.terminated();
                break;
            }
            case 10: {
                break;
            }
            case 4: 
            case 12: 
            case 14: 
            case 16: 
            case 22: 
            case 35: 
            case 39: {
                if (msgId == 39) {
                    if (rc == -10) {
                        PluginUtilities.logMessage((String)"Warning: cannot jump to a line inside a block", (int)8);
                        rc = 0;
                    } else {
                        if (rc == -9) {
                            PluginUtilities.logError((String)"JUMP command not allowed from the 'program-id' location.");
                            break;
                        }
                        if (rc == -1) {
                            PluginUtilities.logError((String)"JUMP command not supported for this program. Please recompile with -dx option");
                            break;
                        }
                        if (rc == -3) {
                            PluginUtilities.logError((String)"Invalid line");
                            break;
                        }
                    }
                }
                if (rc == 0) {
                    ResponseListMonitors respListMonitors = (ResponseListMonitors)resp;
                    List list = respListMonitors.getServerStatus().getDebuggableThreads();
                    DebuggableThread[] dtds = new DebuggableThread[list.size()];
                    list.toArray(dtds);
                    try {
                        this.removeTerminatedThreads(dtds);
                        this.addNewThreads(dtds);
                        this.initThreads(dtds);
                        int i = 0;
                        while (i < dtds.length) {
                            if (dtds[i].getState() == 1) {
                                list = respListMonitors.getPositionStack();
                                Position[] positionStack = new Position[list.size()];
                                list.toArray(positionStack);
                                ((VcobolThread)this.threads.get(dtds[i].getName())).setPositionStacks(positionStack);
                            }
                            ++i;
                        }
                    }
                    catch (DebugException debugException) {
                        // empty catch block
                    }
                    ((VcobolThread)this.threads.get(respListMonitors.getThreadName())).fireSuspendEvent(8);
                    this.refreshVariables();
                    this.refreshMonitors(respListMonitors);
                    break;
                }
                PluginUtilities.logError((String)"Operation Unavailable");
                break;
            }
            case 2: {
                break;
            }
            case 20: {
                break;
            }
        }
    }

    public static String getHexString(byte[] value) {
        if (value == null) {
            return "";
        }
        StringBuffer Return = new StringBuffer();
        int i = 0;
        while (i < value.length) {
            Return.append(Integer.toHexString(value[i] >>> 4).toUpperCase());
            Return.append(Integer.toHexString(value[i] & 0xF).toUpperCase());
            ++i;
        }
        return Return.toString();
    }

    public void handleResponseDisplay(Response resp) {
        if (!(resp instanceof ResponseDisplay)) {
            PluginUtilities.logError((String)VresourceBundle.getString((String)"operation_unavailable2_msg"));
            return;
        }
        ResponseDisplay respDisplay = (ResponseDisplay)resp;
        switch (resp.getReturnCode()) {
            case 0: {
                respDisplay = (ResponseDisplay)resp;
                VcobolThread thread = (VcobolThread)this.threads.get(respDisplay.getThreadName());
                String strValue = respDisplay.isHex() ? VcobolDebugTarget.getHexString((byte[])respDisplay.getByteValue()) : respDisplay.getStringValue();
                VcobolVariable var = new VcobolVariable(respDisplay.getVariableIdentifier(), new TreeElementDisplayEx(respDisplay.getTreeValues()), strValue, respDisplay.isHex(), null, thread, (IDebugTarget)this, this.launch);
                thread.addVariable(var);
                this.refreshVariableView();
                break;
            }
            case -7: 
            case -6: 
            case -5: 
            case -4: {
                this.manageError(resp.getReturnCode());
            }
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public void manageError(int returnCode) {
        switch (returnCode) {
            case -4: {
                PluginUtilities.logError((String)VresourceBundle.getString((String)"var_could_not_be_access_msg"));
                break;
            }
            case -5: {
                PluginUtilities.logError((String)VresourceBundle.getString((String)"var_ambiguous_msg"));
                break;
            }
            case -6: {
                PluginUtilities.logError((String)VresourceBundle.getString((String)"var_unknown_msg"));
                break;
            }
            case -7: {
                PluginUtilities.logError((String)VresourceBundle.getString((String)"var_unavailable_msg"));
            }
        }
    }

    private static VcobolEditor openEditor(IEditorInput input) {
        VcobolEditor[] ret = new VcobolEditor[1];
        new /* Unavailable Anonymous Inner Class!! */.start();
        return ret[0];
    }

    void removeTerminatedThreads(DebuggableThread[] to) throws DebugException {
        Vector<VcobolThread> v = new Vector<VcobolThread>();
        for (VcobolThread vth : this.threads.values()) {
            boolean found = false;
            int j = 0;
            while (j < to.length) {
                if (vth.getName().equals(to[j].getName())) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (found) continue;
            v.addElement(vth);
            this.threads.remove(vth.getName());
        }
        int n = v.size();
        int i = 0;
        while (i < n) {
            ((VcobolThread)v.elementAt(i)).fireTerminateEvent();
            ++i;
        }
    }

    void addNewThreads(DebuggableThread[] dtds) throws DebugException {
        Vector<VcobolThread> v = new Vector<VcobolThread>();
        int i = 0;
        while (i < dtds.length) {
            if (this.threads.get(dtds[i].getName()) == null) {
                VcobolThread newThread = new VcobolThread((IDebugTarget)this, this.getLaunch());
                v.addElement(newThread);
                this.threads.put(dtds[i].getName(), newThread);
            }
            ++i;
        }
        int n = v.size();
        int i2 = 0;
        while (i2 < n) {
            ((VcobolThread)v.elementAt(i2)).fireCreationEvent();
            ++i2;
        }
    }

    void initThreads(DebuggableThread[] dtds) throws DebugException {
        int i = 0;
        while (i < dtds.length) {
            ((VcobolThread)this.threads.get(dtds[i].getName())).init(dtds[i]);
            ++i;
        }
    }

    private void resetCurrentLine() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public static void toggleLineBreakpoints(VcobolEditor editor, TextSelection selection) throws CoreException {
        VcobolDebugTarget.toggleLineBreakpoints((VcobolEditor)editor, (int)selection.getStartLine());
    }

    public static void toggleWatchpoints(VcobolEditor editor, String selection) throws CoreException {
        if (editor != null) {
            IsFragment fr;
            IStorage storage = (IStorage)editor.getEditorInput().getAdapter(IResource.class);
            if (storage == null) {
                storage = (IStorage)editor.getEditorInput().getAdapter(IStorage.class);
            }
            if ((fr = editor.findSelectedFragment(selection)) != null && fr.getType() == 13) {
                int lineNumber = fr.getStartLine();
                IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("VcobolDebugModel");
                int i = 0;
                while (i < breakpoints.length) {
                    if (breakpoints[i] instanceof VcobolWatchpoint && ((VcobolWatchpoint)breakpoints[i]).equals(storage, selection)) {
                        breakpoints[i].delete();
                        return;
                    }
                    ++i;
                }
                VcobolWatchpoint watchpoint = new VcobolWatchpoint(selection, storage, lineNumber + 1, editor);
                DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)watchpoint);
            }
        }
    }

    public static void toggleLineBreakpoints(VcobolEditor editor, int lineNumber) throws CoreException {
        if (editor != null) {
            IStorage storage = (IStorage)editor.getEditorInput().getAdapter(IResource.class);
            if (storage == null) {
                storage = (IStorage)editor.getEditorInput().getAdapter(IStorage.class);
            }
            IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("VcobolDebugModel");
            int i = 0;
            while (i < breakpoints.length) {
                if (breakpoints[i] instanceof VcobolBreakpoint && ((VcobolBreakpoint)breakpoints[i]).equals(storage, lineNumber + 1)) {
                    breakpoints[i].delete();
                    return;
                }
                ++i;
            }
            VcobolBreakpoint lineBreakpoint = new VcobolBreakpoint(storage, lineNumber + 1, editor);
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)lineBreakpoint);
        }
    }

    public static boolean canToggleLineBreakpoints(VcobolEditor editor, TextSelection selection) {
        if (editor != null) {
            int startLine = selection.getStartLine();
            IDocument doc = editor.getViewer().getDocument();
            String text = null;
            try {
                text = doc.get(doc.getLineOffset(startLine), doc.getLineLength(startLine));
            }
            catch (BadLocationException ex) {
                return false;
            }
            return VcobolDebugTarget.canToggleLineBreakpoints((String)text);
        }
        return false;
    }

    public void writeCommand(Command cmd, DataOutputStream dos) {
        try {
            cmd.writeMessage(dos);
        }
        catch (NotSerializableException e) {
            e.printStackTrace();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean canToggleWatchpoints(TextSelection selection) {
        return VcobolDebugTarget.canToggleWatchpoints((String)selection.getText());
    }

    public static boolean canToggleWatchpoints(String selection) {
        VcobolThread th;
        if (VcobolDebugTarget.getDefault() != null && (th = VcobolDebugTarget.getSelectedThread()) != null && th.isSuspended() && selection != null && selection.length() > 0) {
            VariableIdentifier vId = null;
            TokenManager tm = new TokenManager(selection);
            try {
                VarName vn = new VarName(tm);
                vId = VcobolDebugTarget.varNameToVariableIdentifier((VarName)vn);
                ResponseDisplay rd = (ResponseDisplay)VcobolDebugTarget.getDefault().putSyncCommand((Command)new CommandDisplay(th.getName(), th.getProgName(), vId, false, false));
                return rd != null && rd.getReturnCode() == 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static VcobolWatchpoint findWatchpoint(VcobolEditor editor, String name) throws CoreException {
        if (editor != null) {
            IStorage storage = (IStorage)editor.getEditorInput().getAdapter(IResource.class);
            if (storage == null) {
                storage = (IStorage)editor.getEditorInput().getAdapter(IStorage.class);
            }
            IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("VcobolDebugModel");
            int i = 0;
            while (i < breakpoints.length) {
                if (breakpoints[i] instanceof VcobolWatchpoint && ((VcobolWatchpoint)breakpoints[i]).equals(storage, name)) {
                    return (VcobolWatchpoint)breakpoints[i];
                }
                ++i;
            }
        }
        return null;
    }

    public static boolean canToggleLineBreakpoints(IFile file, int lineNumber) {
        InputStream is = null;
        try {
            is = file.getContents();
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(is));
            String line = reader.readLine();
            while (line != null) {
                if (reader.getLineNumber() == lineNumber) {
                    boolean bl = VcobolDebugTarget.canToggleLineBreakpoints((String)line);
                    return bl;
                }
                try {
                    line = reader.readLine();
                    continue;
                }
                catch (Exception exception) {}
                break;
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    public static boolean canToggleLineBreakpoints(String text) {
        if (text == null || text.length() == 0) {
            return false;
        }
        boolean foundStmt = false;
        TokenList tl = PreProcessor.tokenizer((StringBuffer)new StringBuffer(text), (char)'.', (boolean)true, null);
        Token tk = tl.getFirst();
        while (tk != null && !foundStmt) {
            if (VcobolEditor.isStatement((String)tk.getWord())) {
                foundStmt = true;
            }
            tk = tl.getNext();
        }
        return foundStmt;
    }

    static /* synthetic */ Response access$0() {
        return programFinishedResponse;
    }

    static /* synthetic */ Command access$1() {
        return quitCommand;
    }

    static /* synthetic */ void access$2(VcobolDebugTarget vcobolDebugTarget) {
        vcobolDebugTarget.terminated();
    }

    static /* synthetic */ DataOutputStream access$3(VcobolDebugTarget vcobolDebugTarget) {
        return vcobolDebugTarget.socketOutputStream;
    }

    static /* synthetic */ EventDispatchJob access$4(VcobolDebugTarget vcobolDebugTarget) {
        return vcobolDebugTarget.job;
    }

    static /* synthetic */ void access$5(VcobolDebugTarget vcobolDebugTarget, Response response) {
        vcobolDebugTarget.handleResponse(response);
    }

    static /* synthetic */ void access$6(VcobolDebugTarget vcobolDebugTarget) {
        vcobolDebugTarget.start();
    }

    static /* synthetic */ AbstractDebugView access$7() {
        return VcobolDebugTarget.findDebugView();
    }

    static /* synthetic */ void access$8(VcobolDebugTarget vcobolDebugTarget, Response response) {
        vcobolDebugTarget.handleResponse0(response);
    }

    static /* synthetic */ void access$9(VcobolDebugTarget vcobolDebugTarget) {
        vcobolDebugTarget.showVCobolConsole();
    }
}

