/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.debug;

import com.vcobol.plugins.editor.VcobolEditor;
import com.vcobol.plugins.editor.VcobolEditorPlugin;
import com.vcobol.plugins.editor.debug.VcobolBreakpoint;
import com.vcobol.plugins.editor.debug.VcobolStackFrame;
import com.vcobol.plugins.editor.debug.VcobolWatchpoint;
import com.veryant.commons.editor.util.IOFileStorage;
import com.veryant.commons.editor.util.IOFileStorageEditorInput;
import com.veryant.commons.editor.util.LocalFileStorageEditorInput;
import com.veryant.commons.editor.util.ZipEntryStorageEditorInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.debug.core.sourcelookup.containers.ZipEntryStorage;
import org.eclipse.debug.ui.IInstructionPointerPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class VcobolModelPresentation
implements IInstructionPointerPresentation {
    public static final String ID = "VcobolDebugModel";

    public void computeDetail(IValue value, IValueDetailListener listener) {
        int MAX_LENGTH = 256;
        String detail = null;
        try {
            detail = value.getValueString();
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        if (detail == null) {
            detail = "";
        }
        if (detail.length() > 256) {
            detail = String.valueOf(detail.substring(0, 256)) + "...";
        }
        listener.detailComputed(value, detail);
    }

    public Image getImage(Object element) {
        if (element instanceof VcobolBreakpoint) {
            return VcobolEditorPlugin.getDefault().getImageProvider().getImage("/breakpoint.gif");
        }
        if (element instanceof VcobolWatchpoint) {
            return VcobolEditorPlugin.getDefault().getImageProvider().getImage("/monitor.gif");
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof VcobolStackFrame) {
            return element.toString();
        }
        if (element instanceof VcobolBreakpoint) {
            return element.toString();
        }
        if (element instanceof VcobolWatchpoint) {
            return element.toString();
        }
        return null;
    }

    public void setAttribute(String attribute, Object value) {
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public String getEditorId(IEditorInput input, Object element) {
        if (element instanceof IFile || element instanceof LocalFileStorage || element instanceof IOFileStorage || element instanceof ZipEntryStorage) {
            return VcobolEditor.ID;
        }
        return null;
    }

    public IEditorInput getEditorInput(Object element) {
        if (element instanceof IFile) {
            return new FileEditorInput((IFile)element);
        }
        if (element instanceof LocalFileStorage) {
            return new LocalFileStorageEditorInput((LocalFileStorage)element);
        }
        if (element instanceof IOFileStorage) {
            return new IOFileStorageEditorInput((IOFileStorage)element);
        }
        if (element instanceof ZipEntryStorage) {
            return new ZipEntryStorageEditorInput((ZipEntryStorage)element);
        }
        return null;
    }

    public Annotation getInstructionPointerAnnotation(IEditorPart editorPart, IStackFrame frame) {
        return null;
    }

    public String getInstructionPointerAnnotationType(IEditorPart editorPart, IStackFrame frame) {
        return null;
    }

    public Image getInstructionPointerImage(IEditorPart editorPart, IStackFrame frame) {
        return null;
    }

    public String getInstructionPointerText(IEditorPart editorPart, IStackFrame frame) {
        if (editorPart instanceof VcobolEditor) {
            int lineNo = 0;
            try {
                lineNo = ((VcobolStackFrame)frame).getLineNumber();
            }
            catch (DebugException debugException) {
                // empty catch block
            }
            if (lineNo > 0) {
                VcobolEditor ie = (VcobolEditor)editorPart;
                ie.setDebugCurrentLine(lineNo - 1);
            }
        }
        return null;
    }
}

