/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.debug;

import com.vcobol.plugins.editor.VcobolEditor;
import com.vcobol.plugins.editor.debug.VcobolDebugElement;
import com.vcobol.plugins.editor.debug.VcobolDebugTarget;
import com.vcobol.plugins.editor.debug.VcobolThread;
import com.veryant.debugger.protocol.Command;
import com.veryant.debugger.protocol.CommandStepTo;
import com.veryant.debugger.protocol.ResponseGetInfo;
import java.io.File;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;

public class VcobolRunToLineAdapter
implements IRunToLineTarget {
    public boolean canRunToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) {
        return target instanceof VcobolDebugElement && target.isSuspended();
    }

    public void runToLine(IWorkbenchPart part, ISelection selection, ISuspendResume sr) throws CoreException {
        if (selection instanceof ITextSelection) {
            VcobolDebugElement elem = (VcobolDebugElement)sr;
            VcobolThread selThread = VcobolDebugTarget.getSelectedThread();
            if (selThread != null && selThread.isSuspended()) {
                VcobolDebugTarget target = (VcobolDebugTarget)elem.getDebugTarget();
                VcobolEditor editor = (VcobolEditor)part;
                String fileName = editor.getEditorInput().getName();
                int fileIndex = 0;
                String progName = target.getName();
                ResponseGetInfo rgetinfo = target.getInfo(selThread.getName(), progName);
                List filenames = rgetinfo.getFileNames();
                int i = 0;
                ListIterator lit = filenames.listIterator();
                while (lit.hasNext()) {
                    String fn = (String)lit.next();
                    int idx = fn.lastIndexOf(File.separatorChar);
                    if (idx >= 0) {
                        fn = fn.substring(idx + 1);
                    }
                    if (fn.equals(fileName)) {
                        fileIndex = i;
                        break;
                    }
                    ++i;
                }
                ITextSelection tsel = (ITextSelection)selection;
                CommandStepTo cmd = new CommandStepTo(selThread.getName(), progName, fileIndex, tsel.getStartLine() + 1);
                target.putAsyncCommand((Command)cmd);
            }
        }
    }
}

