/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.debug;

import com.veryant.commons.editor.util.IOFileStorage;
import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.AbstractSourceContainer;

public class VcobolSourceContainer
extends AbstractSourceContainer {
    private IProject project;

    public VcobolSourceContainer(IProject project) {
        this.project = project;
    }

    public Object[] findSourceElements(String name) throws CoreException {
        File f = new File(name);
        if (f.isAbsolute()) {
            return new Object[]{new IOFileStorage(f, false)};
        }
        IFile ifile = this.project.getFile((IPath)new Path(name));
        if (ifile.exists()) {
            return new Object[]{ifile};
        }
        name = f.getName();
        ifile = this.findFile((IContainer)this.project, name);
        if (ifile != null) {
            return new Object[]{ifile};
        }
        return new Object[0];
    }

    private IFile findFile(IContainer fld, String name) throws CoreException {
        IResource[] members = fld.members();
        int i = 0;
        while (i < members.length) {
            IFile file;
            if (members[i] instanceof IFile) {
                if (members[i].exists() && members[i].getName().equals(name)) {
                    return (IFile)members[i];
                }
            } else if (members[i] instanceof IFolder && (file = this.findFile((IContainer)((IFolder)members[i]), name)) != null) {
                return file;
            }
            ++i;
        }
        return null;
    }

    public String getName() {
        return "vCOBOL Source Container";
    }

    public ISourceContainerType getType() {
        return null;
    }
}

