/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.debug;

import com.vcobol.plugins.editor.debug.IStepProgram;
import com.vcobol.plugins.editor.debug.VcobolDebugElement;
import com.vcobol.plugins.editor.debug.VcobolDebugTarget;
import com.vcobol.plugins.editor.debug.VcobolThread;
import com.vcobol.plugins.editor.util.PluginUtilities;
import com.veryant.debugger.protocol.Position;
import com.veryant.debugger.protocol.ResponseGetInfo;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.ui.IActionFilter;

public class VcobolStackFrame
extends VcobolDebugElement
implements IStackFrame,
IStepProgram,
IActionFilter,
IDisconnect {
    private String name;
    private int lineNumber;
    private VcobolThread thread;
    private String filename;
    private String progname;
    private String basefilename;
    private int fileNumber;

    public VcobolStackFrame(Position position, VcobolThread thread, IDebugTarget target, ILaunch l) {
        super(target, l);
        this.name = position.getParagraphName();
        this.lineNumber = position.getLineNumber();
        this.thread = thread;
        this.progname = position.getProgramName();
        this.fileNumber = position.getFileNumber();
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getLineNumber() throws DebugException {
        return this.lineNumber;
    }

    public int getFileNumber() {
        return this.fileNumber;
    }

    public void setLineNumber(int n) {
        this.lineNumber = n;
    }

    public String getFilename() {
        IProject project;
        if (this.filename == null) {
            try {
                ResponseGetInfo info = ((VcobolDebugTarget)this.getDebugTarget()).getInfo(this.getThread().getName(), this.progname);
                this.setFilename((String)info.getFileNames().get(this.fileNumber));
            }
            catch (DebugException info) {
                // empty catch block
            }
        }
        return (project = ((VcobolDebugTarget)this.getDebugTarget()).getProject()) != null ? PluginUtilities.makeRelative((String)this.filename, (IProject)project) : this.filename;
    }

    private void setFilename(String filename) {
        this.filename = filename;
        this.basefilename = new File(this.filename).getName();
    }

    public String getBaseFilename() {
        if (this.basefilename == null) {
            try {
                ResponseGetInfo info = ((VcobolDebugTarget)this.getDebugTarget()).getInfo(this.getThread().getName(), this.progname);
                this.setFilename((String)info.getFileNames().get(this.fileNumber));
            }
            catch (DebugException debugException) {
                // empty catch block
            }
        }
        return this.basefilename;
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return null;
    }

    public IThread getThread() {
        return this.thread;
    }

    public IVariable[] getVariables() throws DebugException {
        return ((VcobolThread)this.getThread()).getVariables();
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public boolean hasVariables() throws DebugException {
        return ((VcobolThread)this.getThread()).hasVariables();
    }

    public boolean canStepInto() {
        return this.thread.canStepInto();
    }

    public boolean canStepOver() {
        return this.thread.canStepOver();
    }

    public boolean canStepReturn() {
        return this.thread.canStepReturn();
    }

    public boolean isStepping() {
        return this.thread.isStepping();
    }

    public void stepInto() throws DebugException {
        this.thread.stepInto();
    }

    public void stepOver() throws DebugException {
        this.thread.stepOver();
    }

    public void stepReturn() throws DebugException {
        this.thread.stepReturn();
    }

    public boolean canResume() {
        return this.thread.canResume();
    }

    public boolean canSuspend() {
        return this.thread.canSuspend();
    }

    public boolean isSuspended() {
        return this.thread.isSuspended();
    }

    public void resume() throws DebugException {
        this.thread.resume();
    }

    public void suspend() throws DebugException {
        this.thread.suspend();
    }

    public boolean canTerminate() {
        return this.thread.canTerminate();
    }

    public boolean isTerminated() {
        return this.thread.isTerminated();
    }

    public void terminate() throws DebugException {
        this.thread.terminate();
    }

    public boolean canDisconnect() {
        return this.thread.canDisconnect();
    }

    public boolean isDisconnected() {
        return this.thread.isDisconnected();
    }

    public void disconnect() throws DebugException {
        this.thread.disconnect();
    }

    public boolean equals(Object o) {
        if (!(o instanceof VcobolStackFrame)) {
            return false;
        }
        VcobolStackFrame sf = (VcobolStackFrame)o;
        String bsn1 = this.getBaseFilename();
        String bsn2 = sf.getBaseFilename();
        return this.name.equalsIgnoreCase(sf.name) && bsn1.equalsIgnoreCase(bsn2) && this.lineNumber == sf.lineNumber;
    }

    public String toString() {
        return String.valueOf(this.name) + " [" + this.progname + "]";
    }

    public String getProgramName() {
        return this.progname;
    }

    public void stepOutProgram() {
        this.thread.stepOutProgram();
    }

    public boolean canStepOutProgram() {
        return this.thread.canStepOutProgram();
    }

    public boolean testAttribute(Object target, String name, String value) {
        return this.thread.testAttribute(target, name, value);
    }
}

