/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.debug;

import com.vcobol.plugins.editor.debug.IStepProgram;
import com.vcobol.plugins.editor.debug.VcobolDebugElement;
import com.vcobol.plugins.editor.debug.VcobolDebugTarget;
import com.vcobol.plugins.editor.debug.VcobolStackFrame;
import com.vcobol.plugins.editor.debug.VcobolVariable;
import com.vcobol.plugins.editor.debug.util.TreeElementDisplayEx;
import com.veryant.debugger.protocol.Command;
import com.veryant.debugger.protocol.CommandContinue;
import com.veryant.debugger.protocol.CommandDisplay;
import com.veryant.debugger.protocol.CommandStep;
import com.veryant.debugger.protocol.CommandStepOutParagraph;
import com.veryant.debugger.protocol.CommandStepOutProgram;
import com.veryant.debugger.protocol.CommandStepOver;
import com.veryant.debugger.protocol.CommandSuspend;
import com.veryant.debugger.protocol.DebuggableThread;
import com.veryant.debugger.protocol.Position;
import com.veryant.debugger.protocol.Response;
import com.veryant.debugger.protocol.ResponseDisplay;
import java.util.TreeMap;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.ui.IActionFilter;

public class VcobolThread
extends VcobolDebugElement
implements IDebugElement,
IThread,
IStepProgram,
IActionFilter,
IDisconnect {
    private String name;
    private VcobolStackFrame[] frames = new VcobolStackFrame[0];
    private int state;
    private String progName;
    private TreeMap<String, VcobolVariable> variables = new TreeMap(new /* Unavailable Anonymous Inner Class!! */);
    private static final IBreakpoint[] emptyBpArray = new IBreakpoint[0];

    public VcobolThread(IDebugTarget target, ILaunch l) {
        super(target, l);
    }

    public void init(DebuggableThread dtd) {
        this.name = dtd.getName();
        this.state = dtd.getState();
        this.progName = dtd.getProgramName();
    }

    public void removeAllVariables() {
        this.variables.clear();
    }

    public void removeVariable(VcobolVariable var) {
        try {
            this.variables.remove(var.getName());
        }
        catch (DebugException debugException) {
            // empty catch block
        }
    }

    public void addVariable(VcobolVariable var) {
        try {
            this.variables.put(var.getName(), var);
        }
        catch (DebugException debugException) {
            // empty catch block
        }
    }

    public void refreshVariables(boolean hex) {
        VcobolDebugTarget target = (VcobolDebugTarget)this.getDebugTarget();
        for (VcobolVariable var : this.variables.values()) {
            try {
                CommandDisplay cmd = new CommandDisplay(this.getName(), this.frames[0].getProgramName(), var.getVariableIdentifier(), hex, true);
                Response resp = target.putSyncCommand((Command)cmd);
                if (resp.getReturnCode() != 0) continue;
                ResponseDisplay rd = (ResponseDisplay)resp;
                String strValue = rd.isHex() ? VcobolDebugTarget.getHexString((byte[])rd.getByteValue()) : rd.getStringValue();
                var.init(rd.getVariableIdentifier(), new TreeElementDisplayEx(rd.getTreeValues()), strValue, rd.isHex(), var.getParent(), this, this.getDebugTarget(), this.getLaunch());
            }
            catch (DebugException debugException) {
                // empty catch block
            }
        }
    }

    IVariable[] getVariables() {
        if (this.hasVariables()) {
            IVariable[] Return = new IVariable[this.variables.size()];
            this.variables.values().toArray(Return);
            return Return;
        }
        return new IVariable[0];
    }

    boolean hasVariables() {
        return this.isSuspended() && !this.variables.isEmpty();
    }

    public IBreakpoint[] getBreakpoints() {
        return emptyBpArray;
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        if (this.isSuspended()) {
            return this.frames;
        }
        return new IStackFrame[0];
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        IStackFrame[] sf = this.getStackFrames();
        IStackFrame Return = sf.length > 0 ? sf[0] : null;
        return Return;
    }

    public boolean hasStackFrames() throws DebugException {
        return !this.isTerminated() && this.isSuspended();
    }

    public boolean canResume() {
        return this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isSuspended();
    }

    public boolean isSuspended() {
        return this.state == 1;
    }

    public void suspend() throws DebugException {
        ((VcobolDebugTarget)this.getDebugTarget()).putAsyncCommand((Command)new CommandSuspend(this.getName()));
        this.setState(7);
        this.fireResumeEvent(32);
    }

    public boolean canStepInto() {
        return this.isSuspended();
    }

    public boolean canStepOver() {
        return this.isSuspended();
    }

    public boolean canStepReturn() {
        return this.isSuspended();
    }

    public boolean isStepping() {
        return false;
    }

    public void setStepping(boolean s) {
    }

    public void stepInto() throws DebugException {
        ((VcobolDebugTarget)this.getDebugTarget()).putAsyncCommand((Command)new CommandStep(this.getName(), 1));
        this.setState(2);
        this.fireResumeEvent(1);
    }

    public void stepOver() throws DebugException {
        ((VcobolDebugTarget)this.getDebugTarget()).putAsyncCommand((Command)new CommandStepOver(this.getName()));
        this.setState(3);
        this.fireResumeEvent(2);
    }

    public void stepReturn() throws DebugException {
        ((VcobolDebugTarget)this.getDebugTarget()).putAsyncCommand((Command)new CommandStepOutParagraph(this.getName()));
        this.setState(4);
        this.fireResumeEvent(4);
    }

    public void stepOutProgram() {
        try {
            ((VcobolDebugTarget)this.getDebugTarget()).putAsyncCommand((Command)new CommandStepOutProgram(this.getName()));
            this.setState(5);
            this.fireResumeEvent(4);
        }
        catch (DebugException debugException) {
            // empty catch block
        }
    }

    public void resume() throws DebugException {
        ((VcobolDebugTarget)this.getDebugTarget()).putAsyncCommand((Command)new CommandContinue(this.getName()));
        this.setState(6);
        this.fireResumeEvent(32);
    }

    public boolean canStepOutProgram() {
        return this.isSuspended();
    }

    public boolean canDisconnect() {
        return this.getDebugTarget().canDisconnect();
    }

    public boolean isDisconnected() {
        return this.getDebugTarget().isDisconnected();
    }

    public void disconnect() throws DebugException {
        this.getDebugTarget().disconnect();
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public String getProgName() {
        return this.progName;
    }

    public void setProgName(String progName) {
        this.progName = progName;
    }

    public boolean canTerminate() {
        return this.getDebugTarget().canTerminate();
    }

    public boolean isTerminated() {
        return this.getDebugTarget().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getDebugTarget().terminate();
    }

    public void setPositionStacks(Position[] positionStacks) {
        this.frames = this.buildStackFrames(positionStacks);
    }

    VcobolStackFrame[] buildStackFrames(Position[] pos) {
        int length = pos != null ? pos.length : 0;
        VcobolStackFrame[] Return = new VcobolStackFrame[length];
        int i = 0;
        while (i < length) {
            Return[length - 1 - i] = new VcobolStackFrame(pos[i], this, this.getDebugTarget(), this.launch);
            ++i;
        }
        return Return;
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (target instanceof IStepProgram && name.equals("canStepProgram")) {
            try {
                return new Boolean(value).booleanValue() == ((IStepProgram)target).canStepOutProgram();
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }
}

