/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.debug;

import com.vcobol.plugins.editor.debug.VcobolDebugElement;
import com.vcobol.plugins.editor.debug.VcobolDebugTarget;
import com.vcobol.plugins.editor.debug.VcobolThread;
import com.vcobol.plugins.editor.debug.VcobolValue;
import com.vcobol.plugins.editor.debug.util.TreeElementDisplayEx;
import com.vcobol.plugins.editor.util.PluginUtilities;
import com.veryant.debugger.protocol.Command;
import com.veryant.debugger.protocol.CommandLet;
import com.veryant.debugger.protocol.Response;
import com.veryant.debugger.protocol.VariableIdentifier;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.ui.IActionFilter;

/*
 * Exception performing whole class analysis ignored.
 */
public class VcobolVariable
extends VcobolDebugElement
implements IVariable,
IActionFilter {
    private String fullName;
    private VcobolValue value;
    private VcobolVariable parent;
    private VcobolThread thread;
    private VariableIdentifier variableIdentifier;
    private boolean hex;

    public VcobolVariable(VariableIdentifier vId, TreeElementDisplayEx node, String stringValue, boolean hex, VcobolVariable parent, VcobolThread thread, IDebugTarget target, ILaunch launch) {
        super(target, launch);
        this.init(vId, node, stringValue, hex, parent, thread, target, launch);
    }

    public void init(VariableIdentifier vId, TreeElementDisplayEx node, String stringValue, boolean hex, VcobolVariable parent, VcobolThread thread, IDebugTarget target, ILaunch launch) {
        this.variableIdentifier = vId;
        this.hex = hex;
        this.fullName = vId != null ? vId.getFullName() : (node != null ? node.getName() : "???");
        this.parent = parent;
        this.thread = thread;
        this.value = node == null || node.getChildren().size() == 0 ? new VcobolValue(stringValue, this.getDebugTarget(), this.getLaunch()) : (node.getChildren().size() == 1 && parent == null ? new VcobolValue((TreeElementDisplayEx)node.getChildren().get(0), this, target, launch) : new VcobolValue(node, this, target, launch));
    }

    public VcobolThread getThread() {
        return this.thread;
    }

    public VariableIdentifier getVariableIdentifier() {
        return this.variableIdentifier;
    }

    public boolean isHex() {
        return this.hex;
    }

    public String getName() throws DebugException {
        return this.fullName;
    }

    public VcobolVariable getParent() {
        return this.parent;
    }

    public String getReferenceTypeName() throws DebugException {
        return null;
    }

    public IValue getValue() throws DebugException {
        return this.value;
    }

    public boolean hasValueChanged() throws DebugException {
        return false;
    }

    public void setValue(String expression) throws DebugException {
        this.value.setValueString(expression);
    }

    public void setValue(IValue value) throws DebugException {
        if (value instanceof VcobolValue) {
            this.value = (VcobolValue)value;
        }
    }

    public boolean supportsValueModification() {
        try {
            return !this.value.hasVariables();
        }
        catch (DebugException ex) {
            return false;
        }
    }

    private static String[] splitVarName(String varName) {
        int idx = varName.indexOf(40);
        if (idx >= 0) {
            return new String[]{varName.substring(0, idx).trim(), varName.substring(idx).trim()};
        }
        String[] stringArray = new String[2];
        stringArray[0] = varName.trim();
        return stringArray;
    }

    public boolean verifyValue(String expression) throws DebugException {
        boolean Return = false;
        VcobolThread selThread = VcobolDebugTarget.getSelectedThread();
        if (selThread != null) {
            try {
                String[] ss;
                String value;
                byte[] bytes;
                if (this.hex) {
                    bytes = PluginUtilities.asciiToHex((String)expression);
                    value = new String(bytes);
                } else {
                    value = expression;
                    bytes = value.getBytes();
                }
                StringBuffer fullVarName = new StringBuffer();
                String prev = null;
                VcobolVariable parent = this.getParent();
                while (parent != null) {
                    ss = VcobolVariable.splitVarName((String)parent.getName());
                    if (prev == null || !prev.equals(ss[0])) {
                        fullVarName.append(" OF " + ss[0]);
                    }
                    prev = ss[0];
                    parent = parent.getParent();
                }
                ss = VcobolVariable.splitVarName((String)this.fullName);
                if (ss[1] != null) {
                    fullVarName.append(" " + ss[1]);
                }
                fullVarName.insert(0, ss[0]);
                CommandLet cmd = new CommandLet(selThread.getName(), selThread.getProgName(), VcobolDebugTarget.varNameToVariableIdentifier((String)fullVarName.toString()), false, value, bytes);
                Response resp = VcobolDebugTarget.getDefault().putSyncCommand((Command)cmd);
                Return = resp.getReturnCode() == 0;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (Return) {
            VcobolDebugTarget.getDefault().refreshVariableView();
        }
        return Return;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return this.verifyValue(value.getValueString());
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (target instanceof VcobolVariable && name.equals("parent")) {
            return ((VcobolVariable)target).parent == null;
        }
        return false;
    }
}

