/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.debug;

import com.vcobol.plugins.editor.VcobolEditor;
import com.vcobol.plugins.editor.debug.VcobolWatchpoint;
import com.vcobol.plugins.editor.util.PluginUtilities;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.Breakpoint;
import org.eclipse.debug.core.model.IWatchpoint;

public class VcobolWatchpoint
extends Breakpoint
implements IWatchpoint {
    public static final String VAR_NAME = "varname";
    public static final String HEXADECIMAL = "hexadecimal";
    private String value;
    private String className;
    private IStorage storage;

    public VcobolWatchpoint() {
    }

    public VcobolWatchpoint(String varname, boolean hexadecimal, boolean enabled, IStorage st, int lineNumber, VcobolEditor editor) throws CoreException {
        this.storage = st;
        1 runnable = new /* Unavailable Anonymous Inner Class!! */;
        if (this.storage instanceof IFile) {
            this.run(this.getMarkerRule((IResource)((IFile)this.storage)), (IWorkspaceRunnable)runnable);
        } else {
            this.run(null, (IWorkspaceRunnable)runnable);
        }
    }

    public VcobolWatchpoint(String varname, IStorage resource, int lineNumber, VcobolEditor editor) throws CoreException {
        this(varname, false, true, resource, lineNumber, editor);
    }

    public void setLineNumber(int n) throws CoreException {
        this.getMarker().setAttribute("lineNumber", n);
    }

    public int getLineNumber() {
        return this.getMarker().getAttribute("lineNumber", 0);
    }

    public boolean isAccess() throws CoreException {
        return false;
    }

    public boolean isModification() throws CoreException {
        return true;
    }

    public void setAccess(boolean access) throws CoreException {
    }

    public void setModification(boolean modification) throws CoreException {
    }

    public boolean supportsAccess() {
        return false;
    }

    public boolean supportsModification() {
        return true;
    }

    public String getModelIdentifier() {
        return "VcobolDebugModel";
    }

    public String getVariableName() {
        return this.getVariableName(null);
    }

    public String getVariableName(String def) {
        return this.getMarker().getAttribute(VAR_NAME, def);
    }

    public void setVariableName(String vn) throws CoreException {
        this.getMarker().setAttribute(VAR_NAME, (Object)vn);
    }

    public boolean isHexadecimal() {
        return this.isHexadecimal(false);
    }

    public boolean isHexadecimal(boolean def) {
        return this.getMarker().getAttribute(HEXADECIMAL, def);
    }

    public void setHexadecimal(boolean hex) throws CoreException {
        this.getMarker().setAttribute(HEXADECIMAL, hex);
    }

    public String toString() {
        StringBuffer Return = new StringBuffer();
        Return.append(this.getClassName());
        Return.append(".");
        Return.append(this.getVariableName(""));
        Return.append(" = ");
        Return.append(this.value);
        return Return.toString();
    }

    public void setValue(String v) {
        this.value = v;
    }

    protected IMarker ensureMarker() throws DebugException {
        return this.getMarker();
    }

    public String getClassName() {
        if (this.className == null) {
            this.className = PluginUtilities.getVcobolClassName((String)this.getStorage().getName());
        }
        return this.className;
    }

    public IStorage getStorage() {
        if (this.storage != null) {
            return this.storage;
        }
        IResource r = this.getMarker().getResource();
        if (r instanceof IFile) {
            return (IFile)r;
        }
        return null;
    }

    public boolean equals(IStorage storage, String varname) {
        return this.equals((Object)this.getStorage(), (Object)storage) && this.getVariableName("").equalsIgnoreCase(varname);
    }

    private boolean equals(Object o1, Object o2) {
        if (o1 != null) {
            if (o2 != null) {
                return o1.equals(o2);
            }
            return false;
        }
        return o2 == null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof VcobolWatchpoint)) {
            return false;
        }
        VcobolWatchpoint wp = (VcobolWatchpoint)o;
        return this.equals(wp.getStorage(), wp.getVariableName(""));
    }

    static /* synthetic */ IStorage access$0(VcobolWatchpoint vcobolWatchpoint) {
        return vcobolWatchpoint.storage;
    }
}

