/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.debug.util;

import com.vcobol.plugins.editor.debug.util.DebuggerParseException;
import com.vcobol.plugins.editor.debug.util.Expression;
import com.vcobol.plugins.editor.debug.util.TokenManager;
import com.vcobol.plugins.editor.debug.util.VarName;
import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.Vector;

public class Expression {
    public static final int ADD = 0;
    public static final int SUBTRACT = 1;
    public static final int DIVIDE = 2;
    public static final int MULTIPLY = 3;
    private Vector elements = new Vector();
    private transient int openPar;

    public Expression(TokenManager tm) throws DebuggerParseException {
        String tk;
        boolean afterOp = true;
        while ((tk = tm.getToken()) != null) {
            if (tk.equals("(")) {
                ++this.openPar;
                this.elements.addElement(new Expression(tm));
                afterOp = false;
                continue;
            }
            if (tk.equals(")")) {
                if (this.openPar > 0) {
                    --this.openPar;
                    continue;
                }
                tm.ungetToken();
                break;
            }
            BigDecimal num = this.number(tk);
            if (num != null) {
                if (afterOp) {
                    this.elements.addElement(num);
                    afterOp = false;
                    continue;
                }
                tm.ungetToken();
                break;
            }
            if (this.operator(tk) != null) {
                if (!afterOp) {
                    afterOp = true;
                    this.elements.addElement(new Op(this, tk));
                    continue;
                }
                throw new DebuggerParseException();
            }
            if (afterOp) {
                tm.ungetToken();
                this.elements.addElement(new VarName(tm));
                afterOp = false;
                continue;
            }
            tm.ungetToken();
            break;
        }
        if (this.openPar > 0) {
            throw new DebuggerParseException();
        }
    }

    private BigDecimal number(String tk) {
        try {
            return new BigDecimal(tk.replace(',', '.'));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    private Op operator(String tk) {
        try {
            return new Op(this, tk);
        }
        catch (DebuggerParseException de) {
            return null;
        }
    }

    public Enumeration getElements() {
        return this.elements.elements();
    }
}

