/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.debug.util;

import com.veryant.debugger.protocol.TreeElementDisplay;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeElementDisplayEx {
    private List<TreeElementDisplayEx> children = new ArrayList();
    private String name;
    private String value;

    public TreeElementDisplayEx() {
    }

    public TreeElementDisplayEx(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public TreeElementDisplayEx(List treeValues) {
        this(treeValues.size() > 0 ? ((TreeElementDisplay)treeValues.get(0)).getName() : "", null);
        if (treeValues.size() > 0) {
            this.buildTree(treeValues);
        }
    }

    public List<TreeElementDisplayEx> getChildren() {
        return this.children;
    }

    private void buildTree(List treeValues) {
        TreeElementDisplay ted = null;
        ListIterator lit = treeValues.listIterator();
        while (lit.hasNext()) {
            ted = (TreeElementDisplay)lit.next();
            this.buildNode(lit, this, ted);
        }
    }

    private void buildNode(ListIterator tdel, TreeElementDisplayEx parent, TreeElementDisplay tedfirst) {
        TreeElementDisplay ted = null;
        TreeElementDisplayEx node = null;
        TreeElementDisplayEx parentNode = null;
        Hashtable<Integer, TreeElementDisplayEx> nodes = new Hashtable<Integer, TreeElementDisplayEx>();
        node = new TreeElementDisplayEx(tedfirst.getName(), tedfirst.getValue());
        parent.getChildren().add(node);
        nodes.put(new Integer(tedfirst.getId()), node);
        while (tdel.hasNext()) {
            ted = (TreeElementDisplay)tdel.next();
            node = new TreeElementDisplayEx(ted.getName(), ted.getValue());
            if (ted.getId() == tedfirst.getId()) {
                parent.getChildren().add(node);
            } else {
                parentNode = (TreeElementDisplayEx)nodes.get(new Integer(ted.getParentId()));
                if (parentNode != null) {
                    parentNode.getChildren().add(node);
                }
            }
            if (nodes.containsKey(new Integer(ted.getId()))) {
                nodes.remove(new Integer(ted.getId()));
            }
            nodes.put(new Integer(ted.getId()), node);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getName();
    }
}

