/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.debug.util;

import com.vcobol.plugins.editor.debug.util.DebuggerParseException;
import com.vcobol.plugins.editor.debug.util.Expression;
import com.vcobol.plugins.editor.debug.util.TokenManager;
import java.util.Enumeration;
import java.util.Vector;

public class VarName {
    private Vector of = new Vector();
    private Vector subscript = new Vector();
    private String name;
    private String fullName;
    private Expression leftPos;
    private Expression subLen;
    private boolean hasSubscript;
    private boolean hasSubValue;
    private String value;

    public VarName(String fn, String fv) {
        this.fullName = fn;
        this.value = fv;
    }

    public VarName(TokenManager tm) throws DebuggerParseException {
        TokenManager.Marker initMk = tm.setMarker();
        this.analyze(tm);
        tm.ungetToken();
        TokenManager.Marker endMk = tm.setMarker();
        tm.getToken();
        this.fullName = tm.toString(initMk, endMk);
    }

    public void clearSubscripts() {
        this.subscript.clear();
        this.hasSubscript = false;
    }

    public boolean hasSubvalue() {
        return this.hasSubValue;
    }

    public boolean hasAncestor() {
        return this.of.size() > 0;
    }

    public Enumeration getAncestors() {
        return this.of.elements();
    }

    public int getNAncestors() {
        return this.of.size();
    }

    public int getNSubscripts() {
        return this.subscript.size();
    }

    public String getAncestor(int i) {
        try {
            return (String)this.of.elementAt(i);
        }
        catch (Exception e) {
            return "";
        }
    }

    public Enumeration getSubscripts() {
        return this.subscript.elements();
    }

    public Expression getSubscript(int i) {
        try {
            return (Expression)this.subscript.elementAt(i);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean hasSubscript() {
        return this.hasSubscript;
    }

    public Expression getLeftPos() {
        return this.leftPos;
    }

    public Expression getSubLen() {
        return this.subLen;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String v) {
        this.value = v;
    }

    public void setFullName(String n) {
        this.fullName = n;
    }

    public String getFullName() {
        if (this.fullName != null) {
            return this.fullName.toUpperCase();
        }
        return "";
    }

    public boolean equals(Object o) {
        if (!(o instanceof VarName)) {
            return false;
        }
        VarName vn = (VarName)o;
        return this.getFullName().equals(vn.getFullName());
    }

    /*
     * Unable to fully structure code
     */
    private void analyze(TokenManager tm) throws DebuggerParseException {
        this.name = tm.getToken();
        if (this.name != null) ** GOTO lbl10
        throw new DebuggerParseException();
        while (tk.equalsIgnoreCase("OF") || tk.equalsIgnoreCase("IN")) {
            tk = tm.getToken();
            if (tk != null) {
                this.of.addElement(tk);
            } else {
                throw new DebuggerParseException();
            }
lbl10:
            // 2 sources

            if ((tk = tm.getToken()) != null) continue;
        }
        if (tk != null) {
            if (!tk.equals("(")) {
                tm.ungetToken();
                return;
            }
            tk = tm.getToken();
            if (tk == null) {
                throw new DebuggerParseException();
            }
            tm.ungetToken();
            val = new Expression(tm);
            tk = tm.getToken();
            if (tk == null) {
                throw new DebuggerParseException();
            }
            if (tk.equals(":")) {
                this.leftPos = val;
                this.hasSubValue = true;
                tk = tm.getToken();
                if (tk == null) {
                    throw new DebuggerParseException();
                }
                if (!tk.equals(")")) {
                    tm.ungetToken();
                    this.subLen = new Expression(tm);
                    tk = tm.getToken();
                    if (tk == null || !tk.equals(")")) {
                        throw new DebuggerParseException();
                    }
                }
            } else {
                this.hasSubscript = true;
                this.subscript.addElement(val);
                tm.ungetToken();
                while ((tk = tm.getToken()) != null) {
                    if (tk.equals(")")) break;
                    tm.ungetToken();
                    this.subscript.addElement(new Expression(tm));
                }
                if (tk == null) {
                    throw new DebuggerParseException();
                }
                tk = tm.getToken();
                if (tk != null) {
                    if (tk.equals("(")) {
                        tk = tm.getToken();
                        if (tk == null) {
                            throw new DebuggerParseException();
                        }
                        this.hasSubValue = true;
                        tm.ungetToken();
                        this.leftPos = new Expression(tm);
                        tk = tm.getToken();
                        if (tk == null || !tk.equals(":")) {
                            throw new DebuggerParseException();
                        }
                        tk = tm.getToken();
                        if (tk == null) {
                            throw new DebuggerParseException();
                        }
                        if (!tk.equals(")")) {
                            tm.ungetToken();
                            this.subLen = new Expression(tm);
                            tk = tm.getToken();
                            if (tk == null || !tk.equals(")")) {
                                throw new DebuggerParseException();
                            }
                        }
                    } else {
                        tm.ungetToken();
                    }
                }
            }
        }
    }

    public String toString() {
        return this.fullName;
    }
}

