/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.dialogs;

import com.vcobol.plugins.editor.VcobolEditor;
import com.vcobol.plugins.editor.VresourceBundle;
import com.vcobol.plugins.editor.debug.VcobolBreakpoint;
import com.vcobol.plugins.editor.debug.VcobolDebugTarget;
import com.vcobol.plugins.editor.util.PluginUtilities;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class BreakpointDialog
extends Dialog {
    private Text lineTxt;
    private Text fileTxt;
    private Button browseBtn;
    private Button enBtn;
    private String title;
    private VcobolBreakpoint breakpoint;
    private boolean modified;
    private IFile file;

    public BreakpointDialog(Shell shell, String title, VcobolBreakpoint def) {
        super(shell);
        this.title = title;
        this.breakpoint = def;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    public VcobolBreakpoint getBreakpoint() {
        return this.breakpoint;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        composite.setLayout((Layout)gl);
        Group gr = new Group(composite, 0);
        gl = new GridLayout();
        gl.numColumns = 3;
        gr.setLayout((Layout)gl);
        Label lineLbl = new Label((Composite)gr, 0);
        lineLbl.setText(VresourceBundle.getString((String)"set_at_line_lbl"));
        this.lineTxt = new Text((Composite)gr, 2048);
        GridData gd = new GridData();
        gd.widthHint = 60;
        gd.horizontalSpan = 2;
        this.lineTxt.setLayoutData((Object)gd);
        Label fileLbl = new Label((Composite)gr, 0);
        fileLbl.setText(VresourceBundle.getString((String)"filename_lbl"));
        this.fileTxt = new Text((Composite)gr, 2048);
        gd = new GridData();
        gd.widthHint = 220;
        this.fileTxt.setLayoutData((Object)gd);
        this.browseBtn = new Button((Composite)gr, 8);
        this.browseBtn.setText(VresourceBundle.getString((String)"browse_lbl"));
        this.browseBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.enBtn = new Button((Composite)gr, 32);
        this.enBtn.setText(VresourceBundle.getString((String)"enabled_lbl"));
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.enBtn.setLayoutData((Object)gd);
        if (this.breakpoint != null) {
            try {
                this.enBtn.setSelection(this.breakpoint.isEnabled());
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            this.lineTxt.setText("" + this.breakpoint.getLineNumber());
            this.lineTxt.setEditable(false);
            this.fileTxt.setText(this.breakpoint.getMarker().getResource().getName());
            this.browseBtn.setVisible(false);
        } else {
            this.enBtn.setSelection(true);
            VcobolEditor ed = PluginUtilities.getActiveVcobolEditor();
            if (ed != null && ed.getFileEditorInput() != null) {
                this.file = ed.getFileEditorInput().getFile();
                this.fileTxt.setText(this.file.getName());
                int caretPos = ed.getViewer().getTextWidget().getCaretOffset();
                try {
                    this.lineTxt.setText(Integer.toString(ed.getViewer().getDocument().getLineOfOffset(caretPos) + 1));
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
        this.fileTxt.setEditable(false);
        return composite;
    }

    private boolean checkLineNumber() {
        try {
            int val = Integer.parseInt(this.lineTxt.getText());
            if (val > 0) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    private void logError(String msg) {
        MessageBox mb = new MessageBox(this.getShell(), 33);
        mb.setText(this.getShell().getText());
        mb.setMessage(msg);
        mb.open();
    }

    protected void okPressed() {
        try {
            if (this.breakpoint != null) {
                this.setModified();
                this.breakpoint.setEnabled(this.enBtn.getSelection());
                this.breakpoint.getMarker().setAttribute("SKIP_EVENT", false);
            } else {
                if (!this.checkLineNumber()) {
                    this.logError(VresourceBundle.getString((String)"line_no_invalid_value_msg"));
                    return;
                }
                int lineNumber = Integer.parseInt(this.lineTxt.getText());
                if (this.file == null) {
                    this.logError(VresourceBundle.getString((String)"set_filename_msg"));
                    return;
                }
                if (!VcobolDebugTarget.canToggleLineBreakpoints((IFile)this.file, (int)lineNumber)) {
                    this.logError(String.valueOf(VresourceBundle.getString((String)"no_verb_at_line_msg")) + " " + lineNumber + ", file '" + this.file.getName() + "'");
                    return;
                }
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorReference[] editors = page.findEditors((IEditorInput)new FileEditorInput(this.file), VcobolEditor.ID, 3);
                VcobolEditor ed = editors.length > 0 ? (VcobolEditor)editors[0].getEditor(false) : null;
                this.breakpoint = new VcobolBreakpoint((IStorage)this.file, lineNumber, ed);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        super.okPressed();
    }

    private void setModified() throws CoreException {
        if (!this.modified) {
            this.breakpoint.getMarker().setAttribute("SKIP_EVENT", true);
        }
        this.modified = true;
    }

    static /* synthetic */ IFile access$0(BreakpointDialog breakpointDialog) {
        return breakpointDialog.file;
    }

    static /* synthetic */ void access$1(BreakpointDialog breakpointDialog, IFile iFile) {
        breakpointDialog.file = iFile;
    }

    static /* synthetic */ Text access$2(BreakpointDialog breakpointDialog) {
        return breakpointDialog.fileTxt;
    }
}

