/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EnvVarDialog
extends Dialog {
    private Text valueTxt;
    private String title;
    private Text nameTxt;
    private String value;
    private String name;

    public EnvVarDialog(Shell parentShell, String title) {
        this(parentShell, title, null, null);
    }

    public EnvVarDialog(Shell parentShell, String title, String name, String value) {
        super(parentShell);
        this.title = title;
        this.value = value;
        this.name = name;
    }

    public void okPressed() {
        this.value = this.valueTxt.getText();
        this.name = this.nameTxt.getText();
        super.okPressed();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    void updateOkButtonEnabledState() {
        boolean ok = true;
        char[] c = this.nameTxt.getText().toCharArray();
        ok &= c.length > 0 && Character.isJavaIdentifierStart(c[0]);
        int i = 1;
        while (i < c.length && ok) {
            ok &= Character.isJavaIdentifierPart(c[i]);
            ++i;
        }
        this.getButton(0).setEnabled(ok);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.updateOkButtonEnabledState();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        composite.setLayout((Layout)gl);
        Label lbl = new Label(composite, 0);
        lbl.setText("NAME:");
        this.nameTxt = new Text(composite, 2048);
        GridData gd = new GridData(768);
        this.nameTxt.setLayoutData((Object)gd);
        lbl = new Label(composite, 0);
        lbl.setText("VALUE:");
        this.valueTxt = new Text(composite, 2048);
        gd = new GridData(768);
        gd.widthHint = 400;
        this.valueTxt.setLayoutData((Object)gd);
        if (this.name != null && this.name.length() > 0) {
            this.nameTxt.setText(this.name);
            this.nameTxt.setEditable(false);
        }
        if (this.value != null) {
            this.valueTxt.setText(this.value);
        }
        this.nameTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        return composite;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }
}

