/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.dialogs;

import com.vcobol.plugins.editor.VresourceBundle;
import com.vcobol.plugins.editor.dialogs.EnvironmentPanel;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;

public class EnvironmentGroup {
    private EnvironmentPanel envPanel;
    private Button replaceBtn;
    private Button appendBtn;
    private List environmentVariables;
    private boolean appendEnvironment;
    private IPropertyChangeListener propertyChangeListener;
    private Control control;
    private boolean modified;
    private boolean listenersEnabled = true;
    public static final String ENVIRONMENT_VARIABLES_PROPERTY = "environmentVariables";
    public static final String APPEND_ENVIRONMENT_PROPERTY = "appendEnvironment";

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public void setPropertyChangeListener(IPropertyChangeListener propertyChangeListener) {
        this.propertyChangeListener = propertyChangeListener;
    }

    public Control createControl(Composite parent, Composite mainPanel) {
        if (mainPanel == null) {
            mainPanel = new Composite(parent, 0);
            GridLayout gl = new GridLayout();
            gl.numColumns = 1;
            mainPanel.setLayout((Layout)gl);
        }
        this.envPanel = new EnvironmentPanel(mainPanel, 0, (IPropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        GridData gd = new GridData(1808);
        this.envPanel.setLayoutData((Object)gd);
        this.appendBtn = new Button(mainPanel, 16);
        this.appendBtn.setText(VresourceBundle.getString((String)"append_env_lbl"));
        this.replaceBtn = new Button(mainPanel, 16);
        this.replaceBtn.setText(VresourceBundle.getString((String)"replace_env_lbl"));
        this.appendBtn.setEnabled(false);
        this.replaceBtn.setEnabled(false);
        this.appendBtn.setSelection(true);
        this.replaceBtn.setSelection(false);
        this.initData(false);
        this.addListeners();
        this.control = mainPanel;
        return mainPanel;
    }

    public void init(List environmentVariables, boolean appendEnvironment) {
        this.init(environmentVariables, appendEnvironment, false);
    }

    public void init(List environmentVariables, boolean appendEnvironment, boolean notifyChange) {
        this.environmentVariables = environmentVariables == null ? new LinkedList() : new LinkedList(environmentVariables);
        this.appendEnvironment = appendEnvironment;
        if (this.control != null) {
            this.initData(notifyChange);
        }
        this.modified = false;
    }

    private void addListeners() {
        this.appendBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.replaceBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void initData(boolean notifyChange) {
        this.listenersEnabled = notifyChange;
        this.envPanel.removeAll();
        if (this.environmentVariables != null) {
            ListIterator li = this.environmentVariables.listIterator();
            while (li.hasNext()) {
                int eq;
                String s = li.next().toString();
                if (s == null || s.length() <= 0 || (eq = s.indexOf(61)) < 0) continue;
                TableItem item = this.envPanel.newTableItem();
                item.setText(0, s.substring(0, eq));
                if (eq < s.length() - 1) {
                    item.setText(1, s.substring(eq + 1));
                    continue;
                }
                item.setText(1, "");
            }
            this.appendBtn.setSelection(this.appendEnvironment);
            this.replaceBtn.setSelection(!this.appendEnvironment);
        }
        this.appendBtn.setEnabled(this.envPanel.getItemCount() > 0);
        this.replaceBtn.setEnabled(this.envPanel.getItemCount() > 0);
        this.listenersEnabled = true;
    }

    public List getEnvironmentVariables() {
        return new LinkedList(this.environmentVariables);
    }

    public boolean getAppendEnvironment() {
        return this.appendEnvironment;
    }

    public void setEnvironmentVariables(List list) {
        this.init(list, this.appendEnvironment);
        this.modified = true;
    }

    public void setAppendEnvironment(boolean b) {
        this.init(this.environmentVariables, b);
        this.modified = true;
    }

    static /* synthetic */ EnvironmentPanel access$0(EnvironmentGroup environmentGroup) {
        return environmentGroup.envPanel;
    }

    static /* synthetic */ List access$1(EnvironmentGroup environmentGroup) {
        return environmentGroup.environmentVariables;
    }

    static /* synthetic */ Button access$2(EnvironmentGroup environmentGroup) {
        return environmentGroup.replaceBtn;
    }

    static /* synthetic */ Button access$3(EnvironmentGroup environmentGroup) {
        return environmentGroup.appendBtn;
    }

    static /* synthetic */ void access$4(EnvironmentGroup environmentGroup, boolean bl) {
        environmentGroup.modified = bl;
    }

    static /* synthetic */ IPropertyChangeListener access$5(EnvironmentGroup environmentGroup) {
        return environmentGroup.propertyChangeListener;
    }

    static /* synthetic */ boolean access$6(EnvironmentGroup environmentGroup) {
        return environmentGroup.listenersEnabled;
    }

    static /* synthetic */ void access$7(EnvironmentGroup environmentGroup, boolean bl) {
        environmentGroup.appendEnvironment = bl;
    }

    static /* synthetic */ boolean access$8(EnvironmentGroup environmentGroup) {
        return environmentGroup.appendEnvironment;
    }
}

