/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.dialogs;

import com.vcobol.plugins.editor.VresourceBundle;
import com.vcobol.plugins.editor.dialogs.EnvironmentPanel;
import java.io.File;
import java.net.URL;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;

public class ExternalPreProcessorConfigurationDialog
extends Dialog
implements IPropertyChangeListener {
    private Text progTxt;
    private Combo preprocCmb;
    private int selIdx = 0;
    private String title;
    private String progname;
    private String properties;
    private EnvironmentPanel envPanel;
    private Bundle unikixBundle;

    public ExternalPreProcessorConfigurationDialog(Shell shell, String title, String prg, String props) {
        super(shell);
        this.title = title;
        this.progname = prg;
        this.properties = props;
    }

    public void propertyChange(PropertyChangeEvent e) {
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    private void setProperties() {
        this.envPanel.removeAll();
        StringTokenizer stn = new StringTokenizer(this.properties, "\n");
        while (stn.hasMoreTokens()) {
            int eq;
            String s = stn.nextToken();
            if (s == null || s.length() <= 0 || (eq = s.indexOf(61)) < 0) continue;
            TableItem item = this.envPanel.newTableItem();
            item.setText(0, s.substring(0, eq));
            if (eq < s.length() - 1) {
                item.setText(1, s.substring(eq + 1));
                continue;
            }
            item.setText(1, "");
        }
    }

    protected Control createDialogArea(Composite parent) {
        GridData gd;
        Composite Return = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 3;
        Return.setLayout((Layout)gl);
        this.unikixBundle = Platform.getBundle((String)"com.iscobol.plugins.translator.UnikixTranslator.win32");
        if (this.unikixBundle != null) {
            Label l = new Label(Return, 0);
            l.setText(String.valueOf(VresourceBundle.getString((String)"installed_pp_lbl")) + ":");
            this.preprocCmb = new Combo(Return, 12);
            gd = new GridData(768);
            this.preprocCmb.setLayoutData((Object)gd);
            this.preprocCmb.add("");
            this.preprocCmb.add("Unikix");
            this.preprocCmb.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
            new Label(Return, 0);
        }
        Label l1 = new Label(Return, 0);
        l1.setText(String.valueOf(VresourceBundle.getString((String)"program_lbl")) + ":");
        this.progTxt = new Text(Return, 2048);
        if (this.progname != null) {
            this.progTxt.setText(this.progname);
        }
        gd = new GridData(768);
        this.progTxt.setLayoutData((Object)gd);
        Button btn = new Button(Return, 8);
        btn.setText(VresourceBundle.getString((String)"browse_lbl"));
        gd = new GridData(4);
        btn.setLayoutData((Object)gd);
        btn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.envPanel = new EnvironmentPanel(Return, 0, (IPropertyChangeListener)this);
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        gd.minimumHeight = 300;
        this.envPanel.setLayoutData((Object)gd);
        if (this.properties != null) {
            this.setProperties();
        }
        return Return;
    }

    private boolean clearMask() {
        MessageBox mb = new MessageBox(this.getShell(), 288);
        mb.setText("isCOBOL");
        mb.setMessage(String.valueOf(VresourceBundle.getString((String)"clear_all_msg")) + "?");
        if (mb.open() == 32) {
            this.progname = "";
            this.properties = "";
            this.progTxt.setText("");
            this.envPanel.removeAll();
            return true;
        }
        return false;
    }

    private boolean setUnikixData() {
        MessageBox mb = new MessageBox(this.getShell(), 288);
        mb.setText("isCOBOL");
        mb.setMessage(String.valueOf(VresourceBundle.getString((String)"set_lbl")) + " Unikix " + VresourceBundle.getString((String)"default_conf_msg") + "?");
        if (mb.open() == 32) {
            String unikixPath = "";
            try {
                URL url = FileLocator.toFileURL((URL)this.unikixBundle.getEntry("/"));
                unikixPath = new File(url.getPath()).getAbsolutePath();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.progname = String.valueOf(unikixPath) + "/bin/runkixclt.bat";
            this.properties = "path=%path%;" + unikixPath + "/bin\n";
            this.properties = String.valueOf(this.properties) + "unikix=" + unikixPath + "\n";
            this.properties = String.valueOf(this.properties) + "cobcpy=" + unikixPath + "/copy";
            this.progTxt.setText(this.progname);
            this.setProperties();
            return true;
        }
        return false;
    }

    public String getProgname() {
        return this.progname;
    }

    public String getProperties() {
        return this.properties;
    }

    protected void okPressed() {
        int envVarCount;
        this.progname = this.progTxt.getText();
        if (this.envPanel != null && (envVarCount = this.envPanel.getItemCount()) > 0) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < envVarCount) {
                TableItem item = this.envPanel.getTableItem(i);
                sb.append(String.valueOf(item.getText(0)) + "=" + item.getText(1));
                if (i < envVarCount - 1) {
                    sb.append("\n");
                }
                ++i;
            }
            this.properties = sb.toString();
        }
        super.okPressed();
    }

    static /* synthetic */ Combo access$0(ExternalPreProcessorConfigurationDialog externalPreProcessorConfigurationDialog) {
        return externalPreProcessorConfigurationDialog.preprocCmb;
    }

    static /* synthetic */ int access$1(ExternalPreProcessorConfigurationDialog externalPreProcessorConfigurationDialog) {
        return externalPreProcessorConfigurationDialog.selIdx;
    }

    static /* synthetic */ boolean access$2(ExternalPreProcessorConfigurationDialog externalPreProcessorConfigurationDialog) {
        return externalPreProcessorConfigurationDialog.clearMask();
    }

    static /* synthetic */ boolean access$3(ExternalPreProcessorConfigurationDialog externalPreProcessorConfigurationDialog) {
        return externalPreProcessorConfigurationDialog.setUnikixData();
    }

    static /* synthetic */ void access$4(ExternalPreProcessorConfigurationDialog externalPreProcessorConfigurationDialog, int n) {
        externalPreProcessorConfigurationDialog.selIdx = n;
    }

    static /* synthetic */ Text access$5(ExternalPreProcessorConfigurationDialog externalPreProcessorConfigurationDialog) {
        return externalPreProcessorConfigurationDialog.progTxt;
    }
}

