/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.dialogs;

import com.vcobol.plugins.editor.VcobolEditor;
import com.vcobol.plugins.editor.VresourceBundle;
import com.vcobol.plugins.editor.debug.VcobolWatchpoint;
import com.vcobol.plugins.editor.debug.util.DebuggerParseException;
import com.vcobol.plugins.editor.debug.util.TokenManager;
import com.vcobol.plugins.editor.debug.util.VarName;
import com.vcobol.plugins.editor.util.PluginUtilities;
import com.veryant.commons.editor.util.IsFragment;
import com.veryant.commons.editor.util.VarDecl;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MonitorDialog
extends Dialog {
    private Text varTxt;
    private Button enBtn;
    private Button hexBtn;
    private String title;
    private VcobolWatchpoint watchpoint;
    private String defVar;
    private boolean modified;

    public MonitorDialog(Shell shell, String title, VcobolWatchpoint def, String defVar) {
        super(shell);
        this.title = title;
        this.watchpoint = def;
        this.defVar = defVar;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        composite.setLayout((Layout)gl);
        Group gr = new Group(composite, 0);
        gl = new GridLayout();
        gl.numColumns = 2;
        gr.setLayout((Layout)gl);
        this.hexBtn = new Button((Composite)gr, 32);
        this.hexBtn.setText(VresourceBundle.getString((String)"hexadecimal_lbl"));
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.hexBtn.setLayoutData((Object)gd);
        this.enBtn = new Button((Composite)gr, 32);
        this.enBtn.setText(VresourceBundle.getString((String)"enabled_lbl"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.enBtn.setLayoutData((Object)gd);
        Label l = new Label((Composite)gr, 0);
        l.setText(VresourceBundle.getString((String)"varname_lbl"));
        this.varTxt = new Text((Composite)gr, 2048);
        gd = new GridData();
        gd.widthHint = 220;
        this.varTxt.setLayoutData((Object)gd);
        if (this.watchpoint != null) {
            this.varTxt.setEditable(false);
            String name = this.watchpoint.getVariableName();
            if (name.length() > 0) {
                this.varTxt.setText(name);
                this.varTxt.selectAll();
            }
            try {
                this.enBtn.setSelection(this.watchpoint.isEnabled());
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            if (this.watchpoint.isHexadecimal() && this.watchpoint.isHexadecimal()) {
                this.hexBtn.setSelection(true);
            }
        } else if (this.defVar != null) {
            this.varTxt.setText(this.defVar);
            this.enBtn.setSelection(true);
            this.varTxt.setEditable(false);
        } else {
            this.enBtn.setSelection(true);
        }
        return composite;
    }

    protected void okPressed() {
        if (this.watchpoint != null) {
            try {
                if (this.enBtn.getSelection() != this.watchpoint.isEnabled()) {
                    this.setModified();
                    this.watchpoint.setEnabled(this.enBtn.getSelection());
                }
                if (this.hexBtn.getSelection() != this.watchpoint.isHexadecimal()) {
                    this.setModified();
                    this.watchpoint.setHexadecimal(this.hexBtn.getSelection());
                }
                if (this.modified) {
                    this.watchpoint.getMarker().setAttribute("SKIP_EVENT", false);
                }
            }
            catch (CoreException coreException) {}
        } else {
            String s = this.varTxt.getText();
            if (s.length() > 0) {
                String varname = s;
                VcobolEditor ed = PluginUtilities.getActiveVcobolEditor();
                int lineNumber = -1;
                IStorage storage = null;
                try {
                    VarDecl vdecl;
                    TokenManager tm = new TokenManager(varname);
                    VarName vn = new VarName(tm);
                    IsFragment progFragment = ed.getProgramFragment();
                    if (progFragment != null && (vdecl = progFragment.getVarDecl(vn.getName())) != null) {
                        VarDecl[] duplVars = vdecl.getDuplicatesVars();
                        if (duplVars.length == 1) {
                            lineNumber = duplVars[0].getStartLine();
                        } else {
                            int i = 0;
                            while (i < duplVars.length && lineNumber < 0) {
                                boolean ok = true;
                                IsFragment p = duplVars[i].getParent();
                                int j = 0;
                                while (j < vn.getNAncestors() && ok) {
                                    if (p == null || !p.getName().equalsIgnoreCase(vn.getAncestor(j))) {
                                        ok = false;
                                    } else {
                                        p = p.getParent();
                                    }
                                    ++j;
                                }
                                if (ok) {
                                    lineNumber = p.getStartLine();
                                }
                                ++i;
                            }
                        }
                    }
                }
                catch (DebuggerParseException debuggerParseException) {
                    // empty catch block
                }
                if (lineNumber >= 0) {
                    storage = (IStorage)ed.getEditorInput().getAdapter(IResource.class);
                    if (storage == null) {
                        storage = (IStorage)ed.getEditorInput().getAdapter(IStorage.class);
                    }
                    try {
                        this.watchpoint = new VcobolWatchpoint(varname, this.hexBtn.getSelection(), this.enBtn.getSelection(), storage, lineNumber + 1, ed);
                    }
                    catch (CoreException coreException) {}
                } else {
                    PluginUtilities.logError((String)VresourceBundle.getString((String)"data_item_not_found_msg"));
                }
            }
        }
        super.okPressed();
    }

    private void setModified() throws CoreException {
        if (!this.modified) {
            this.watchpoint.getMarker().setAttribute("SKIP_EVENT", true);
        }
        this.modified = true;
    }

    public VcobolWatchpoint getWatchpoint() {
        return this.watchpoint;
    }

    public boolean isModified() {
        return this.modified;
    }
}

