/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.dialogs;

import com.vcobol.plugins.editor.VresourceBundle;
import com.vcobol.plugins.editor.util.PluginUtilities;
import java.util.StringTokenizer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RemoteCompilerConfigurationDialog
extends Dialog {
    private String host;
    private String port;
    private String preprocessorList;
    private boolean generateClass;
    private boolean generateError;
    private boolean generateListing;
    private Text hostTxt;
    private Text portTxt;
    private List ppList;
    private Button addBtn;
    private Button removeBtn;
    private Button removeAllBtn;
    private Button genClsBtn;
    private Button genErrBtn;
    private Button genLstBtn;
    private Button useAllPPBtn;
    private Button dontUsePPBtn;
    private Button ppListBtn;

    public RemoteCompilerConfigurationDialog(Shell parentShell, String host, String port, String preprocessorList, boolean generateClass, boolean generateError, boolean generateListing) {
        super(parentShell);
        this.host = host;
        if (this.host == null || this.host.length() == 0) {
            this.host = "localhost";
        }
        this.port = port;
        if (this.port == null || this.port.length() == 0) {
            this.port = "11999";
        }
        this.preprocessorList = preprocessorList;
        this.generateClass = generateClass;
        this.generateError = generateError;
        this.generateListing = generateListing;
    }

    protected Control createDialogArea(Composite parent) {
        Composite Return = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        Return.setLayout((Layout)gl);
        Group serverGrp = new Group(Return, 0);
        serverGrp.setText("Server");
        gl = new GridLayout();
        gl.numColumns = 2;
        serverGrp.setLayout((Layout)gl);
        GridData gd = new GridData(768);
        serverGrp.setLayoutData((Object)gd);
        Label l = new Label((Composite)serverGrp, 0);
        l.setText(String.valueOf(VresourceBundle.getString((String)"hostname_lbl")) + ":");
        this.hostTxt = new Text((Composite)serverGrp, 2048);
        gd = new GridData();
        gd.widthHint = 200;
        this.hostTxt.setLayoutData((Object)gd);
        l = new Label((Composite)serverGrp, 0);
        l.setText(String.valueOf(VresourceBundle.getString((String)"portnumber_lbl")) + ":");
        this.portTxt = new Text((Composite)serverGrp, 2048);
        gd = new GridData();
        gd.widthHint = 50;
        this.portTxt.setLayoutData((Object)gd);
        Group ppGrp = new Group(Return, 0);
        ppGrp.setText("PreProcessors");
        gl = new GridLayout();
        ppGrp.setLayout((Layout)gl);
        gd = new GridData(768);
        ppGrp.setLayoutData((Object)gd);
        this.useAllPPBtn = new Button((Composite)ppGrp, 16);
        this.useAllPPBtn.setText(VresourceBundle.getString((String)"use_all_pp_lbl"));
        this.dontUsePPBtn = new Button((Composite)ppGrp, 16);
        this.dontUsePPBtn.setText(VresourceBundle.getString((String)"dont_use_pp_lbl"));
        this.ppListBtn = new Button((Composite)ppGrp, 16);
        this.ppListBtn.setText(VresourceBundle.getString((String)"use_pp_list_lbl"));
        Composite ppListGrp = new Composite((Composite)ppGrp, 0);
        gd = new GridData(768);
        ppListGrp.setLayoutData((Object)gd);
        gl = new GridLayout();
        gl.numColumns = 2;
        ppListGrp.setLayout((Layout)gl);
        this.ppList = new List(ppListGrp, 2048);
        gd = new GridData(768);
        gd.heightHint = 150;
        this.ppList.setLayoutData((Object)gd);
        Composite buttonCmp = new Composite(ppListGrp, 0);
        gd = new GridData();
        gd.verticalAlignment = 128;
        buttonCmp.setLayoutData((Object)gd);
        buttonCmp.setLayout((Layout)new GridLayout());
        this.addBtn = new Button(buttonCmp, 8);
        this.addBtn.setText(VresourceBundle.getString((String)"add_lbl"));
        gd = new GridData(768);
        this.addBtn.setLayoutData((Object)gd);
        this.addBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.removeBtn = new Button(buttonCmp, 8);
        this.removeBtn.setText(VresourceBundle.getString((String)"remove_lbl"));
        this.removeBtn.setLayoutData((Object)gd);
        this.removeBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.removeAllBtn = new Button(buttonCmp, 8);
        this.removeAllBtn.setText(VresourceBundle.getString((String)"remove_all_lbl"));
        this.removeAllBtn.setLayoutData((Object)gd);
        this.removeAllBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Group optionGrp = new Group(Return, 0);
        optionGrp.setText("Options");
        gl = new GridLayout();
        optionGrp.setLayout((Layout)gl);
        gd = new GridData(768);
        optionGrp.setLayoutData((Object)gd);
        this.genClsBtn = new Button((Composite)optionGrp, 32);
        this.genClsBtn.setText(VresourceBundle.getString((String)"gen_cls_lbl"));
        gd = new GridData();
        this.genClsBtn.setLayoutData((Object)gd);
        this.genLstBtn = new Button((Composite)optionGrp, 32);
        this.genLstBtn.setText(VresourceBundle.getString((String)"gen_lst_lbl"));
        gd = new GridData();
        this.genLstBtn.setLayoutData((Object)gd);
        this.genErrBtn = new Button((Composite)optionGrp, 32);
        this.genErrBtn.setText(VresourceBundle.getString((String)"gen_err_lbl"));
        gd = new GridData();
        this.genErrBtn.setLayoutData((Object)gd);
        if (this.host != null) {
            this.hostTxt.setText(this.host);
        }
        if (this.port != null) {
            this.portTxt.setText(this.port);
        }
        this.genClsBtn.setSelection(this.generateClass);
        this.genLstBtn.setSelection(this.generateListing);
        this.genErrBtn.setSelection(this.generateError);
        if (this.preprocessorList != null) {
            StringTokenizer stn = new StringTokenizer(this.preprocessorList, ",");
            while (stn.hasMoreTokens()) {
                String tk = stn.nextToken();
                if (tk.equalsIgnoreCase("ALL")) {
                    this.setUseAllPP();
                    this.ppList.removeAll();
                    break;
                }
                if (tk.equalsIgnoreCase("NONE")) {
                    this.setDontUsePP();
                    this.ppList.removeAll();
                    break;
                }
                this.setUsePPList();
                this.ppList.add(tk);
            }
            if (!this.useAllPPBtn.getSelection() && !this.dontUsePPBtn.getSelection()) {
                this.ppListBtn.setSelection(true);
            }
        } else {
            this.setUseAllPP();
        }
        this.useAllPPBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.dontUsePPBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.ppListBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        return Return;
    }

    private void setUseAllPP() {
        this.useAllPPBtn.setSelection(true);
        this.dontUsePPBtn.setSelection(false);
        this.ppListBtn.setSelection(false);
        this.ppList.setEnabled(false);
        this.addBtn.setEnabled(false);
        this.removeBtn.setEnabled(false);
        this.removeAllBtn.setEnabled(false);
        this.genClsBtn.setEnabled(true);
    }

    private void setDontUsePP() {
        this.useAllPPBtn.setSelection(false);
        this.dontUsePPBtn.setSelection(true);
        this.ppListBtn.setSelection(false);
        this.ppList.setEnabled(false);
        this.addBtn.setEnabled(false);
        this.removeBtn.setEnabled(false);
        this.removeAllBtn.setEnabled(false);
        this.genClsBtn.setEnabled(false);
        this.genClsBtn.setSelection(true);
    }

    private void setUsePPList() {
        this.useAllPPBtn.setSelection(false);
        this.dontUsePPBtn.setSelection(false);
        this.ppListBtn.setSelection(true);
        this.ppList.setEnabled(true);
        this.addBtn.setEnabled(true);
        this.removeBtn.setEnabled(true);
        this.removeAllBtn.setEnabled(true);
        this.genClsBtn.setEnabled(true);
    }

    public void okPressed() {
        if (!PluginUtilities.validateHostName((String)this.hostTxt.getText())) {
            PluginUtilities.logError((String)VresourceBundle.getString((String)"invalid_host_msg"));
            return;
        }
        if (!PluginUtilities.validatePortNumber((String)this.portTxt.getText())) {
            PluginUtilities.logError((String)VresourceBundle.getString((String)"invalid_port_msg"));
            return;
        }
        if (this.ppListBtn.getSelection() && this.ppList.getItemCount() == 0) {
            PluginUtilities.logError((String)VresourceBundle.getString((String)"add_pp_msg"));
            return;
        }
        this.host = this.hostTxt.getText();
        this.port = this.portTxt.getText();
        this.generateClass = this.genClsBtn.getSelection();
        this.generateError = this.genErrBtn.getSelection();
        this.generateListing = this.genLstBtn.getSelection();
        if (this.useAllPPBtn.getSelection()) {
            this.preprocessorList = "ALL";
        } else if (this.dontUsePPBtn.getSelection()) {
            this.preprocessorList = "NONE";
        } else {
            this.preprocessorList = this.ppList.getItem(0);
            int i = 1;
            while (i < this.ppList.getItemCount()) {
                this.preprocessorList = String.valueOf(this.preprocessorList) + "," + this.ppList.getItem(i);
                ++i;
            }
        }
        super.okPressed();
    }

    public String getPreprocessorList() {
        return this.preprocessorList;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public boolean isGenerateClass() {
        return this.generateClass;
    }

    public boolean isGenerateError() {
        return this.generateError;
    }

    public boolean isGenerateListing() {
        return this.generateListing;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(VresourceBundle.getString((String)"rc_config_title"));
    }

    static /* synthetic */ List access$0(RemoteCompilerConfigurationDialog remoteCompilerConfigurationDialog) {
        return remoteCompilerConfigurationDialog.ppList;
    }

    static /* synthetic */ void access$1(RemoteCompilerConfigurationDialog remoteCompilerConfigurationDialog) {
        remoteCompilerConfigurationDialog.setUseAllPP();
    }

    static /* synthetic */ void access$2(RemoteCompilerConfigurationDialog remoteCompilerConfigurationDialog) {
        remoteCompilerConfigurationDialog.setDontUsePP();
    }

    static /* synthetic */ void access$3(RemoteCompilerConfigurationDialog remoteCompilerConfigurationDialog) {
        remoteCompilerConfigurationDialog.setUsePPList();
    }
}

