/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.launch;

import com.vcobol.plugins.editor.VcobolEditorPlugin;
import com.vcobol.plugins.editor.VresourceBundle;
import com.vcobol.plugins.editor.dialogs.ClasspathGroup;
import com.vcobol.plugins.editor.util.PluginUtilities;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ClasspathTab
extends AbstractLaunchConfigurationTab {
    Control control;
    private ClasspathGroup classpathGroup = new ClasspathGroup();
    private String libPath = PluginUtilities.getVcobolLibraryPath();

    public void initializeFrom(ILaunchConfiguration config) {
        try {
            String cp;
            IProject p;
            String defJar = config.getAttribute("vjar", null);
            if (defJar == null || defJar.length() == 0) {
                defJar = VcobolEditorPlugin.getDefault().getDefaultIscobolBuild();
            }
            String defCp = null;
            String projName = config.getAttribute("projectname", "");
            if (projName.length() > 0 && (p = ResourcesPlugin.getWorkspace().getRoot().getProject(projName)) != null && p.exists() && p.isOpen()) {
                defCp = PluginUtilities.getPersistentProperty((IResource)p, (String)"Default", (String)"vcobol.classpath");
            }
            if ((cp = config.getAttribute("classpath", null)) == null || cp.length() == 0) {
                cp = defCp;
            }
            this.classpathGroup.init(defJar, cp);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public String getMessage() {
        return VresourceBundle.getString((String)"configure_cp_msg");
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        if (this.control != null) {
            String jarAttr = this.classpathGroup.getVcobolJar();
            if (jarAttr.length() == 0) {
                jarAttr = this.libPath;
            }
            config.setAttribute("vjar", jarAttr);
            config.setAttribute("classpath", this.classpathGroup.getClasspath());
        }
    }

    public Control getControl() {
        return this.control;
    }

    public void createControl(Composite parent) {
        this.classpathGroup.setPropertyChangeListener((IPropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.control = this.classpathGroup.createControl(parent, null);
    }

    public String getName() {
        return VresourceBundle.getString((String)"classpath_lbl");
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setContainer(null);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        if (this.classpathGroup.getVcobolJar().length() > 0) {
            this.setErrorMessage(null);
        } else if (this.libPath.length() == 0) {
            this.setErrorMessage(String.valueOf(VresourceBundle.getString((String)"vcobol_library_lbl")) + " " + VresourceBundle.getString((String)"must_be_set_msg"));
            return false;
        }
        return true;
    }

    public boolean canSave() {
        return true;
    }

    static /* synthetic */ void access$0(ClasspathTab classpathTab) {
        classpathTab.updateLaunchConfigurationDialog();
    }
}

