/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.launch;

import com.vcobol.plugins.editor.VresourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RemoteConfTab
extends AbstractLaunchConfigurationTab {
    public static final String rcsid = "$Id: RemoteConfTab.java,v 1.2 2008/10/02 11:56:51 gianni Exp $";
    Text hostTxt;
    Text portTxt;
    Composite control;
    VerifyListener mlistener = new /* Unavailable Anonymous Inner Class!! */;

    public void initializeFrom(ILaunchConfiguration config) {
        try {
            String host = config.getAttribute("remotehost", "localhost");
            this.hostTxt.setText(host);
            int port = config.getAttribute("remoteport", 9999);
            this.portTxt.setText("" + port);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public String getMessage() {
        return VresourceBundle.getString((String)"configure_rc_msg");
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        if (this.hostTxt != null) {
            config.setAttribute("remotehost", this.hostTxt.getText());
            int port = 10999;
            try {
                port = Integer.parseInt(this.portTxt.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            config.setAttribute("remoteport", port);
            config.setAttribute("process_factory_id", "com.vcobol.plugins.processFactory");
        }
    }

    public Control getControl() {
        return this.control;
    }

    public void createControl(Composite parent) {
        Group gr = new Group(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gr.setLayout((Layout)gl);
        Label l1 = new Label((Composite)gr, 0);
        l1.setText(String.valueOf(VresourceBundle.getString((String)"host_lbl")) + ":");
        this.hostTxt = new Text((Composite)gr, 2048);
        GridData gd = new GridData(768);
        this.hostTxt.setLayoutData((Object)gd);
        this.hostTxt.addVerifyListener(this.mlistener);
        Label l2 = new Label((Composite)gr, 0);
        l2.setText(String.valueOf(VresourceBundle.getString((String)"port_lbl")) + ":");
        this.portTxt = new Text((Composite)gr, 2048);
        gd = new GridData(768);
        this.portTxt.setLayoutData((Object)gd);
        this.portTxt.addVerifyListener(this.mlistener);
        this.control = gr;
    }

    public String getName() {
        return VresourceBundle.getString((String)"connect_lbl");
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setContainer(null);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        if (this.hostTxt.getText().length() == 0) {
            this.setErrorMessage(String.valueOf(VresourceBundle.getString((String)"host_lbl")) + " " + VresourceBundle.getString((String)"must_be_set_msg"));
            return false;
        }
        if (this.portTxt.getText().length() == 0) {
            this.setErrorMessage(String.valueOf(VresourceBundle.getString((String)"port_lbl")) + " " + VresourceBundle.getString((String)"must_be_set_msg"));
            return false;
        }
        try {
            Integer.parseInt(this.portTxt.getText());
        }
        catch (NumberFormatException ex) {
            this.setErrorMessage(String.valueOf(VresourceBundle.getString((String)"invalid_value_msg")) + " " + VresourceBundle.getString((String)"port_lbl"));
            return false;
        }
        return true;
    }

    public boolean canSave() {
        return true;
    }

    static /* synthetic */ void access$0(RemoteConfTab remoteConfTab) {
        remoteConfTab.updateLaunchConfigurationDialog();
    }
}

