/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.launch;

import com.vcobol.plugins.editor.VresourceBundle;
import com.vcobol.plugins.editor.dialogs.RunGroup;
import com.vcobol.plugins.editor.util.PluginUtilities;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class RunTab
extends AbstractLaunchConfigurationTab {
    public static final String rcsid = "$Id: RunTab.java,v 1.5 2009/03/09 11:17:22 gianni Exp $";
    private Combo projectCmb;
    private Combo prognameCmb;
    Composite control;
    IProject[] projects;
    ModifyListener mlistener = new /* Unavailable Anonymous Inner Class!! */;
    private RunGroup runGroup = new RunGroup();

    public void initializeFrom(ILaunchConfiguration config) {
        try {
            String projName = config.getAttribute("projectname", "");
            int idx = this.projectCmb.indexOf(projName);
            if (idx >= 0) {
                this.projectCmb.select(idx);
                this.responseOnAction();
            } else {
                this.projectCmb.setText(projName);
            }
            this.prognameCmb.setText(config.getAttribute("progname", ""));
            this.runGroup.init(config.getAttribute("systemprops", ""), config.getAttribute("arguments", ""), config.getAttribute("workdir", ""), null);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public String getMessage() {
        return VresourceBundle.getString((String)"run_prog_msg");
    }

    public void createControl(Composite parent) {
        Composite gr = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gr.setLayout((Layout)gl);
        Label l1 = new Label(gr, 0);
        l1.setText(String.valueOf(VresourceBundle.getString((String)"project_lbl")) + ":");
        this.projectCmb = new Combo(gr, 0);
        GridData gd = new GridData(768);
        this.projectCmb.setLayoutData((Object)gd);
        this.projectCmb.addModifyListener(this.mlistener);
        this.projectCmb.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        Vector<IProject> vect = new Vector<IProject>();
        String nId = "com.vcobol.plugins.editor.VcobolEditor.VcobolNature";
        try {
            int i = 0;
            while (i < this.projects.length) {
                if (this.projects[i].isOpen() && this.projects[i].getNature(nId) != null) {
                    this.projectCmb.add(this.projects[i].getName());
                    vect.addElement(this.projects[i]);
                }
                ++i;
            }
            int n = vect.size();
            if (n < this.projects.length) {
                this.projects = new IProject[n];
                vect.toArray(this.projects);
            }
        }
        catch (CoreException n) {
            // empty catch block
        }
        Label l2 = new Label(gr, 0);
        l2.setText(String.valueOf(VresourceBundle.getString((String)"progname_lbl")) + ":");
        this.prognameCmb = new Combo(gr, 0);
        gd = new GridData(768);
        this.prognameCmb.setLayoutData((Object)gd);
        this.prognameCmb.addModifyListener(this.mlistener);
        this.prognameCmb.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.runGroup.setPropertyChangeListener((IPropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.runGroup.createControl(parent, gr);
        this.control = gr;
    }

    private void responseOnAction() {
        int selIdx = this.projectCmb.getSelectionIndex();
        this.prognameCmb.removeAll();
        try {
            String od = PluginUtilities.getPersistentProperty((IResource)this.projects[selIdx], (String)PluginUtilities.getCurrentSettingMode((IResource)this.projects[selIdx]), (String)"-od=");
            if (od == null || od.equals("___vcobol.option.false")) {
                od = "";
            }
            this.loadPrognameCombo(this.projects[selIdx], od);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private void loadPrognameCombo(IProject project, String od) throws CoreException {
        String srcDir = PluginUtilities.getPersistentProperty((IResource)project, (String)"Default", (String)"sourcedir");
        IContainer sf = PluginUtilities.getSourceFolder((IProject)project, (String)srcDir);
        this.loadPrognameCombo(sf, od);
    }

    private void loadPrognameCombo(IContainer sf, String od) throws CoreException {
        IResource[] members = sf.members();
        int i = 0;
        while (i < members.length) {
            switch (members[i].getType()) {
                case 1: {
                    String className = PluginUtilities.getResourcePersistentProperty((IResource)members[i], (String)"classFile");
                    if (className == null) break;
                    className = className.substring(0, className.length() - 6).replace('/', '.');
                    String currMode = PluginUtilities.getCurrentSettingMode((IResource)members[i]);
                    String outDir = null;
                    if (currMode != null) {
                        outDir = PluginUtilities.getPersistentProperty((IResource)members[i], (String)currMode, (String)"-od=");
                    }
                    if (outDir == null || outDir.equals("___vcobol.option.false")) {
                        outDir = od;
                    }
                    this.prognameCmb.add(className);
                    outDir = PluginUtilities.getAbsolutePath((IProject)sf.getProject(), (String)outDir);
                    this.prognameCmb.setData(className, (Object)outDir);
                    break;
                }
                case 2: 
                case 4: {
                    this.loadPrognameCombo((IContainer)members[i], od);
                }
            }
            ++i;
        }
    }

    public Control getControl() {
        return this.control;
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        if (this.prognameCmb != null) {
            config.setAttribute("projectname", this.projectCmb.getText());
            if (this.prognameCmb.getText().length() > 0) {
                config.setAttribute("progname", this.prognameCmb.getText());
                Object outDir = this.prognameCmb.getData(this.prognameCmb.getText());
                if (outDir != null) {
                    config.setAttribute("outdir", outDir.toString());
                }
            }
            config.setAttribute("systemprops", this.runGroup.getSystemProperties());
            config.setAttribute("arguments", this.runGroup.getArguments());
            config.setAttribute("workdir", this.runGroup.getWorkingDirectory());
            config.setAttribute("process_factory_id", "com.vcobol.plugins.processFactory");
        }
    }

    public String getName() {
        return VresourceBundle.getString((String)"run_lbl");
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setContainer(null);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return true;
    }

    public boolean canSave() {
        return true;
    }

    static /* synthetic */ void access$0(RunTab runTab) {
        runTab.updateLaunchConfigurationDialog();
    }

    static /* synthetic */ void access$1(RunTab runTab) {
        runTab.responseOnAction();
    }
}

