/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.launch;

import com.vcobol.plugins.editor.VresourceBundle;
import com.vcobol.plugins.editor.debug.VcobolDebugTarget;
import com.vcobol.plugins.editor.util.PluginUtilities;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PlatformUI;

/*
 * Exception performing whole class analysis ignored.
 */
public class VcobolLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    public static final String ID = "VcobolConfigurationType";
    public static final String PROJECTNAME_ATTR = "projectname";
    public static final String PROGNAME_ATTR = "progname";
    public static final String VCOBOL_JAR_ATTR = "vjar";
    public static final String CLASSPATH_ATTR = "classpath";
    public static final String ENV_VAR_ATTR = "envvar";
    public static final String APPEND_ENV_ATTR = "appendenv";
    public static final String SYSTEM_PROP_ATTR = "systemprops";
    public static final String ARGUMENTS_ATTR = "arguments";
    public static final String WORKDIR_ATTR = "workdir";
    public static final String OUTDIR_ATTR = "outdir";
    public static final String REMOTE_HOST_ATTR = "remotehost";
    public static final String REMOTE_PORT_ATTR = "remoteport";

    public void launch(ILaunchConfiguration conf, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        int timeout = 0;
        if (mode.equalsIgnoreCase("run")) {
            VcobolLaunchConfigurationDelegate.doExecute((ILaunchConfiguration)conf, (ILaunch)launch, (boolean)false);
        } else if (mode.equalsIgnoreCase("debug")) {
            if (VcobolDebugTarget.getDefault() != null) {
                int[] ret = new int[1];
                new /* Unavailable Anonymous Inner Class!! */.start();
                if (ret[0] == 32) {
                    VcobolDebugTarget.getDefault().terminate();
                    timeout = 500;
                } else {
                    VcobolLaunchConfigurationDelegate.terminateLaunch((ILaunch)launch);
                    return;
                }
            }
            if (timeout > 0) {
                try {
                    Thread.sleep(timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (conf.getAttribute("remotehost", null) != null) {
                this.remoteDebug(conf, launch);
            } else {
                VcobolLaunchConfigurationDelegate.doExecute((ILaunchConfiguration)conf, (ILaunch)launch, (boolean)true);
            }
        }
    }

    private void remoteDebug(ILaunchConfiguration conf, ILaunch l) {
        try {
            String host = conf.getAttribute("remotehost", "localhost");
            int port = conf.getAttribute("remoteport", 9999);
            VcobolDebugTarget dtarget = new VcobolDebugTarget(conf.getName(), null, null, host, port, l);
            l.addDebugTarget((IDebugTarget)dtarget);
        }
        catch (Exception ex) {
            PluginUtilities.log((Throwable)ex);
        }
    }

    public static void doExecute(ILaunchConfiguration conf, ILaunch l, boolean debug) {
        String progName = null;
        try {
            String projectName = conf.getAttribute("projectname", null);
            if (projectName == null) {
                VcobolLaunchConfigurationDelegate.terminateLaunch((ILaunch)l);
                return;
            }
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (project == null || !project.exists() || !project.isOpen()) {
                VcobolLaunchConfigurationDelegate.terminateLaunch((ILaunch)l);
                return;
            }
            progName = conf.getAttribute("progname", null);
            if (progName == null) {
                VcobolLaunchConfigurationDelegate.terminateLaunch((ILaunch)l);
                return;
            }
            String path = PluginUtilities.getPersistentProperty((IResource)project, (String)PluginUtilities.getCurrentSettingMode((IResource)project), (String)"-od=");
            Object rootOutDir = path == null || path.equals("___vcobol.option.false") || path.length() == 0 || path.equals("/") ? project : project.getFolder(path);
            String isjar = conf.getAttribute("vjar", null);
            if (isjar == null || isjar.length() == 0) {
                isjar = PluginUtilities.getVcobolLibraryPath();
            }
            String cpAttr = conf.getAttribute("classpath", null);
            StringBuffer classpath = new StringBuffer(".");
            Vector v = VcobolLaunchConfigurationDelegate.getOutDirs((IContainer)rootOutDir);
            String wrkdir = VcobolLaunchConfigurationDelegate.getAbsolutePath((String)conf.getAttribute("workdir", ""), (IProject)project);
            String od = VcobolLaunchConfigurationDelegate.getAbsolutePath((String)conf.getAttribute("outdir", rootOutDir.getLocation().toOSString()), (IProject)project);
            IContainer[] outDirs = new IContainer[v.size()];
            v.toArray(outDirs);
            VcobolLaunchConfigurationDelegate.appendOutDirs((IContainer[])outDirs, (StringBuffer)classpath);
            IFolder resFolder = PluginUtilities.getResourcesFolder((IProject)project);
            if (resFolder != null && resFolder.getLocation() != null) {
                classpath.append(File.pathSeparator).append(resFolder.getLocation().toString());
            }
            if (cpAttr != null) {
                classpath.append(File.pathSeparator).append(cpAttr);
            }
            if (isjar != null && isjar.length() > 0) {
                classpath.append(File.pathSeparator).append(isjar);
            }
            URL[] urls = VcobolLaunchConfigurationDelegate.convertToURLs((IContainer[])outDirs, (String)isjar, (String)cpAttr, (String)od);
            Class<?> c = Class.forName(progName, false, new URLClassLoader(urls));
            if (debug && !VcobolLaunchConfigurationDelegate.isVcobolDebugger(c)) {
                VcobolLaunchConfigurationDelegate.handleError((ILaunch)l, (String)progName, (String)VresourceBundle.getString((String)"debug_info_not_found_msg"), null);
                return;
            }
            StringTokenizer props = new StringTokenizer(conf.getAttribute("systemprops", ""));
            StringTokenizer args = new StringTokenizer(conf.getAttribute("arguments", ""));
            ArrayList<String> runArgs = new ArrayList<String>();
            String javaHome = System.getProperty("java.home", null);
            if (javaHome != null) {
                runArgs.add(String.valueOf(javaHome) + "/bin/java");
            } else {
                runArgs.add("java");
            }
            runArgs.add("-cp");
            runArgs.add(classpath.toString());
            runArgs.add("-Dvcobol.runtime.native.ignore_errors=true");
            int debugPort = 0;
            if (debug) {
                debugPort = VcobolLaunchConfigurationDelegate.getFreePort(null);
                runArgs.add("-Dvcobol.rundebug=2");
                runArgs.add("-Dvcobol.debug.port=" + Integer.toString(debugPort));
            }
            while (props.hasMoreTokens()) {
                runArgs.add(props.nextToken());
            }
            runArgs.add("com.veryant.vcobol.invoke.Invoke");
            runArgs.add(progName);
            while (args.hasMoreTokens()) {
                runArgs.add(args.nextToken());
            }
            Process p = null;
            String[] env = VcobolLaunchConfigurationDelegate.getEnv((ILaunchConfiguration)conf);
            String[] ARGS = new String[runArgs.size()];
            runArgs.toArray(ARGS);
            File wrkDirPath = wrkdir != null ? new File(wrkdir) : null;
            p = env != null ? DebugPlugin.exec((String[])ARGS, (File)wrkDirPath, (String[])env) : DebugPlugin.exec((String[])ARGS, (File)wrkDirPath);
            IProcess process = DebugPlugin.newProcess((ILaunch)l, (Process)p, (String)progName);
            if (debug) {
                VcobolDebugTarget dtarget = new VcobolDebugTarget(progName, project, process, "localhost", debugPort, l);
                l.addDebugTarget((IDebugTarget)dtarget);
            } else {
                l.addProcess(process);
            }
        }
        catch (CoreException ex) {
            VcobolLaunchConfigurationDelegate.handleError((ILaunch)l, progName, (String)ex.getMessage(), (Throwable)ex);
        }
        catch (IOException ex) {
            VcobolLaunchConfigurationDelegate.handleError((ILaunch)l, progName, (String)ex.getMessage(), (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            VcobolLaunchConfigurationDelegate.handleError((ILaunch)l, progName, (String)("Class '" + progName + "' " + VresourceBundle.getString((String)"check_comp_opt_msg")), (Throwable)ex);
        }
    }

    private static void handleError(ILaunch l, String text, String msg, Throwable t) {
        Display.getDefault().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private static void handleError0(ILaunch l, String text, String msg, Throwable t) {
        if (text != null && msg != null) {
            MessageBox mbox = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 33);
            mbox.setText(text);
            mbox.setMessage(msg);
            mbox.open();
        }
        if (t != null) {
            if (msg != null) {
                PluginUtilities.log((String)msg, (Throwable)t);
            } else {
                PluginUtilities.log((Throwable)t);
            }
        }
        VcobolLaunchConfigurationDelegate.terminateLaunch((ILaunch)l);
    }

    private static String[] getEnv(ILaunchConfiguration conf) throws CoreException {
        String[] Env;
        ArrayList list = conf.getAttribute("envvar", null);
        String vcobolpath = Platform.getOS().equals("win32") ? (Platform.getOSArch().equals("x86") ? "path=" + PluginUtilities.getVcobolNativePath() + "/win_x86_32;%path%" : "path=" + PluginUtilities.getVcobolNativePath() + "/win_x86_64;%path%") : (Platform.getOSArch().equals("x86") ? "LD_LIBRARY_PATH=" + PluginUtilities.getVcobolNativePath() + "/linux_x86_32:$LD_LIBRARY_PATH" : "LD_LIBRARY_PATH=" + PluginUtilities.getVcobolNativePath() + "/linux_x86_64:$LD_LIBRARY_PATH");
        boolean append = conf.getAttribute("appendenv", true);
        if (list == null) {
            list = new ArrayList();
        }
        if (list.isEmpty()) {
            append = true;
        }
        int i = 0;
        if (append) {
            Map<String, String> nativeEnv = System.getenv();
            Env = new String[nativeEnv.values().size() + list.size() + 1];
            for (String k : nativeEnv.keySet()) {
                Env[i++] = k + "=" + nativeEnv.get(k);
            }
        } else {
            Env = new String[list.size() + 1];
        }
        ListIterator li = list.listIterator();
        while (li.hasNext()) {
            Env[i++] = li.next().toString();
        }
        Env[Env.length - 1] = vcobolpath;
        return Env;
    }

    private static void terminateLaunch(ILaunch l) {
        try {
            l.terminate();
        }
        catch (DebugException ex) {
            PluginUtilities.log((Throwable)ex);
        }
        DebugPlugin.getDefault().getLaunchManager().removeLaunch(l);
    }

    private static String getAbsolutePath(String relativePath, IProject project) {
        File relPath = new File(relativePath);
        if (relPath.isAbsolute()) {
            if (new File(relativePath).exists()) {
                return relativePath;
            }
            return null;
        }
        IResource res = PluginUtilities.findMember((IContainer)project, (IPath)new Path(relativePath = relativePath.replace('\\', '/')));
        if (res instanceof IFolder) {
            return res.getLocation().toFile().getAbsolutePath();
        }
        return null;
    }

    private static void appendOutDirs(IContainer[] folders, StringBuffer buf) throws CoreException {
        int i = 0;
        while (i < folders.length) {
            buf.append(File.pathSeparator);
            buf.append(folders[i].getLocation().toOSString());
            ++i;
        }
    }

    private static URL[] convertToURLs(IContainer[] folders, String isjar, String cp, String od) throws IOException {
        int len = folders.length;
        StringTokenizer jarStn = null;
        if (isjar != null) {
            jarStn = new StringTokenizer(isjar, File.pathSeparator);
            len += jarStn.countTokens();
        }
        if (od != null) {
            ++len;
        }
        StringTokenizer st = null;
        if (cp != null) {
            st = new StringTokenizer(cp, File.pathSeparator);
            len += st.countTokens();
        }
        URL[] Return = new URL[len];
        int i = 0;
        while (i < folders.length) {
            String p = folders[i].getLocation().toOSString();
            Return[i] = new File(p).toURI().toURL();
            ++i;
        }
        if (jarStn != null) {
            while (jarStn.hasMoreTokens()) {
                Return[i++] = new File(jarStn.nextToken()).toURI().toURL();
            }
        }
        if (cp != null) {
            while (st.hasMoreTokens()) {
                Return[i++] = new File(st.nextToken()).toURI().toURL();
            }
        }
        if (od != null) {
            Return[i++] = new File(od).toURI().toURL();
        }
        return Return;
    }

    private static Vector getOutDirs(IContainer folder) throws CoreException, IOException {
        Vector<IContainer> Return = new Vector<IContainer>();
        Return.add(folder);
        IResource[] members = folder.members();
        int i = 0;
        while (i < members.length) {
            if (members[i].getType() == 2) {
                Return.addAll(VcobolLaunchConfigurationDelegate.getOutDirs((IContainer)((IFolder)members[i])));
            }
            ++i;
        }
        return Return;
    }

    private static boolean isVcobolDebugger(Class c) {
        Class<?>[] ints = c.getInterfaces();
        int i = 0;
        while (i < ints.length) {
            if (ints[i].getName().equals("com.veryant.vcobol.debug.Debuggable")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private static int getFreePort(int[] usedPorts) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 26 out of bounds for length 26
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ExceptionRewriters.getLinearScannedBlock(ExceptionRewriters.java:543)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ExceptionRewriters.getSingleTryCatch(ExceptionRewriters.java:414)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ExceptionRewriters.extractExceptionMiddle(ExceptionRewriters.java:327)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.extractExceptionMiddle(Op03Rewriters.java:181)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:798)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static /* synthetic */ void access$0(ILaunch iLaunch, String string, String string2, Throwable throwable) {
        VcobolLaunchConfigurationDelegate.handleError0((ILaunch)iLaunch, (String)string, (String)string2, (Throwable)throwable);
    }
}

