/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.launch.externaltools;

import com.vcobol.plugins.editor.launch.externaltools.RemoteCompilerManager;
import com.vcobol.plugins.editor.util.PluginUtilities;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.IProcess;

public class VcobolToolsLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    public static final String ID = "vCOBOLToolsConfigurationType";
    public static final String MODE = "externaltools";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
    }

    public void launchRemoteCompiler(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String confFile = RemoteCompilerManager.getRemoteCompilerConfigurationFile();
        ArrayList<String> args = new ArrayList<String>();
        args.add(String.valueOf(System.getProperty("java.home", "java")) + File.separator + "bin" + File.separator + "java");
        args.add("-cp");
        String libraryPath = PluginUtilities.getVcobolLibraryPath();
        args.add(libraryPath);
        args.add("-Dvcobol.remotecompiler.conf=" + confFile);
        args.add("com.veryant.vcobol.compiler.remote.server.Server");
        HashMap<String, String> env = new HashMap<String, String>();
        env.putAll(System.getenv());
        boolean cpFound = false;
        for (String key : env.keySet()) {
            if (!key.equalsIgnoreCase("classpath")) continue;
            String value = (String)env.get(key);
            value = String.valueOf(value) + File.pathSeparator + libraryPath;
            env.put(key, value);
            cpFound = true;
            break;
        }
        if (!cpFound) {
            env.put("CLASSPATH", libraryPath);
        }
        String[] envStr = new String[env.size()];
        int i = 0;
        for (String key : env.keySet()) {
            envStr[i++] = String.valueOf(key) + "=" + (String)env.get(key);
        }
        try {
            Process p = DebugPlugin.exec((String[])args.toArray(new String[args.size()]), null, (String[])envStr);
            IProcess iproc = DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)"Remote Compiler");
            launch.addProcess(iproc);
            DebugPlugin.getDefault().getLaunchManager().addLaunch(launch);
        }
        catch (CoreException e) {
            PluginUtilities.log((Throwable)e);
        }
    }

    public void launchIsMigrate(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        ArrayList<String> args = new ArrayList<String>();
        args.add(String.valueOf(System.getProperty("java.home", "java")) + File.separator + "bin" + File.separator + "java");
        args.add("-cp");
        args.add(PluginUtilities.getVcobolLibraryPath());
        args.add("ISMIGRATE");
        try {
            Process p = DebugPlugin.exec((String[])args.toArray(new String[args.size()]), null);
            IProcess iproc = DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)"ISMIGRATE");
            launch.addProcess(iproc);
            DebugPlugin.getDefault().getLaunchManager().addLaunch(launch);
        }
        catch (CoreException e) {
            PluginUtilities.log((Throwable)e);
        }
    }

    public void launchGife(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        ArrayList<String> args = new ArrayList<String>();
        args.add(String.valueOf(System.getProperty("java.home", "java")) + File.separator + "bin" + File.separator + "java");
        args.add("-cp");
        args.add(PluginUtilities.getVcobolLibraryPath());
        args.add("GIFE");
        try {
            Process p = DebugPlugin.exec((String[])args.toArray(new String[args.size()]), null);
            IProcess iproc = DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)"GIFE");
            launch.addProcess(iproc);
            DebugPlugin.getDefault().getLaunchManager().addLaunch(launch);
        }
        catch (CoreException e) {
            PluginUtilities.log((Throwable)e);
        }
    }
}

