/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.license;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class LicenseUtils {
    public static final String LIBRARIES_PLUGIN_ID = "com.vcobol.plugins.libraries";
    public static final String VCOBOL_LICENSE_PROP = "vcobol.license.2011";
    public static final String VCOBOL_COMPILER_LICENSE_PROP = "vcobol.compiler.license.2011";

    public static void updateLicense(Shell shell, String licenseKey, String prop, boolean preserveOldLicenseKey) {
        try {
            MessageDialog md;
            int ret;
            File inFile = new File(String.valueOf(System.getProperty("user.home", ".")) + "/vcobol.properties");
            StringWriter strWriter = new StringWriter();
            PrintWriter out = new PrintWriter(strWriter);
            BufferedReader in = null;
            try {
                in = new BufferedReader(new InputStreamReader(new FileInputStream(inFile)));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            boolean found = false;
            if (in != null) {
                String line = in.readLine();
                while (line != null) {
                    if (line.trim().startsWith(prop)) {
                        if (preserveOldLicenseKey) {
                            out.println("# old license key");
                            out.println("# " + line);
                        }
                        out.println(String.valueOf(prop) + "=" + licenseKey);
                        found = true;
                    } else {
                        out.println(line);
                    }
                    line = in.readLine();
                }
            }
            if (!found) {
                out.println(String.valueOf(prop) + "=" + licenseKey);
            }
            if (in != null) {
                in.close();
            }
            out.close();
            out = new PrintWriter(inFile);
            out.print(strWriter.toString());
            out.close();
            if (shell != null && (ret = (md = new MessageDialog(shell, shell.getText(), shell.getImage(), "License Updated. You should restart the application to activate the license", 2, new String[]{"Restart", "Continue"}, 1)).open()) == 0) {
                PlatformUI.getWorkbench().restart();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

