/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.license;

import com.vcobol.plugins.editor.VcobolEditorPlugin;
import com.vcobol.plugins.editor.license.LicenseController;
import com.vcobol.plugins.editor.license.MissingLicenseException;
import com.vcobol.plugins.editor.license.StatusBar;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.menus.AbstractWorkbenchTrimWidget;

public class StatusBar
extends AbstractWorkbenchTrimWidget {
    private static final int MISSING = 0;
    private static final int TRIAL = 1;
    private static final int DEFINITIVE = 2;
    private static final RGB GREEN = new RGB(128, 215, 40);
    private static final RGB ORANGE = new RGB(242, 180, 13);
    private static final RGB RED = new RGB(183, 89, 72);
    private Composite composite;
    private Label statusLabel;
    private String statusString = "Click for license status";
    private Image backgroundImage;

    public void init(IWorkbenchWindow workbenchWindow) {
    }

    public void dispose() {
        if (this.composite != null && !this.composite.isDisposed()) {
            this.composite.dispose();
        }
        if (this.backgroundImage != null) {
            this.backgroundImage.dispose();
            this.backgroundImage = null;
        }
        this.composite = null;
    }

    public void fill(Composite parent, int oldSide, int newSide) {
        this.composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 4;
        layout.marginWidth = 2;
        this.composite.setLayout((Layout)layout);
        Label badge = new Label(this.composite, 0x1000000);
        badge.setToolTipText("Click for license status");
        badge.setImage(VcobolEditorPlugin.getDefault().getImageProvider().getImage("/vcobol16x16.png"));
        1 mouseListener = new /* Unavailable Anonymous Inner Class!! */;
        badge.addMouseListener((MouseListener)mouseListener);
        this.statusLabel = new Label(this.composite, 2048);
        GridData gd = new GridData();
        gd.widthHint = 200;
        this.statusLabel.setLayoutData((Object)gd);
        this.statusLabel.setForeground(this.statusLabel.getDisplay().getSystemColor(2));
        this.statusLabel.setText(this.statusString);
        this.statusLabel.addMouseListener((MouseListener)mouseListener);
        this.composite.layout();
        this.update();
    }

    private void update() {
        String license;
        int vcobolCompilerLicStatus = 0;
        int vcobolLicStatus = 0;
        try {
            license = LicenseController.licinfo2();
            vcobolCompilerLicStatus = LicenseController.isPermanent((String)license) ? 2 : 1;
        }
        catch (MissingLicenseException missingLicenseException) {
            // empty catch block
        }
        if (vcobolCompilerLicStatus != 0) {
            try {
                license = LicenseController.licinfo1();
                vcobolLicStatus = LicenseController.isPermanent((String)license) ? 2 : 1;
            }
            catch (MissingLicenseException missingLicenseException) {
                // empty catch block
            }
        }
        if (vcobolCompilerLicStatus == 2 && vcobolLicStatus == 2) {
            this.composite.setVisible(false);
        } else {
            this.composite.setVisible(true);
            this.statusLabel.setBackgroundImage(this.getBackgroundImage(Math.min(vcobolCompilerLicStatus, vcobolLicStatus)));
        }
    }

    private Image getBackgroundImage(int vcobolLicStatus) {
        RGB back;
        if (this.backgroundImage != null) {
            this.backgroundImage.dispose();
        }
        Rectangle rect = this.statusLabel.getBounds();
        Display display = this.statusLabel.getDisplay();
        this.backgroundImage = new Image((Device)display, rect.width, rect.height);
        GC gc = new GC((Drawable)this.backgroundImage);
        switch (vcobolLicStatus) {
            default: {
                back = GREEN;
                break;
            }
            case 1: {
                back = ORANGE;
                break;
            }
            case 0: {
                back = RED;
            }
        }
        gc.setBackground(VcobolEditorPlugin.getDefault().getColorProvider().getColor(back));
        gc.fillRectangle(0, 0, rect.width, rect.height);
        gc.dispose();
        return this.backgroundImage;
    }
}

