/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.preferences;

import com.vcobol.plugins.editor.VcobolEditorPlugin;
import com.vcobol.plugins.editor.VresourceBundle;
import java.util.StringTokenizer;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class EditorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String rcsid = "$Id: EditorPreferencePage.java,v 1.3 2008/07/04 14:45:20 gianni Exp $";
    private BooleanFieldEditor foldingFE;
    private BooleanFieldEditor reconcilingFE;
    private BooleanFieldEditor showTooltipMouseHiverFE;
    private BooleanFieldEditor insertSpacesFE;
    private BooleanFieldEditor showHRuler;
    private StringFieldEditor tabWidthFE;
    private Combo sourceFormatCmb;
    private Text newTabTxt;
    private List tabList;
    private static int MAX_TAB_STOP = 317;
    private Button addTabBtn;
    private Button deleteTabBtn;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        composite.setLayout((Layout)gl);
        Composite lnkGroup = new Composite(composite, 0);
        TableWrapLayout twl = new TableWrapLayout();
        lnkGroup.setLayout((Layout)twl);
        FormText ft = new FormText(lnkGroup, 0);
        TableWrapData twd = new TableWrapData(128);
        twd.colspan = 1;
        ft.setLayoutData((Object)twd);
        ft.setText(VresourceBundle.getString((String)"text_editor_lnk"), true, false);
        ft.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        Group tabGrp = new Group(composite, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        tabGrp.setLayoutData((Object)gd);
        gl = new GridLayout();
        tabGrp.setLayout((Layout)gl);
        tabGrp.setText("Tabs");
        Composite comp = new Composite((Composite)tabGrp, 0);
        this.tabWidthFE = new StringFieldEditor("vcobol.tabwidth", VresourceBundle.getString((String)"tab_width_lbl"), comp);
        this.tabWidthFE.setPage((DialogPage)this);
        this.tabWidthFE.setPreferenceStore(this.getPreferenceStore());
        this.tabWidthFE.load();
        gd = new GridData();
        gd.widthHint = 200;
        comp.setLayoutData((Object)gd);
        comp = new Composite((Composite)tabGrp, 0);
        this.insertSpacesFE = new BooleanFieldEditor("vcobol.insertspaces", VresourceBundle.getString((String)"insert_spaces_lbl"), comp);
        this.insertSpacesFE.setPage((DialogPage)this);
        this.insertSpacesFE.setPreferenceStore(this.getPreferenceStore());
        this.insertSpacesFE.load();
        Composite sourceFormatCmp = new Composite((Composite)tabGrp, 0);
        gl = new GridLayout();
        gl.numColumns = 2;
        sourceFormatCmp.setLayout((Layout)gl);
        Label l = new Label(sourceFormatCmp, 0);
        l.setText(VresourceBundle.getString((String)"src_format_lbl"));
        this.sourceFormatCmb = new Combo(sourceFormatCmp, 2056);
        this.sourceFormatCmb.add("ANSI");
        this.sourceFormatCmb.add("Terminal");
        this.sourceFormatCmb.select(0);
        this.sourceFormatCmb.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite addTabCmp = new Composite((Composite)tabGrp, 0);
        gl = new GridLayout();
        gl.numColumns = 2;
        addTabCmp.setLayout((Layout)gl);
        gd = new GridData(1808);
        addTabCmp.setLayoutData((Object)gd);
        this.newTabTxt = new Text(addTabCmp, 2048);
        gd = new GridData();
        gd.widthHint = 50;
        gd.horizontalAlignment = 131072;
        this.newTabTxt.setLayoutData((Object)gd);
        this.newTabTxt.addVerifyListener((VerifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addTabBtn = new Button(addTabCmp, 8);
        this.addTabBtn.setText("Add");
        this.addTabBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.tabList = new List(addTabCmp, 2564);
        gd = new GridData();
        gd.heightHint = 150;
        gd.widthHint = 50;
        this.tabList.setLayoutData((Object)gd);
        this.loadProp("vcobol.tabs.ansi");
        this.loadProp("vcobol.tabs.terminal");
        this.loadList();
        this.deleteTabBtn = new Button(addTabCmp, 8);
        this.deleteTabBtn.setText("Delete");
        this.deleteTabBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        gd = new GridData();
        gd.verticalAlignment = 128;
        this.deleteTabBtn.setLayoutData((Object)gd);
        Group miscGrp = new Group(composite, 0);
        miscGrp.setText("Miscellaneous");
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        miscGrp.setLayoutData((Object)gd);
        miscGrp.setLayout((Layout)new GridLayout());
        comp = new Composite((Composite)miscGrp, 0);
        this.foldingFE = new BooleanFieldEditor("vcobol.folding.enabled", VresourceBundle.getString((String)"en_folding_lbl"), comp);
        this.foldingFE.setPage((DialogPage)this);
        this.foldingFE.setPreferenceStore(this.getPreferenceStore());
        this.foldingFE.load();
        comp = new Composite((Composite)miscGrp, 0);
        this.reconcilingFE = new BooleanFieldEditor("vcobol.reconciling.enabled", VresourceBundle.getString((String)"en_reconc_lbl"), comp);
        this.reconcilingFE.setPage((DialogPage)this);
        this.reconcilingFE.setPreferenceStore(this.getPreferenceStore());
        this.reconcilingFE.load();
        comp = new Composite((Composite)miscGrp, 0);
        this.showTooltipMouseHiverFE = new BooleanFieldEditor("vcobol.showtooltipmousehover.enabled", VresourceBundle.getString((String)"show_tooltip_mh_lbl"), comp);
        this.showTooltipMouseHiverFE.setPage((DialogPage)this);
        this.showTooltipMouseHiverFE.setPreferenceStore(this.getPreferenceStore());
        this.showTooltipMouseHiverFE.load();
        comp = new Composite((Composite)miscGrp, 0);
        this.showHRuler = new BooleanFieldEditor("vcobol.showhruler", VresourceBundle.getString((String)"show_h_ruler_lbl"), comp);
        this.showHRuler.setPage((DialogPage)this);
        this.showHRuler.setPreferenceStore(this.getPreferenceStore());
        this.showHRuler.load();
        return composite;
    }

    private void loadProp(String propName) {
        IPreferenceStore store = this.getPreferenceStore();
        if (store.contains(propName)) {
            this.tabList.setData(propName, (Object)store.getString(propName));
        } else {
            this.tabList.setData(propName, (Object)store.getDefaultString(propName));
        }
    }

    private void loadDefault(String propName) {
        IPreferenceStore store = this.getPreferenceStore();
        this.tabList.setData(propName, (Object)store.getDefaultString(propName));
    }

    private void loadList() {
        if (this.sourceFormatCmb.getSelectionIndex() == 0) {
            this.loadList("vcobol.tabs.ansi");
        } else {
            this.loadList("vcobol.tabs.terminal");
        }
    }

    private void loadList(String propName) {
        String propValue = (String)this.tabList.getData(propName);
        StringTokenizer st = new StringTokenizer(propValue, ",");
        this.tabList.removeAll();
        while (st.hasMoreTokens()) {
            this.tabList.add(st.nextToken());
        }
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(VcobolEditorPlugin.getDefault().getPreferenceStore());
    }

    private void createString() {
        if (this.sourceFormatCmb.getSelectionIndex() == 0) {
            this.createString("vcobol.tabs.ansi");
        } else {
            this.createString("vcobol.tabs.terminal");
        }
    }

    private void createString(String propName) {
        if (this.tabList.getItemCount() > 0) {
            StringBuffer buf = new StringBuffer(this.tabList.getItem(0));
            int i = 1;
            while (i < this.tabList.getItemCount()) {
                buf.append(",").append(this.tabList.getItem(i));
                ++i;
            }
            this.tabList.setData(propName, (Object)buf.toString());
        } else {
            this.tabList.setData(propName, (Object)"");
        }
    }

    public boolean performOk() {
        this.showHRuler.store();
        this.reconcilingFE.store();
        this.tabWidthFE.store();
        this.insertSpacesFE.store();
        this.showTooltipMouseHiverFE.store();
        this.getPreferenceStore().setValue("vcobol.tabs.ansi", (String)this.tabList.getData("vcobol.tabs.ansi"));
        this.getPreferenceStore().setValue("vcobol.tabs.terminal", (String)this.tabList.getData("vcobol.tabs.terminal"));
        return super.performOk();
    }

    protected void performDefaults() {
        this.showHRuler.loadDefault();
        this.reconcilingFE.loadDefault();
        this.tabWidthFE.loadDefault();
        this.insertSpacesFE.loadDefault();
        this.showTooltipMouseHiverFE.loadDefault();
        this.loadDefault("vcobol.tabs.ansi");
        this.loadDefault("vcobol.tabs.terminal");
        this.loadList();
    }

    static /* synthetic */ void access$0(EditorPreferencePage editorPreferencePage) {
        editorPreferencePage.loadList();
    }

    static /* synthetic */ Text access$1(EditorPreferencePage editorPreferencePage) {
        return editorPreferencePage.newTabTxt;
    }

    static /* synthetic */ int access$2() {
        return MAX_TAB_STOP;
    }

    static /* synthetic */ List access$3(EditorPreferencePage editorPreferencePage) {
        return editorPreferencePage.tabList;
    }

    static /* synthetic */ void access$4(EditorPreferencePage editorPreferencePage) {
        editorPreferencePage.createString();
    }
}

