/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.preferences;

import com.iscobol.compiler.remote.server.PreProcessor;
import com.iscobol.compiler.remote.server.RemoteCompiler;
import com.vcobol.plugins.editor.VcobolEditorPlugin;
import com.vcobol.plugins.editor.VresourceBundle;
import com.vcobol.plugins.editor.preferences.RemoteCompilerPreferencePage;
import com.vcobol.plugins.editor.util.PluginUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class RemoteCompilerPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private List ppList;
    private Text hostTxt;
    private Text portTxt;
    private Text outFolderTxt;
    private Text deplFolderTxt;
    private Button cleanWhenExitBtn;
    private StackLayout stackLayout;
    private Composite ppTabContainer;
    private Text rcFileTxt;
    private Button rcFileBrowseBtn;
    private Button outFolderBrowseBtn;
    private Button deplFolderBrowseBtn;
    private Button addPPBtn;
    private Button removePPBtn;
    private Button renamePPBtn;

    private int indexOfPP(String ppName) {
        int i = 0;
        while (i < this.ppList.getItemCount()) {
            if (ppName.equalsIgnoreCase(this.ppList.getItem(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private String validatePPName(String ppName) {
        return this.validatePPName(ppName, -1);
    }

    private String validatePPName(String ppName, int excludeIndex) {
        if (ppName.length() == 0) {
            return "";
        }
        int idx = this.indexOfPP(ppName);
        if (idx >= 0 && idx != excludeIndex) {
            return VresourceBundle.getString((String)"pp_already_exists_msg");
        }
        if (!Character.isJavaIdentifierStart(ppName.charAt(0))) {
            return VresourceBundle.getString((String)"invalid_pp_name_msg");
        }
        int i = 1;
        while (i < ppName.length()) {
            if (!Character.isJavaIdentifierPart(ppName.charAt(i))) {
                return VresourceBundle.getString((String)"invalid_pp_name_msg");
            }
            ++i;
        }
        return null;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        composite.setLayout((Layout)gl);
        Group fileConfGrp = new Group(composite, 0);
        fileConfGrp.setText(VresourceBundle.getString((String)"rc_conffile_lbl"));
        gl = new GridLayout();
        gl.numColumns = 2;
        fileConfGrp.setLayout((Layout)gl);
        GridData gd = new GridData(768);
        fileConfGrp.setLayoutData((Object)gd);
        this.rcFileTxt = new Text((Composite)fileConfGrp, 2048);
        gd = new GridData(768);
        this.rcFileTxt.setLayoutData((Object)gd);
        this.rcFileTxt.setEditable(false);
        this.rcFileBrowseBtn = new Button((Composite)fileConfGrp, 8);
        this.rcFileBrowseBtn.setText(VresourceBundle.getString((String)"browse_lbl"));
        this.rcFileBrowseBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite rcPropGrp = new Composite(composite, 0);
        gl = new GridLayout();
        gl.marginWidth = 0;
        rcPropGrp.setLayout((Layout)gl);
        rcPropGrp.setLayoutData((Object)new GridData(768));
        Group serverGrp = new Group(rcPropGrp, 0);
        serverGrp.setText("Server");
        gl = new GridLayout();
        gl.numColumns = 4;
        serverGrp.setLayout((Layout)gl);
        Label l = new Label((Composite)serverGrp, 0);
        l.setText(String.valueOf(VresourceBundle.getString((String)"hostname_lbl")) + ":");
        this.hostTxt = new Text((Composite)serverGrp, 2048);
        gd = new GridData();
        gd.widthHint = 200;
        this.hostTxt.setLayoutData((Object)gd);
        this.hostTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        l = new Label((Composite)serverGrp, 0);
        l.setText(String.valueOf(VresourceBundle.getString((String)"portnumber_lbl")) + ":");
        this.portTxt = new Text((Composite)serverGrp, 133120);
        gd = new GridData();
        gd.widthHint = 50;
        this.portTxt.setLayoutData((Object)gd);
        this.portTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        Group outFolderGrp = new Group(rcPropGrp, 0);
        outFolderGrp.setText(VresourceBundle.getString((String)"outfolder_lbl"));
        gl = new GridLayout();
        gl.numColumns = 2;
        outFolderGrp.setLayout((Layout)gl);
        outFolderGrp.setLayoutData((Object)new GridData(768));
        this.outFolderTxt = new Text((Composite)outFolderGrp, 2048);
        this.outFolderTxt.setLayoutData((Object)new GridData(768));
        this.outFolderBrowseBtn = new Button((Composite)outFolderGrp, 8);
        this.outFolderBrowseBtn.setText(VresourceBundle.getString((String)"browse_lbl"));
        this.outFolderBrowseBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.cleanWhenExitBtn = new Button((Composite)outFolderGrp, 32);
        this.cleanWhenExitBtn.setText(VresourceBundle.getString((String)"cleanoutfolderwhenexit_lbl"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.cleanWhenExitBtn.setLayoutData((Object)gd);
        Group deplFolderGrp = new Group(rcPropGrp, 0);
        deplFolderGrp.setText(VresourceBundle.getString((String)"deplfolder_lbl"));
        gl = new GridLayout();
        gl.numColumns = 2;
        deplFolderGrp.setLayout((Layout)gl);
        deplFolderGrp.setLayoutData((Object)new GridData(768));
        this.deplFolderTxt = new Text((Composite)deplFolderGrp, 2048);
        this.deplFolderTxt.setLayoutData((Object)new GridData(768));
        this.deplFolderBrowseBtn = new Button((Composite)deplFolderGrp, 8);
        this.deplFolderBrowseBtn.setText(VresourceBundle.getString((String)"browse_lbl"));
        this.deplFolderBrowseBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite ppCmp = new Composite(composite, 0);
        gd = new GridData(1808);
        ppCmp.setLayoutData((Object)gd);
        gl = new GridLayout();
        gl.numColumns = 2;
        ppCmp.setLayout((Layout)gl);
        Group ppListGrp = new Group(ppCmp, 0);
        ppListGrp.setText("PreProcessors");
        gl = new GridLayout();
        gl.numColumns = 2;
        ppListGrp.setLayout((Layout)gl);
        gd = new GridData(1808);
        ppListGrp.setLayoutData((Object)gd);
        this.ppList = new List((Composite)ppListGrp, 2052);
        gd = new GridData(1808);
        gd.widthHint = 200;
        this.ppList.setLayoutData((Object)gd);
        Composite buttonCmp = new Composite((Composite)ppListGrp, 0);
        gd = new GridData();
        gd.verticalAlignment = 128;
        buttonCmp.setLayoutData((Object)gd);
        RowLayout rl = new RowLayout();
        rl.type = 512;
        rl.fill = true;
        buttonCmp.setLayout((Layout)rl);
        this.addPPBtn = new Button(buttonCmp, 8);
        this.addPPBtn.setText("New");
        this.addPPBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.renamePPBtn = new Button(buttonCmp, 8);
        this.renamePPBtn.setText("Rename");
        this.renamePPBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.removePPBtn = new Button(buttonCmp, 8);
        this.removePPBtn.setText("Remove");
        this.removePPBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.ppTabContainer = new Composite(ppCmp, 0);
        gd = new GridData(1808);
        this.ppTabContainer.setLayoutData((Object)gd);
        this.stackLayout = new StackLayout();
        this.ppTabContainer.setLayout((Layout)this.stackLayout);
        this.ppList.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.load();
        this.validatePage();
        return composite;
    }

    private void validatePage() {
        String[] err = this.validatePage0();
        if (err[0] != null) {
            this.setErrorMessage(null);
            this.setMessage(err[0], 2);
        } else if (err[1] != null) {
            this.setMessage(null);
            this.setErrorMessage(err[1]);
        } else {
            this.setMessage(null);
            this.setErrorMessage(null);
        }
        this.setValid(err[1] == null);
    }

    private String[] validatePage0() {
        boolean WARN = false;
        boolean ERR = true;
        String[] Return = new String[2];
        String s = this.validatePPExecNames();
        if (s != null) {
            Return[1] = s;
        } else {
            s = this.validateHostName();
            if (s != null) {
                Return[1] = s;
            } else {
                s = this.validatePortNumber();
                if (s != null) {
                    Return[1] = s;
                } else {
                    s = this.validateRCFile();
                    if (s != null) {
                        Return[0] = s;
                    }
                }
            }
        }
        return Return;
    }

    private String validatePortNumber() {
        if (this.portTxt.getText().length() > 0 && !PluginUtilities.validatePortNumber((String)this.portTxt.getText())) {
            return VresourceBundle.getString((String)"invalid_port_msg");
        }
        return null;
    }

    private String validateHostName() {
        if (this.hostTxt.getText().length() > 0 && !PluginUtilities.validateHostName((String)this.hostTxt.getText())) {
            return VresourceBundle.getString((String)"invalid_host_msg");
        }
        return null;
    }

    private String validateRCFile() {
        File rcFile = new File(this.rcFileTxt.getText());
        if (!(rcFile.exists() || rcFile.getParentFile() != null && rcFile.getParentFile().exists())) {
            return VresourceBundle.getString((String)"set_valid_rc_conf_file_msg");
        }
        return null;
    }

    private String validatePPExecNames() {
        int i = 0;
        while (i < this.ppList.getItemCount()) {
            PPTabGroup pptg = (PPTabGroup)this.ppTabContainer.getData(this.ppList.getItem(i));
            String msg = pptg.validate();
            if (msg != null) {
                return String.valueOf(pptg.nameTxt.getText()) + " PreProcessor: " + msg;
            }
            ++i;
        }
        return null;
    }

    private void ppListSelchange(int idx) {
        String ppName = this.ppList.getItem(idx);
        PPTabGroup pptg = (PPTabGroup)this.ppTabContainer.getData(ppName);
        this.stackLayout.topControl = pptg.tab;
        pptg.tab.setSelection(0);
        this.ppTabContainer.layout();
    }

    private void load() {
        this.load(this.getPreferenceStore().contains("vcobol.remotecompiler.conffile") ? this.getPreferenceStore().getString("vcobol.remotecompiler.conffile") : this.getPreferenceStore().getDefaultString("vcobol.remotecompiler.conffile"));
    }

    private void load(String rcConf) {
        block26: {
            File rcConfFile = new File(rcConf);
            this.rcFileTxt.setText(rcConf);
            Control[] cc = this.ppTabContainer.getChildren();
            int i = 0;
            while (i < cc.length) {
                cc[i].dispose();
                ++i;
            }
            this.ppList.removeAll();
            this.portTxt.setText("");
            this.hostTxt.setText("");
            this.outFolderTxt.setText("");
            this.deplFolderTxt.setText("");
            this.cleanWhenExitBtn.setSelection(true);
            if (rcConfFile.exists()) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = null;
                try {
                    builder = factory.newDocumentBuilder();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    // empty catch block
                }
                InputStreamReader reader = null;
                try {
                    try {
                        reader = new InputStreamReader(new FileInputStream(rcConfFile));
                        Document document = builder.parse(new InputSource(reader));
                        Element remoteCompilerElem = document.getDocumentElement();
                        RemoteCompiler rc = new RemoteCompiler(remoteCompilerElem, null, false);
                        this.portTxt.setText("" + rc.getPortNumber());
                        if (rc.getHostName() != null) {
                            this.hostTxt.setText(rc.getHostName());
                        }
                        if (rc.getOutputFolder() != null) {
                            this.outFolderTxt.setText(rc.getOutputFolder());
                        }
                        if (rc.getDeploymentFolder() != null) {
                            this.deplFolderTxt.setText(rc.getDeploymentFolder());
                        }
                        this.cleanWhenExitBtn.setSelection(rc.getCleanOutputFolderWhenExit());
                        PreProcessor[] pps = rc.getPreProcessors();
                        if (pps.length > 0) {
                            int i2 = 0;
                            while (i2 < pps.length) {
                                if (this.indexOfPP(pps[i2].getName()) < 0) {
                                    this.ppList.add(pps[i2].getName());
                                    PPTabGroup pptg = new PPTabGroup(this, null);
                                    pptg.createControl(this.ppTabContainer, pps[i2], null);
                                    this.ppTabContainer.setData(pps[i2].getName(), (Object)pptg);
                                }
                                ++i2;
                            }
                            this.ppList.setSelection(0);
                            this.ppListSelchange(0);
                        } else {
                            this.createEmptyTabGroup();
                        }
                    }
                    catch (Exception e) {
                        PluginUtilities.logError((String)e.getMessage());
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block26;
                    }
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            } else {
                this.createEmptyTabGroup();
            }
        }
        this.validatePage();
    }

    private void createEmptyTabGroup() {
        PPTabGroup pptg = new PPTabGroup(this, null);
        Composite comp = new Composite(this.ppTabContainer, 0);
        comp.setLayout((Layout)new FillLayout());
        pptg.createControl(comp, null, null);
        this.stackLayout.topControl = comp;
        this.ppTabContainer.layout();
        pptg.tab.setVisible(false);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(VcobolEditorPlugin.getDefault().getPreferenceStore());
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("vcobol.remotecompiler.conffile", this.rcFileTxt.getText());
        try {
            this.writeXmlFile(this.rcFileTxt.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.performOk();
    }

    private void writeXmlFile(String confFile) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element remoteCompiler = document.createElement("remoteCompiler");
        document.appendChild(remoteCompiler);
        if (this.portTxt.getText().length() > 0) {
            remoteCompiler.setAttribute("portNumber", this.portTxt.getText());
        }
        if (this.hostTxt.getText().length() > 0) {
            remoteCompiler.setAttribute("hostName", this.hostTxt.getText());
        }
        if (this.outFolderTxt.getText().length() > 0) {
            remoteCompiler.setAttribute("outputFolder", this.outFolderTxt.getText());
        }
        if (this.deplFolderTxt.getText().length() > 0) {
            remoteCompiler.setAttribute("deploymentFolder", this.deplFolderTxt.getText());
        }
        remoteCompiler.setAttribute("cleanOutputFolderWhenExit", Boolean.toString(this.cleanWhenExitBtn.getSelection()));
        int i = 0;
        while (i < this.ppList.getItemCount()) {
            String item = this.ppList.getItem(i);
            PPTabGroup pptg = (PPTabGroup)this.ppTabContainer.getData(item);
            Element preProcessor = document.createElement("preProcessor");
            remoteCompiler.appendChild(preProcessor);
            preProcessor.setAttribute("name", pptg.nameTxt.getText());
            preProcessor.setAttribute("executable", pptg.executableTxt.getText());
            if (pptg.outExtTxt.getText().length() > 0) {
                preProcessor.setAttribute("outputFileExt", pptg.outExtTxt.getText());
            }
            if (pptg.lstExtTxt.getText().length() > 0) {
                preProcessor.setAttribute("listFileExt", pptg.lstExtTxt.getText());
            }
            if (pptg.errExtTxt.getText().length() > 0) {
                preProcessor.setAttribute("errorFileExt", pptg.errExtTxt.getText());
            }
            Element optionList = document.createElement("optionList");
            preProcessor.appendChild(optionList);
            int j = 0;
            while (j < pptg.optTbl.getItemCount()) {
                Element option = document.createElement("option");
                optionList.appendChild(option);
                TableItem tItem = pptg.optTbl.getItem(j);
                if (tItem.getText(1).length() > 0) {
                    option.setAttribute("if", tItem.getText(1));
                }
                option.appendChild(document.createTextNode(tItem.getText(0)));
                ++j;
            }
            Element environment = document.createElement("environment");
            preProcessor.appendChild(environment);
            environment.setAttribute("append", Boolean.toString(pptg.appendEnvBtn.getSelection()));
            int j2 = 0;
            while (j2 < pptg.varTbl.getItemCount()) {
                Element variable = document.createElement("variable");
                environment.appendChild(variable);
                TableItem tItem = pptg.varTbl.getItem(j2);
                variable.setAttribute("name", tItem.getText(0));
                variable.setAttribute("value", tItem.getText(1));
                ++j2;
            }
            ++i;
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformerFactory.setAttribute("indent-number", new Integer(3));
        }
        catch (Exception item) {
            // empty catch block
        }
        Transformer transformer = transformerFactory.newTransformer();
        Properties outProps = transformer.getOutputProperties();
        outProps.setProperty("indent", "yes");
        transformer.setOutputProperties(outProps);
        DOMSource source = new DOMSource(document);
        FileOutputStream os = new FileOutputStream(confFile);
        StreamResult result = new StreamResult(new OutputStreamWriter(os));
        transformer.transform(source, result);
        os.close();
    }

    protected void performDefaults() {
        String confFile = this.getPreferenceStore().getDefaultString("vcobol.remotecompiler.conffile");
        this.load(confFile);
        super.performDefaults();
    }

    static /* synthetic */ void access$0(RemoteCompilerPreferencePage remoteCompilerPreferencePage) {
        remoteCompilerPreferencePage.validatePage();
    }

    static /* synthetic */ Button access$1(RemoteCompilerPreferencePage remoteCompilerPreferencePage) {
        return remoteCompilerPreferencePage.rcFileBrowseBtn;
    }

    static /* synthetic */ void access$2(RemoteCompilerPreferencePage remoteCompilerPreferencePage, String string) {
        remoteCompilerPreferencePage.load(string);
    }

    static /* synthetic */ Text access$3(RemoteCompilerPreferencePage remoteCompilerPreferencePage) {
        return remoteCompilerPreferencePage.outFolderTxt;
    }

    static /* synthetic */ Text access$4(RemoteCompilerPreferencePage remoteCompilerPreferencePage) {
        return remoteCompilerPreferencePage.deplFolderTxt;
    }

    static /* synthetic */ Button access$5(RemoteCompilerPreferencePage remoteCompilerPreferencePage) {
        return remoteCompilerPreferencePage.addPPBtn;
    }

    static /* synthetic */ String access$6(RemoteCompilerPreferencePage remoteCompilerPreferencePage, String string) {
        return remoteCompilerPreferencePage.validatePPName(string);
    }

    static /* synthetic */ List access$7(RemoteCompilerPreferencePage remoteCompilerPreferencePage) {
        return remoteCompilerPreferencePage.ppList;
    }

    static /* synthetic */ Composite access$8(RemoteCompilerPreferencePage remoteCompilerPreferencePage) {
        return remoteCompilerPreferencePage.ppTabContainer;
    }

    static /* synthetic */ void access$9(RemoteCompilerPreferencePage remoteCompilerPreferencePage, int n) {
        remoteCompilerPreferencePage.ppListSelchange(n);
    }

    static /* synthetic */ String access$10(RemoteCompilerPreferencePage remoteCompilerPreferencePage, String string, int n) {
        return remoteCompilerPreferencePage.validatePPName(string, n);
    }
}

