/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.preferences;

import com.vcobol.plugins.editor.VcobolEditor;
import com.vcobol.plugins.editor.VcobolEditorPlugin;
import com.vcobol.plugins.editor.VresourceBundle;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SyntaxColoringPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String rcsid = "$Id: SyntaxColoringPreferencePage.java,v 1.3 2008/02/27 14:45:02 gianni Exp $";
    private Map colorMap = new HashMap();
    private ColorFieldEditor sourceFormatBgEditor;
    private ColorFieldEditor sourceFormatFgEditor;
    private ColorFieldEditor syntaxHltBgEditor;
    private ColorFieldEditor syntaxHltFgEditor;
    private ColorFieldEditor verticalLinesFgEditor;
    private Composite sourceFormatColorGrp;
    private Composite syntaxHltColorGrp;
    private Composite verticalLinesFgEditorCmp;
    private BooleanFieldEditor sourceFormatEnEditor;
    private BooleanFieldEditor syntaxHltEnEditor;
    private BooleanFieldEditor showVerticalLinesEditor;
    private Tree sourceFormatTree;
    private Tree syntaxHltTree;
    private boolean syntaxHltEnabled;
    private boolean sourceFormatEnabled;
    private boolean showVerticalLines;
    private static final int NONE = -1;
    private static final int SEQUENCE_NUMBER = 1;
    private static final int INDICATOR_AREA = 2;
    private static final int AREA_A = 3;
    private static final int AREA_B = 4;
    private static final int COMMENTS = 5;
    private static final int KEYWORDS = 6;
    private static final int STRINGS = 7;
    private static final int NUMBERS = 8;
    private static final int STATEMENTS = 9;
    private static final int LEVEL_NUMBER = 10;
    private static final int FIGURATIVE_CONST = 11;
    private static final int DBG_CURRENT_LINE = 12;
    private static final int IDENTIFICATION_AREA = 13;
    private int currElement;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        composite.setLayout((Layout)gl);
        Group sourceFormatGrp = new Group(composite, 0);
        sourceFormatGrp.setText(VresourceBundle.getString((String)"src_format_lbl"));
        gl = new GridLayout();
        gl.numColumns = 2;
        sourceFormatGrp.setLayout((Layout)gl);
        Composite sourceFormatEnEditorCmp = new Composite((Composite)sourceFormatGrp, 0);
        this.sourceFormatEnEditor = new BooleanFieldEditor("vcobol.sourceformat.enabled", VresourceBundle.getString((String)"src_format_en_lbl"), sourceFormatEnEditorCmp);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        sourceFormatEnEditorCmp.setLayoutData((Object)gd);
        this.sourceFormatEnEditor.setPage((DialogPage)this);
        this.sourceFormatEnEditor.setPreferenceStore(this.getPreferenceStore());
        this.sourceFormatEnEditor.load();
        this.sourceFormatTree = new Tree((Composite)sourceFormatGrp, 2048);
        this.sourceFormatTree.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        gd = new GridData();
        gd.widthHint = 250;
        gd.heightHint = 150;
        this.sourceFormatTree.setLayoutData((Object)gd);
        this.sourceFormatEnEditor.setPropertyChangeListener((IPropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.sourceFormatTree.setEnabled(this.sourceFormatEnabled);
        TreeItem ansi = new TreeItem(this.sourceFormatTree, 0);
        ansi.setText("ANSI");
        ansi.setData((Object)new Integer(-1));
        TreeItem seqNum = new TreeItem(ansi, 0);
        seqNum.setText("Sequence number [columns 1-6]");
        seqNum.setData((Object)new Integer(1));
        TreeItem indArea = new TreeItem(ansi, 0);
        indArea.setText("Indicator area [columns 7]");
        indArea.setData((Object)new Integer(2));
        TreeItem areaA = new TreeItem(ansi, 0);
        areaA.setText("Area A [columns 8-11]");
        areaA.setData((Object)new Integer(3));
        TreeItem areaB = new TreeItem(ansi, 0);
        areaB.setText("Area B [columns 12-72]");
        areaB.setData((Object)new Integer(4));
        TreeItem idenArea = new TreeItem(ansi, 0);
        idenArea.setText("Identification area [columns 73-80]");
        idenArea.setData((Object)new Integer(13));
        TreeItem terminal = new TreeItem(this.sourceFormatTree, 0);
        terminal.setText("Terminal");
        terminal.setData((Object)new Integer(-1));
        indArea = new TreeItem(terminal, 0);
        indArea.setText("Indicator area [column 1]");
        indArea.setData((Object)new Integer(2));
        areaA = new TreeItem(terminal, 0);
        areaA.setText("Area A [columns 2-5]");
        areaA.setData((Object)new Integer(3));
        areaB = new TreeItem(terminal, 0);
        areaB.setText("Area B [columns 6-EOL]");
        areaB.setData((Object)new Integer(4));
        this.sourceFormatColorGrp = new Composite((Composite)sourceFormatGrp, 0);
        gd = new GridData();
        gd.heightHint = 100;
        gd.widthHint = 180;
        gd.verticalAlignment = 128;
        this.sourceFormatColorGrp.setLayoutData((Object)gd);
        gl = new GridLayout();
        gl.numColumns = 2;
        this.sourceFormatColorGrp.setLayout((Layout)gl);
        this.sourceFormatBgEditor = new ColorFieldEditor("NONE", String.valueOf(VresourceBundle.getString((String)"background_lbl")) + ":", this.sourceFormatColorGrp);
        this.sourceFormatBgEditor.setPage((DialogPage)this);
        this.sourceFormatBgEditor.setPreferenceStore(this.getPreferenceStore());
        this.sourceFormatBgEditor.getColorSelector().addListener((IPropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.sourceFormatFgEditor = new ColorFieldEditor("NONE", String.valueOf(VresourceBundle.getString((String)"foreground_lbl")) + ":", this.sourceFormatColorGrp);
        this.sourceFormatFgEditor.setPage((DialogPage)this);
        this.sourceFormatFgEditor.setPreferenceStore(this.getPreferenceStore());
        this.sourceFormatFgEditor.getColorSelector().addListener((IPropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.sourceFormatBgEditor.setEnabled(this.sourceFormatEnabled, this.sourceFormatColorGrp);
        this.sourceFormatFgEditor.setEnabled(this.sourceFormatEnabled, this.sourceFormatColorGrp);
        Composite showVerticalLinesEditorCmp = new Composite((Composite)sourceFormatGrp, 0);
        this.showVerticalLinesEditor = new BooleanFieldEditor("vcobol.syntaxcoloring.showareadelimiterlines", VresourceBundle.getString((String)"show_vertical_lines_lbl"), showVerticalLinesEditorCmp);
        this.showVerticalLinesEditor.setPage((DialogPage)this);
        this.showVerticalLinesEditor.setPreferenceStore(this.getPreferenceStore());
        this.showVerticalLinesEditor.load();
        this.showVerticalLinesEditor.setPropertyChangeListener((IPropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.verticalLinesFgEditorCmp = new Composite((Composite)sourceFormatGrp, 0);
        gl = new GridLayout();
        gl.numColumns = 2;
        this.verticalLinesFgEditorCmp.setLayout((Layout)gl);
        this.verticalLinesFgEditor = new ColorFieldEditor("vcobol.syntaxcoloring.areadelimiterlinescolor", String.valueOf(VresourceBundle.getString((String)"foreground_lbl")) + ":", this.verticalLinesFgEditorCmp);
        this.verticalLinesFgEditor.setPage((DialogPage)this);
        this.verticalLinesFgEditor.setPreferenceStore(this.getPreferenceStore());
        this.verticalLinesFgEditor.load();
        this.verticalLinesFgEditor.setEnabled(this.showVerticalLines, this.verticalLinesFgEditorCmp);
        Group syntaxHltGrp = new Group(composite, 0);
        syntaxHltGrp.setText(VresourceBundle.getString((String)"syntax_high_lbl"));
        gl = new GridLayout();
        gl.numColumns = 2;
        syntaxHltGrp.setLayout((Layout)gl);
        Composite syntaxHltEnEditorCmp = new Composite((Composite)syntaxHltGrp, 0);
        this.syntaxHltEnEditor = new BooleanFieldEditor("vcobol.syntaxhighlighting.enabled", VresourceBundle.getString((String)"syntax_high_en_lbl"), syntaxHltEnEditorCmp);
        this.syntaxHltEnEditor.setPage((DialogPage)this);
        this.syntaxHltEnEditor.setPreferenceStore(this.getPreferenceStore());
        this.syntaxHltEnEditor.load();
        gd = new GridData();
        gd.horizontalSpan = 2;
        syntaxHltEnEditorCmp.setLayoutData((Object)gd);
        this.syntaxHltTree = new Tree((Composite)syntaxHltGrp, 2048);
        this.syntaxHltTree.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        gd = new GridData();
        gd.widthHint = 250;
        gd.heightHint = 150;
        this.syntaxHltTree.setLayoutData((Object)gd);
        this.syntaxHltEnEditor.setPropertyChangeListener((IPropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.syntaxHltTree.setEnabled(this.syntaxHltEnabled);
        TreeItem comments = new TreeItem(this.syntaxHltTree, 0);
        comments.setText(VresourceBundle.getString((String)"comments_lbl"));
        comments.setData((Object)new Integer(5));
        TreeItem keywords = new TreeItem(this.syntaxHltTree, 0);
        keywords.setText(VresourceBundle.getString((String)"keywords_lbl"));
        keywords.setData((Object)new Integer(6));
        TreeItem strings = new TreeItem(this.syntaxHltTree, 0);
        strings.setText(VresourceBundle.getString((String)"str_const_lbl"));
        strings.setData((Object)new Integer(7));
        TreeItem numbers = new TreeItem(this.syntaxHltTree, 0);
        numbers.setText(VresourceBundle.getString((String)"num_const_lbl"));
        numbers.setData((Object)new Integer(8));
        TreeItem stmts = new TreeItem(this.syntaxHltTree, 0);
        stmts.setText(VresourceBundle.getString((String)"statements_lbl"));
        stmts.setData((Object)new Integer(9));
        TreeItem levNum = new TreeItem(this.syntaxHltTree, 0);
        levNum.setText(VresourceBundle.getString((String)"level_numbers_lbl"));
        levNum.setData((Object)new Integer(10));
        TreeItem figConst = new TreeItem(this.syntaxHltTree, 0);
        figConst.setText(VresourceBundle.getString((String)"fig_const_lbl"));
        figConst.setData((Object)new Integer(11));
        TreeItem dbgCl = new TreeItem(this.syntaxHltTree, 0);
        dbgCl.setText(VresourceBundle.getString((String)"dbg_curr_line_lbl"));
        dbgCl.setData((Object)new Integer(12));
        this.syntaxHltColorGrp = new Composite((Composite)syntaxHltGrp, 0);
        gd = new GridData();
        gd.heightHint = 100;
        gd.widthHint = 180;
        gd.verticalAlignment = 128;
        this.syntaxHltColorGrp.setLayoutData((Object)gd);
        gl = new GridLayout();
        gl.numColumns = 2;
        this.syntaxHltColorGrp.setLayout((Layout)gl);
        this.syntaxHltBgEditor = new ColorFieldEditor("NONE", String.valueOf(VresourceBundle.getString((String)"background_lbl")) + ":", this.syntaxHltColorGrp);
        this.syntaxHltBgEditor.setPage((DialogPage)this);
        this.syntaxHltBgEditor.setPreferenceStore(this.getPreferenceStore());
        this.syntaxHltBgEditor.getColorSelector().addListener((IPropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.syntaxHltFgEditor = new ColorFieldEditor("NONE", String.valueOf(VresourceBundle.getString((String)"foreground_lbl")) + ":", this.syntaxHltColorGrp);
        this.syntaxHltFgEditor.setPage((DialogPage)this);
        this.syntaxHltFgEditor.setPreferenceStore(this.getPreferenceStore());
        this.syntaxHltFgEditor.getColorSelector().addListener((IPropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.syntaxHltBgEditor.setEnabled(this.syntaxHltEnabled, this.syntaxHltColorGrp);
        this.syntaxHltFgEditor.setEnabled(this.syntaxHltEnabled, this.syntaxHltColorGrp);
        return composite;
    }

    private void updateEditors(int i, boolean sourceFormat) {
        this.currElement = i;
        switch (this.currElement) {
            default: {
                this.unloadBackground(sourceFormat);
                this.unloadForeground(sourceFormat);
                break;
            }
            case 1: {
                this.loadBackground("vcobol.syntaxcoloring.sequencenumber.background", sourceFormat);
                this.unloadForeground(sourceFormat);
                break;
            }
            case 2: {
                this.loadBackground("vcobol.syntaxcoloring.indicatorarea.background", sourceFormat);
                this.unloadForeground(sourceFormat);
                break;
            }
            case 3: {
                this.loadBackground("vcobol.syntaxcoloring.areaa.background", sourceFormat);
                this.unloadForeground(sourceFormat);
                break;
            }
            case 4: {
                this.loadBackground("vcobol.syntaxcoloring.areab.background", sourceFormat);
                this.unloadForeground(sourceFormat);
                break;
            }
            case 13: {
                this.loadBackground("vcobol.syntaxcoloring.identificationarea.background", sourceFormat);
                this.unloadForeground(sourceFormat);
                break;
            }
            case 5: {
                this.unloadBackground(sourceFormat);
                this.loadForeground("vcobol.syntaxcoloring.comments.foreground", sourceFormat);
                break;
            }
            case 6: {
                this.unloadBackground(sourceFormat);
                this.loadForeground("vcobol.syntaxcoloring.keywords.foreground", sourceFormat);
                break;
            }
            case 7: {
                this.unloadBackground(sourceFormat);
                this.loadForeground("vcobol.syntaxcoloring.strings.foreground", sourceFormat);
                break;
            }
            case 8: {
                this.unloadBackground(sourceFormat);
                this.loadForeground("vcobol.syntaxcoloring.numbers.foreground", sourceFormat);
                break;
            }
            case 9: {
                this.unloadBackground(sourceFormat);
                this.loadForeground("vcobol.syntaxcoloring.statements.foreground", sourceFormat);
                break;
            }
            case 10: {
                this.unloadBackground(sourceFormat);
                this.loadForeground("vcobol.syntaxcoloring.levelnumber.foreground", sourceFormat);
                break;
            }
            case 11: {
                this.unloadBackground(sourceFormat);
                this.loadForeground("vcobol.syntaxcoloring.figurativeconst.foreground", sourceFormat);
                break;
            }
            case 12: {
                this.loadForeground("vcobol.syntaxcoloring.debugcurrentline.foreground", sourceFormat);
                this.loadBackground("vcobol.syntaxcoloring.debugcurrentline.background", sourceFormat);
            }
        }
    }

    private void loadForeground(String propName, boolean sourceFormat) {
        if (sourceFormat) {
            this.load(this.sourceFormatFgEditor, propName, this.sourceFormatColorGrp);
        } else {
            this.load(this.syntaxHltFgEditor, propName, this.syntaxHltColorGrp);
        }
    }

    private void loadBackground(String propName, boolean sourceFormat) {
        if (sourceFormat) {
            this.load(this.sourceFormatBgEditor, propName, this.sourceFormatColorGrp);
        } else {
            this.load(this.syntaxHltBgEditor, propName, this.syntaxHltColorGrp);
        }
    }

    private void load(ColorFieldEditor editor, String propName, Composite colorGrp) {
        RGB rgb = (RGB)this.colorMap.get(propName);
        editor.setEnabled(true, colorGrp);
        editor.setPreferenceName(propName);
        editor.getColorSelector().setColorValue(rgb);
    }

    private void unloadForeground(boolean sourceFormat) {
        if (sourceFormat) {
            this.sourceFormatFgEditor.setEnabled(false, this.sourceFormatColorGrp);
        } else {
            this.syntaxHltFgEditor.setEnabled(false, this.syntaxHltColorGrp);
        }
    }

    private void unloadBackground(boolean sourceFormat) {
        if (sourceFormat) {
            this.sourceFormatBgEditor.setEnabled(false, this.sourceFormatColorGrp);
        } else {
            this.syntaxHltBgEditor.setEnabled(false, this.syntaxHltColorGrp);
        }
    }

    public void init(IWorkbench workbench) {
        IPreferenceStore store = VcobolEditorPlugin.getDefault().getPreferenceStore();
        this.setPreferenceStore(store);
        this.syntaxHltEnabled = store.contains("vcobol.syntaxhighlighting.enabled") ? store.getBoolean("vcobol.syntaxhighlighting.enabled") : store.getDefaultBoolean("vcobol.syntaxhighlighting.enabled");
        this.sourceFormatEnabled = store.contains("vcobol.sourceformat.enabled") ? store.getBoolean("vcobol.sourceformat.enabled") : store.getDefaultBoolean("vcobol.sourceformat.enabled");
        this.showVerticalLines = store.contains("vcobol.syntaxcoloring.showareadelimiterlines") ? store.getBoolean("vcobol.syntaxcoloring.showareadelimiterlines") : store.getDefaultBoolean("vcobol.syntaxcoloring.showareadelimiterlines");
        this.colorMap.put("vcobol.syntaxcoloring.areaa.background", PreferenceConverter.getColor((IPreferenceStore)store, (String)"vcobol.syntaxcoloring.areaa.background"));
        this.colorMap.put("vcobol.syntaxcoloring.areaa.foreground", PreferenceConverter.getColor((IPreferenceStore)store, (String)"vcobol.syntaxcoloring.areaa.foreground"));
        this.colorMap.put("vcobol.syntaxcoloring.areab.background", PreferenceConverter.getColor((IPreferenceStore)store, (String)"vcobol.syntaxcoloring.areab.background"));
        this.colorMap.put("vcobol.syntaxcoloring.areab.foreground", PreferenceConverter.getColor((IPreferenceStore)store, (String)"vcobol.syntaxcoloring.areab.foreground"));
        this.colorMap.put("vcobol.syntaxcoloring.indicatorarea.background", PreferenceConverter.getColor((IPreferenceStore)store, (String)"vcobol.syntaxcoloring.indicatorarea.background"));
        this.colorMap.put("vcobol.syntaxcoloring.indicatorarea.foreground", PreferenceConverter.getColor((IPreferenceStore)store, (String)"vcobol.syntaxcoloring.indicatorarea.foreground"));
        this.colorMap.put("vcobol.syntaxcoloring.identificationarea.background", PreferenceConverter.getColor((IPreferenceStore)store, (String)"vcobol.syntaxcoloring.identificationarea.background"));
        this.colorMap.put("vcobol.syntaxcoloring.identificationarea.foreground", PreferenceConverter.getColor((IPreferenceStore)store, (String)"vcobol.syntaxcoloring.identificationarea.foreground"));
        this.colorMap.put("vcobol.syntaxcoloring.sequencenumber.background", PreferenceConverter.getColor((IPreferenceStore)store, (String)"vcobol.syntaxcoloring.sequencenumber.background"));
        this.colorMap.put("vcobol.syntaxcoloring.sequencenumber.foreground", PreferenceConverter.getColor((IPreferenceStore)store, (String)"vcobol.syntaxcoloring.sequencenumber.foreground"));
        this.colorMap.put("vcobol.syntaxcoloring.comments.foreground", PreferenceConverter.getColor((IPreferenceStore)store, (String)"vcobol.syntaxcoloring.comments.foreground"));
        this.colorMap.put("vcobol.syntaxcoloring.strings.foreground", PreferenceConverter.getColor((IPreferenceStore)store, (String)"vcobol.syntaxcoloring.strings.foreground"));
        this.colorMap.put("vcobol.syntaxcoloring.numbers.foreground", PreferenceConverter.getColor((IPreferenceStore)store, (String)"vcobol.syntaxcoloring.numbers.foreground"));
        this.colorMap.put("vcobol.syntaxcoloring.statements.foreground", PreferenceConverter.getColor((IPreferenceStore)store, (String)"vcobol.syntaxcoloring.statements.foreground"));
        this.colorMap.put("vcobol.syntaxcoloring.keywords.foreground", PreferenceConverter.getColor((IPreferenceStore)store, (String)"vcobol.syntaxcoloring.keywords.foreground"));
        this.colorMap.put("vcobol.syntaxcoloring.levelnumber.foreground", PreferenceConverter.getColor((IPreferenceStore)store, (String)"vcobol.syntaxcoloring.levelnumber.foreground"));
        this.colorMap.put("vcobol.syntaxcoloring.figurativeconst.foreground", PreferenceConverter.getColor((IPreferenceStore)store, (String)"vcobol.syntaxcoloring.figurativeconst.foreground"));
        this.colorMap.put("vcobol.syntaxcoloring.debugcurrentline.background", PreferenceConverter.getColor((IPreferenceStore)store, (String)"vcobol.syntaxcoloring.debugcurrentline.background"));
        this.colorMap.put("vcobol.syntaxcoloring.debugcurrentline.foreground", PreferenceConverter.getColor((IPreferenceStore)store, (String)"vcobol.syntaxcoloring.debugcurrentline.foreground"));
    }

    public boolean performOk() {
        Iterator i = this.colorMap.keySet().iterator();
        while (i.hasNext()) {
            String k = i.next().toString();
            PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)k, (RGB)((RGB)this.colorMap.get(k)));
        }
        this.getPreferenceStore().setValue("vcobol.sourceformat.enabled", this.sourceFormatEnabled);
        this.getPreferenceStore().setValue("vcobol.syntaxhighlighting.enabled", this.syntaxHltEnabled);
        this.getPreferenceStore().setValue("vcobol.syntaxcoloring.showareadelimiterlines", this.showVerticalLines);
        this.verticalLinesFgEditor.store();
        IEditorPart aEd = VcobolEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (aEd != null && aEd instanceof VcobolEditor) {
            VcobolEditor isEd = (VcobolEditor)aEd;
            isEd.redraw();
            isEd.refreshEditor();
        }
        return super.performOk();
    }

    protected void performDefaults() {
        this.sourceFormatEnabled = this.getPreferenceStore().getDefaultBoolean("vcobol.sourceformat.enabled");
        this.sourceFormatEnEditor.loadDefault();
        this.sourceFormatTree.setEnabled(this.sourceFormatEnabled);
        this.sourceFormatBgEditor.setEnabled(this.sourceFormatEnabled, this.sourceFormatColorGrp);
        this.sourceFormatFgEditor.setEnabled(this.sourceFormatEnabled, this.sourceFormatColorGrp);
        this.syntaxHltEnabled = this.getPreferenceStore().getDefaultBoolean("vcobol.syntaxhighlighting.enabled");
        this.syntaxHltEnEditor.loadDefault();
        this.syntaxHltTree.setEnabled(this.syntaxHltEnabled);
        this.syntaxHltBgEditor.setEnabled(this.syntaxHltEnabled, this.syntaxHltColorGrp);
        this.syntaxHltFgEditor.setEnabled(this.syntaxHltEnabled, this.syntaxHltColorGrp);
        this.showVerticalLines = this.getPreferenceStore().getDefaultBoolean("vcobol.syntaxcoloring.showareadelimiterlines");
        this.showVerticalLinesEditor.loadDefault();
        this.verticalLinesFgEditor.loadDefault();
        this.verticalLinesFgEditor.setEnabled(this.showVerticalLines, this.verticalLinesFgEditorCmp);
        Iterator i = this.colorMap.keySet().iterator();
        while (i.hasNext()) {
            String k = i.next().toString();
            this.colorMap.put(k, PreferenceConverter.getDefaultColor((IPreferenceStore)this.getPreferenceStore(), (String)k));
        }
        super.performDefaults();
    }

    static /* synthetic */ void access$0(SyntaxColoringPreferencePage syntaxColoringPreferencePage, int n, boolean bl) {
        syntaxColoringPreferencePage.updateEditors(n, bl);
    }

    static /* synthetic */ BooleanFieldEditor access$1(SyntaxColoringPreferencePage syntaxColoringPreferencePage) {
        return syntaxColoringPreferencePage.sourceFormatEnEditor;
    }

    static /* synthetic */ void access$2(SyntaxColoringPreferencePage syntaxColoringPreferencePage, boolean bl) {
        syntaxColoringPreferencePage.sourceFormatEnabled = bl;
    }

    static /* synthetic */ Tree access$3(SyntaxColoringPreferencePage syntaxColoringPreferencePage) {
        return syntaxColoringPreferencePage.sourceFormatTree;
    }

    static /* synthetic */ boolean access$4(SyntaxColoringPreferencePage syntaxColoringPreferencePage) {
        return syntaxColoringPreferencePage.sourceFormatEnabled;
    }

    static /* synthetic */ ColorFieldEditor access$5(SyntaxColoringPreferencePage syntaxColoringPreferencePage) {
        return syntaxColoringPreferencePage.sourceFormatBgEditor;
    }

    static /* synthetic */ Composite access$6(SyntaxColoringPreferencePage syntaxColoringPreferencePage) {
        return syntaxColoringPreferencePage.sourceFormatColorGrp;
    }

    static /* synthetic */ ColorFieldEditor access$7(SyntaxColoringPreferencePage syntaxColoringPreferencePage) {
        return syntaxColoringPreferencePage.sourceFormatFgEditor;
    }

    static /* synthetic */ Map access$8(SyntaxColoringPreferencePage syntaxColoringPreferencePage) {
        return syntaxColoringPreferencePage.colorMap;
    }

    static /* synthetic */ BooleanFieldEditor access$9(SyntaxColoringPreferencePage syntaxColoringPreferencePage) {
        return syntaxColoringPreferencePage.showVerticalLinesEditor;
    }

    static /* synthetic */ void access$10(SyntaxColoringPreferencePage syntaxColoringPreferencePage, boolean bl) {
        syntaxColoringPreferencePage.showVerticalLines = bl;
    }

    static /* synthetic */ ColorFieldEditor access$11(SyntaxColoringPreferencePage syntaxColoringPreferencePage) {
        return syntaxColoringPreferencePage.verticalLinesFgEditor;
    }

    static /* synthetic */ boolean access$12(SyntaxColoringPreferencePage syntaxColoringPreferencePage) {
        return syntaxColoringPreferencePage.showVerticalLines;
    }

    static /* synthetic */ Composite access$13(SyntaxColoringPreferencePage syntaxColoringPreferencePage) {
        return syntaxColoringPreferencePage.verticalLinesFgEditorCmp;
    }

    static /* synthetic */ BooleanFieldEditor access$14(SyntaxColoringPreferencePage syntaxColoringPreferencePage) {
        return syntaxColoringPreferencePage.syntaxHltEnEditor;
    }

    static /* synthetic */ void access$15(SyntaxColoringPreferencePage syntaxColoringPreferencePage, boolean bl) {
        syntaxColoringPreferencePage.syntaxHltEnabled = bl;
    }

    static /* synthetic */ Tree access$16(SyntaxColoringPreferencePage syntaxColoringPreferencePage) {
        return syntaxColoringPreferencePage.syntaxHltTree;
    }

    static /* synthetic */ boolean access$17(SyntaxColoringPreferencePage syntaxColoringPreferencePage) {
        return syntaxColoringPreferencePage.syntaxHltEnabled;
    }

    static /* synthetic */ ColorFieldEditor access$18(SyntaxColoringPreferencePage syntaxColoringPreferencePage) {
        return syntaxColoringPreferencePage.syntaxHltBgEditor;
    }

    static /* synthetic */ Composite access$19(SyntaxColoringPreferencePage syntaxColoringPreferencePage) {
        return syntaxColoringPreferencePage.syntaxHltColorGrp;
    }

    static /* synthetic */ ColorFieldEditor access$20(SyntaxColoringPreferencePage syntaxColoringPreferencePage) {
        return syntaxColoringPreferencePage.syntaxHltFgEditor;
    }
}

