/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.util;

import com.iscobol.compiler.Errors;
import java.io.File;

public class ErrorObj {
    public static final String rcsid = "$Id: ErrorObj.java,v 1.7 2008/07/04 14:51:47 gianni Exp $";
    private int errorNumber;
    private int errorType;
    private int lineNumber;
    private int offset;
    private String message;
    private String filename;
    private String pathFilename;
    private String other;

    public ErrorObj(int num, int s, int line, int offs, String file, String msg, String other) {
        this.errorNumber = num;
        this.errorType = s;
        this.lineNumber = line;
        this.offset = offs;
        this.message = msg;
        this.pathFilename = file = file.replace('\\', '/');
        this.filename = new File(file).getName();
        this.other = other;
    }

    public int getErrorNumber() {
        return this.errorNumber;
    }

    public int getErrorType() {
        return this.errorType;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getMessage() {
        return this.message;
    }

    public String getPathFilename() {
        return this.pathFilename;
    }

    public String getOther() {
        return this.other;
    }

    public String getFilename() {
        return this.filename;
    }

    public String toString() {
        String mess;
        switch (this.errorType) {
            case 1: {
                mess = "--I: ";
                break;
            }
            case 2: {
                mess = "--W: ";
                break;
            }
            case 3: {
                mess = "--E: ";
                break;
            }
            case 4: {
                mess = "--S: ";
                break;
            }
            default: {
                mess = "--?: ";
            }
        }
        mess = String.valueOf(mess) + "#" + this.errorNumber + " ";
        mess = String.valueOf(mess) + Errors.getErrorDescription((int)this.errorNumber);
        if (this.other != null) {
            mess = String.valueOf(mess) + " " + this.other;
        }
        mess = String.valueOf(mess) + "; file = " + this.filename;
        if (this.lineNumber > 0) {
            mess = String.valueOf(mess) + ", line = " + this.lineNumber;
        }
        if (this.offset > 0) {
            mess = String.valueOf(mess) + ", col " + this.offset;
        }
        return mess;
    }
}

