/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.util;

import com.iscobol.compiler.Errors;
import com.vcobol.plugins.editor.util.ErrorObj;
import java.util.Vector;

public class ErrorsExt
extends Errors {
    private static final long serialVersionUID = 1L;
    private boolean wu;

    public ErrorsExt(boolean wu) {
        this.wu = wu;
    }

    public ErrorsExt() {
        this(false);
    }

    public void print(int num, int s, int lineNum, int offset, String other, Exception syserr, String file) {
        String mess;
        switch (s) {
            case 1: {
                mess = "--I: ";
                break;
            }
            case 2: {
                mess = "--W: ";
                break;
            }
            case 3: {
                mess = "--E: ";
                break;
            }
            case 4: {
                mess = "--S: ";
                break;
            }
            default: {
                mess = "--?: ";
            }
        }
        mess = String.valueOf(mess) + "#" + num + " ";
        mess = String.valueOf(mess) + (String)errorDesc.get(new Integer(num));
        if (other != null) {
            mess = String.valueOf(mess) + " " + other;
        }
        this.allMessages.addElement(new ErrorObj(num, s, lineNum, offset, file, mess, other));
        switch (s) {
            case 1: {
                ++this.info;
                break;
            }
            case 2: {
                ++this.warning;
                break;
            }
            case 3: {
                ++this.rErrors;
                break;
            }
            case 4: {
                ++this.sErrors;
                break;
            }
        }
    }

    public boolean printEndMessage() {
        return this.sErrors > 0;
    }

    public int getTotalErrorCount() {
        int Return = this.info + this.warning + this.rErrors + this.sErrors;
        if (!this.wu) {
            int i = 0;
            while (i < this.allMessages.size() && Return > 0) {
                ErrorObj err = (ErrorObj)this.allMessages.elementAt(i);
                if (err.getErrorNumber() == 108) {
                    --Return;
                }
                ++i;
            }
        }
        return Return;
    }

    public int getErrorCount(int s) {
        switch (s) {
            case 1: {
                return this.info;
            }
            case 2: {
                int Return = this.warning;
                if (!this.wu) {
                    int i = 0;
                    while (i < this.allMessages.size() && Return > 0) {
                        ErrorObj err = (ErrorObj)this.allMessages.elementAt(i);
                        if (err.getErrorNumber() == 108) {
                            --Return;
                        }
                        ++i;
                    }
                }
                return Return;
            }
            case 3: {
                return this.rErrors;
            }
            case 4: {
                return this.sErrors;
            }
        }
        return 0;
    }

    public Vector getAllMessages() {
        Vector<ErrorObj> Return = new Vector<ErrorObj>();
        if (this.wu) {
            Return.addAll(this.allMessages);
        } else {
            int i = 0;
            while (i < this.allMessages.size()) {
                ErrorObj err = (ErrorObj)this.allMessages.elementAt(i);
                if (err.getErrorNumber() != 108) {
                    Return.addElement(err);
                }
                ++i;
            }
        }
        return Return;
    }

    public Vector getErrors() {
        Vector Return = new Vector();
        Return.addAll(this.allMessages);
        return Return;
    }
}

